/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.application.callback;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.SheetController;
import ch.cyberduck.binding.application.NSOpenPanel;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.controller.InsecureLoginAlertController;
import ch.cyberduck.ui.cocoa.controller.LoginController;
import ch.cyberduck.ui.cocoa.controller.ProgressAlertController;
import ch.iterate.mountainduck.application.ModalPanelAlertRunner;
import ch.iterate.mountainduck.application.callback.ModalPanelPasswordCallback;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;

public class ModalPanelLoginCallback
extends ModalPanelPasswordCallback
implements LoginCallback {
    private static final Logger log = LogManager.getLogger((String)ModalPanelLoginCallback.class.getName());
    private final Preferences preferences = PreferencesFactory.get();

    public ModalPanelLoginCallback() {
    }

    public ModalPanelLoginCallback(Controller controller) {
    }

    public Credentials prompt(Host bookmark, String username, String title, String reason, LoginOptions options) throws LoginCanceledException {
        Credentials credentials;
        LoginController controller;
        if (log.isInfoEnabled()) {
            log.info(String.format("Display login prompt for bookmark %s", bookmark));
        }
        if (new ModalPanelAlertRunner().run(bookmark, (SheetController)(controller = new LoginController(new Host(bookmark).withCredentials(credentials = new Credentials(username)), title, reason, options))) == -1) {
            throw new LoginCanceledException();
        }
        return credentials;
    }

    public Local select(final Local identity) throws LoginCanceledException {
        final CountDownLatch signal = new CountDownLatch(1);
        final AtomicReference selected = new AtomicReference();
        new ProxyController().invoke((MainAction)new DefaultMainAction(){

            public void run() {
                NSObject filename;
                NSOpenPanel select = NSOpenPanel.openPanel();
                select.setCanChooseDirectories(false);
                select.setCanChooseFiles(true);
                select.setAllowsMultipleSelection(false);
                select.setMessage(LocaleFactory.localizedString((String)"Select the private key in PEM or PuTTY format", (String)"Credentials"));
                select.setPrompt(LocaleFactory.localizedString((String)"Choose", (String)"Localizable"));
                if (select.runModal(null == identity ? LocalFactory.get((String)"~/.ssh").getAbsolute() : identity.getParent().getAbsolute(), null == identity ? "" : identity.getName()).intValue() == 1 && (filename = select.URLs().lastObject()) != null) {
                    selected.set(LocalFactory.get((String)((NSURL)Rococoa.cast((ObjCObject)filename, NSURL.class)).path()));
                }
                signal.countDown();
            }
        }, true);
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)signal);
        if (null == selected.get()) {
            throw new LoginCanceledException();
        }
        return (Local)selected.get();
    }

    public void warn(Host bookmark, String title, String message, String defaultButton, String cancelButton, String preference) throws ConnectionCanceledException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Display insecure connection alert for %s", bookmark));
        }
        InsecureLoginAlertController alert = new InsecureLoginAlertController(title, message, defaultButton, cancelButton, bookmark.getProtocol(), StringUtils.isNotBlank((CharSequence)preference));
        int option = new ModalPanelAlertRunner().run(bookmark, (SheetController)alert);
        if (alert.isSuppressed()) {
            this.preferences.setProperty(preference, true);
        }
        switch (option) {
            case -1: {
                throw new LoginCanceledException();
            }
        }
    }

    public void await(CountDownLatch signal, Host bookmark, String title, String message) throws ConnectionCanceledException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Display progress alert for %s", bookmark));
        }
        ProgressAlertController alert = new ProgressAlertController(signal, title, message, bookmark.getProtocol());
        new ModalPanelAlertRunner(false).run(bookmark, (SheetController)alert, signal);
    }
}

