/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.application.callback;

import ch.cyberduck.binding.SheetController;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sftp.SSHFingerprintGenerator;
import ch.cyberduck.core.sftp.openssh.OpenSSHHostKeyVerifier;
import ch.cyberduck.ui.cocoa.controller.ChangedHostKeyAlertController;
import ch.cyberduck.ui.cocoa.controller.UnknownHostKeyAlertController;
import ch.iterate.mountainduck.application.ModalPanelAlertRunner;
import java.security.PublicKey;

public final class ModalPanelHostKeyCallback
extends OpenSSHHostKeyVerifier
implements HostKeyCallback {
    public ModalPanelHostKeyCallback() {
        super(LocalFactory.get((String)PreferencesFactory.get().getProperty("ssh.knownhosts")).withBookmark(PreferencesFactory.get().getProperty("ssh.knownhosts.bookmark")));
    }

    public ModalPanelHostKeyCallback(Controller controller) {
        super(LocalFactory.get((String)PreferencesFactory.get().getProperty("ssh.knownhosts")).withBookmark(PreferencesFactory.get().getProperty("ssh.knownhosts.bookmark")));
    }

    protected boolean isUnknownKeyAccepted(Host hostname, PublicKey key) throws BackgroundException {
        String fingerprint = new SSHFingerprintGenerator().fingerprint(key);
        UnknownHostKeyAlertController alert = new UnknownHostKeyAlertController(hostname.getHostname(), fingerprint, key);
        int select = new ModalPanelAlertRunner().run(hostname, (SheetController)alert);
        switch (select) {
            case 1: {
                this.allow(hostname, key, alert.isSuppressed());
                break;
            }
            case -1: 
            case 0: {
                throw new ConnectionCanceledException();
            }
        }
        return true;
    }

    protected boolean isChangedKeyAccepted(Host hostname, PublicKey key) throws BackgroundException {
        String fingerprint = new SSHFingerprintGenerator().fingerprint(key);
        ChangedHostKeyAlertController alert = new ChangedHostKeyAlertController(hostname.getHostname(), fingerprint, key);
        int select = new ModalPanelAlertRunner().run((SheetController)alert);
        switch (select) {
            case 1: {
                this.allow(hostname, key, alert.isSuppressed());
                break;
            }
            case -1: 
            case 0: {
                throw new ConnectionCanceledException();
            }
        }
        return true;
    }
}

