/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.application.callback;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.SheetController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DefaultProviderHelpService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.diagnostics.ReachabilityFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.DefaultFailureDiagnostics;
import ch.cyberduck.core.threading.FailureDiagnostics;
import ch.cyberduck.ui.cocoa.controller.BackgroundExceptionAlertController;
import ch.iterate.mountainduck.application.ModalPanelAlertRunner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModalPanelAlertCallback
extends ProxyController
implements AlertCallback {
    private static final Logger log = LogManager.getLogger((String)ModalPanelAlertCallback.class.getName());

    public ModalPanelAlertCallback() {
    }

    public ModalPanelAlertCallback(Controller controller) {
    }

    public boolean alert(final Host bookmark, BackgroundException failure, StringBuilder transcript) {
        FailureDiagnostics.Type type = new DefaultFailureDiagnostics().determine(failure);
        switch (type) {
            case cancel: {
                return false;
            }
        }
        if (log.isWarnEnabled()) {
            log.warn(String.format("Display alert for failure %s", new Object[]{failure}));
        }
        BackgroundExceptionAlertController alert = new BackgroundExceptionAlertController(failure, bookmark, LocaleFactory.localizedString((String)"Try Again", (String)"Alert"), type == FailureDiagnostics.Type.network ? LocaleFactory.localizedString((String)"Disconnect", (String)"Main") : LocaleFactory.localizedString((String)"Cancel", (String)"Alert")){

            protected void loadBundle(NSAlert alert) {
                alert.window().setTitle(BookmarkNameProvider.toString((Host)bookmark));
                super.loadBundle(alert);
            }
        };
        int returncode = new ModalPanelAlertRunner().run(bookmark, (SheetController)alert);
        switch (returncode) {
            case 0: {
                switch (type) {
                    case network: {
                        ReachabilityFactory.get().diagnose(bookmark);
                        break;
                    }
                    case quota: {
                        BrowserLauncherFactory.get().open(new DefaultProviderHelpService().help(bookmark.getProtocol()));
                    }
                }
                break;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }
}

