/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.application;

import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSOpenPanel;
import ch.cyberduck.binding.application.NSPathControl;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.formatter.BinarySizeFormatter;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sparkle.Sandbox;
import ch.iterate.mountainduck.fs.ConnectMode;
import java.text.MessageFormat;
import org.rococoa.Foundation;

public class SyncPreferencesPanelController
extends BundleController
implements NSPathControl.Delegate {
    private final Preferences preferences = PreferencesFactory.get();
    private NSView panelSync;
    private NSPopUpButton syncPopup;
    private NSButton syncIndexCheckbox;
    private NSPathControl syncCachePathControl;
    private NSButton enableCacheCheckbox;
    private NSButton lockingButton;
    private NSPathControl mountLocationPathControl;
    private NSButton cachePurgeSizeCheckbox;
    private NSPopUpButton cachePurgeSizePopup;
    private NSButton cachePurgeLruCheckbox;
    private NSPopUpButton cachePurgeLruPopup;

    protected String getBundleName() {
        return "Sync";
    }

    public void setSyncPopup(NSPopUpButton b) {
        this.syncPopup = b;
        this.syncPopup.removeAllItems();
        for (ConnectMode mode : ConnectMode.values()) {
            if (!this.preferences.getList("fs.sync.mode.enabled").contains(mode.name())) continue;
            this.syncPopup.addItemWithTitle(mode.toString());
            this.syncPopup.lastItem().setToolTip(mode.tooltip());
            this.syncPopup.lastItem().setRepresentedObject(mode.name());
        }
        this.syncPopup.setEnabled(this.preferences.getList("fs.sync.mode.enabled").size() > 1);
        this.syncPopup.setTarget(this.id());
        this.syncPopup.setAction(Foundation.selector((String)"syncPopupClicked:"));
        this.syncPopup.selectItemAtIndex(this.syncPopup.indexOfItemWithRepresentedObject(this.preferences.getProperty("fs.sync.mode")));
    }

    public void syncPopupClicked(NSPopUpButton sender) {
        this.preferences.setProperty("fs.sync.mode", sender.selectedItem().representedObject());
    }

    public void setSyncIndexCheckbox(NSButton b) {
        this.syncIndexCheckbox = b;
        this.syncIndexCheckbox.setTarget(this.id());
        this.syncIndexCheckbox.setAction(Foundation.selector((String)"syncIndexCheckboxClicked:"));
        this.syncIndexCheckbox.setState(this.preferences.getBoolean("fs.sync.indexer.enable") ? 1 : 0);
    }

    public void syncIndexCheckboxClicked(NSButton sender) {
        this.preferences.setProperty("fs.sync.indexer.enable", sender.state() == 1);
    }

    public void setSyncCachePathControl(NSPathControl control) {
        this.syncCachePathControl = control;
        this.syncCachePathControl.setURL(NSURL.fileURLWithPath((String)this.preferences.getProperty("fs.sync.cache.directory")));
        this.syncCachePathControl.setTarget(this.id());
        this.syncCachePathControl.setAction(Foundation.selector((String)"syncCachePathControlClicked:"));
        this.syncCachePathControl.setDelegate(this.id());
    }

    public void syncCachePathControlClicked(NSPathControl sender) {
        Local selected = LocalFactory.get((String)sender.URL().path());
        if (selected.attributes().getPermission().isWritable()) {
            this.preferences.setProperty("fs.sync.cache.directory", selected.getAbsolute());
            this.preferences.setProperty("fs.sync.cache.directory.bookmark", selected.getBookmark());
        } else {
            this.syncCachePathControl.setURL(NSURL.fileURLWithPath((String)this.preferences.getDefault("fs.sync.cache.directory")));
        }
    }

    public void setEnableCacheCheckbox(NSButton b) {
        this.enableCacheCheckbox = b;
        this.enableCacheCheckbox.setTarget(this.id());
        this.enableCacheCheckbox.setAction(Foundation.selector((String)"enableCacheCheckboxClicked:"));
        this.enableCacheCheckbox.setState(this.preferences.getBoolean("fs.buffer.enable") ? 1 : 0);
    }

    public void enableCacheCheckboxClicked(NSButton sender) {
        this.preferences.setProperty("fs.buffer.enable", sender.state() == 1);
    }

    public void setLockingButton(NSButton b) {
        this.lockingButton = b;
        this.lockingButton.setTarget(this.id());
        this.lockingButton.setAction(Foundation.selector((String)"lockingButtonClicked:"));
        this.lockingButton.setState(this.preferences.getBoolean("fs.lock.enable") ? 1 : 0);
    }

    public void lockingButtonClicked(NSButton sender) {
        this.preferences.setProperty("fs.lock.enable", sender.state() == 1);
    }

    public void setMountLocationPathControl(NSPathControl control) {
        this.mountLocationPathControl = control;
        this.mountLocationPathControl.setEnabled(!Sandbox.get().isSandboxed());
        this.mountLocationPathControl.setURL(NSURL.fileURLWithPath((String)this.preferences.getProperty("mount.directory")));
        this.mountLocationPathControl.setTarget(this.id());
        this.mountLocationPathControl.setAction(Foundation.selector((String)"mountLocationPathControlClicked:"));
        this.mountLocationPathControl.setDelegate(this.id());
    }

    public void mountLocationPathControlClicked(NSPathControl sender) {
        Local selected = LocalFactory.get((String)sender.URL().path());
        if (selected.attributes().getPermission().isWritable()) {
            this.preferences.setProperty("mount.directory", selected.getAbsolute());
            this.preferences.setProperty("mount.directory.bookmark", selected.getBookmark());
        } else {
            this.mountLocationPathControl.setURL(NSURL.fileURLWithPath((String)this.preferences.getDefault("mount.directory")));
        }
    }

    public void pathControl_willDisplayOpenPanel(NSPathControl control, NSOpenPanel panel) {
        panel.setAllowsMultipleSelection(false);
        panel.setCanChooseDirectories(true);
        panel.setCanChooseFiles(false);
        panel.setShowsHiddenFiles(true);
        switch (control.action().getName()) {
            case "syncCachePathControlClicked": {
                panel.setDirectoryURL(NSURL.fileURLWithPath((String)this.preferences.getDefault("fs.sync.cache.directory")));
                break;
            }
            case "mountLocationPathControlClicked": {
                panel.setDirectoryURL(NSURL.fileURLWithPath((String)this.preferences.getDefault("mount.directory")));
            }
        }
        panel.setPrompt(LocaleFactory.localizedString((String)"Choose"));
    }

    public void setCachePurgeSizeCheckbox(NSButton b) {
        this.cachePurgeSizeCheckbox = b;
        this.cachePurgeSizeCheckbox.setTarget(this.id());
        this.cachePurgeSizeCheckbox.setAction(Foundation.selector((String)"cachePurgeSizeCheckboxClicked:"));
        this.cachePurgeSizeCheckbox.setState(this.preferences.getBoolean("fs.sync.cache.indexer.strategy.size.enable") ? 1 : 0);
    }

    public void cachePurgeSizeCheckboxClicked(NSButton sender) {
        this.preferences.setProperty("fs.sync.cache.indexer.strategy.size.enable", sender.state() == 1);
    }

    public void setCachePurgeSizePopup(NSPopUpButton b) {
        this.cachePurgeSizePopup = b;
        this.cachePurgeSizePopup.removeAllItems();
        for (String option : this.preferences.getList("fs.sync.cache.indexer.strategy.size.limit.options")) {
            this.cachePurgeSizePopup.addItemWithTitle(new BinarySizeFormatter().format(Long.parseLong(option)));
            this.cachePurgeSizePopup.lastItem().setRepresentedObject(option);
        }
        this.cachePurgeSizePopup.setEnabled(this.preferences.getList("fs.sync.cache.indexer.strategy.size.limit.options").size() > 1);
        this.cachePurgeSizePopup.setTarget(this.id());
        this.cachePurgeSizePopup.setAction(Foundation.selector((String)"cachePurgeSizePopupClicked:"));
        this.cachePurgeSizePopup.selectItemAtIndex(this.cachePurgeSizePopup.indexOfItemWithRepresentedObject(this.preferences.getProperty("fs.sync.cache.indexer.strategy.size.limit")));
    }

    public void cachePurgeSizePopupClicked(NSPopUpButton sender) {
        this.preferences.setProperty("fs.sync.cache.indexer.strategy.size.limit", sender.selectedItem().representedObject());
    }

    public void setCachePurgeLruCheckbox(NSButton b) {
        this.cachePurgeLruCheckbox = b;
        this.cachePurgeLruCheckbox.setTarget(this.id());
        this.cachePurgeLruCheckbox.setAction(Foundation.selector((String)"cachePurgeLruCheckboxClicked:"));
        this.cachePurgeLruCheckbox.setState(this.preferences.getBoolean("fs.sync.cache.indexer.strategy.lru.enable") ? 1 : 0);
    }

    public void cachePurgeLruCheckboxClicked(NSButton sender) {
        this.preferences.setProperty("fs.sync.cache.indexer.strategy.lru.enable", sender.state() == 1);
    }

    public void setCachePurgeLruPopup(NSPopUpButton b) {
        this.cachePurgeLruPopup = b;
        this.cachePurgeLruPopup.removeAllItems();
        for (String option : this.preferences.getList("fs.sync.cache.indexer.strategy.lru.retention.days.options")) {
            this.cachePurgeLruPopup.addItemWithTitle(MessageFormat.format(LocaleFactory.localizedString((String)"{0} Days", (String)"Disk"), option));
            this.cachePurgeLruPopup.lastItem().setRepresentedObject(option);
        }
        this.cachePurgeLruPopup.setEnabled(this.preferences.getList("fs.sync.cache.indexer.strategy.lru.retention.days.options").size() > 1);
        this.cachePurgeLruPopup.setTarget(this.id());
        this.cachePurgeLruPopup.setAction(Foundation.selector((String)"cachePurgeLruPopupClicked:"));
        this.cachePurgeLruPopup.selectItemAtIndex(this.cachePurgeLruPopup.indexOfItemWithRepresentedObject(this.preferences.getProperty("fs.sync.cache.indexer.strategy.lru.retention.days")));
    }

    public void cachePurgeLruPopupClicked(NSPopUpButton sender) {
        this.preferences.setProperty("fs.sync.cache.indexer.strategy.lru.retention.days", sender.selectedItem().representedObject());
    }

    public void setPanelSync(NSView panel) {
        this.panelSync = panel;
    }

    public NSView getPanel() {
        return this.panelSync;
    }
}

