/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.application;

import ch.cyberduck.binding.ToolbarWindowController;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.controller.PreferencesController;
import ch.cyberduck.ui.cocoa.delegate.AbstractMenuDelegate;
import ch.iterate.mountainduck.application.LoginItemPreferencesPanelController;
import ch.iterate.mountainduck.application.NotificationsPreferencesPanelController;
import ch.iterate.mountainduck.application.SyncPreferencesPanelController;
import ch.iterate.mountainduck.service.ErrorsMetadataDumpService;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import org.apache.commons.collections4.map.ListOrderedMap;

public class StatusBarPreferencesController
extends PreferencesController {
    private final Preferences preferences = PreferencesFactory.get();
    private final AbstractMenuDelegate menu;
    private final LoginItemPreferencesPanelController loginItemPanelController;
    private final SyncPreferencesPanelController syncPanelController;
    private final NotificationsPreferencesPanelController notificationsPreferencesPanelController;
    private ListOrderedMap<ToolbarWindowController.Label, NSView> panels;
    private static PreferencesController shared = null;

    public StatusBarPreferencesController(AbstractMenuDelegate menu) {
        this.menu = menu;
        this.loginItemPanelController = new LoginItemPreferencesPanelController(menu);
        this.syncPanelController = new SyncPreferencesPanelController();
        this.notificationsPreferencesPanelController = new NotificationsPreferencesPanelController();
    }

    public void loadBundle() {
        this.loginItemPanelController.loadBundle();
        this.syncPanelController.loadBundle();
        this.notificationsPreferencesPanelController.loadBundle();
        super.loadBundle();
    }

    public void awakeFromNib() {
        this.panels = ListOrderedMap.listOrderedMap((Map)super.getPanels());
        if (this.preferences.getBoolean(String.format("preferences.%s.enable", SyncPreferencesToolbarItem.notifications.name()))) {
            this.panels.put(1, (Object)new SyncPreferencesLabel(SyncPreferencesToolbarItem.notifications), (Object)this.notificationsPreferencesPanelController.getPanel());
        }
        if (this.preferences.getBoolean(String.format("preferences.%s.enable", SyncPreferencesToolbarItem.sync.name()))) {
            this.panels.put(1, (Object)new SyncPreferencesLabel(SyncPreferencesToolbarItem.sync), (Object)this.syncPanelController.getPanel());
        }
        if (this.preferences.getBoolean(String.format("preferences.%s.enable", SyncPreferencesToolbarItem.loginitem.name()))) {
            if (this.panels.indexOf((Object)new PreferencesController.PreferencesLabel(PreferencesController.PreferencesToolbarItem.connection)) != -1) {
                this.panels.put(this.panels.indexOf((Object)new PreferencesController.PreferencesLabel(PreferencesController.PreferencesToolbarItem.connection)) + 1, (Object)new SyncPreferencesLabel(SyncPreferencesToolbarItem.loginitem), (Object)this.loginItemPanelController.getPanel());
            } else {
                this.panels.put((Object)new SyncPreferencesLabel(SyncPreferencesToolbarItem.loginitem), (Object)this.loginItemPanelController.getPanel());
            }
        }
        super.awakeFromNib();
    }

    protected Map<ToolbarWindowController.Label, NSView> getPanels() {
        return this.panels;
    }

    public void bookmarkSizePopupClicked(NSPopUpButton sender) {
        super.bookmarkSizePopupClicked(sender);
        this.menu.setNeedsUpdate(true);
    }

    public void logShowButtonClicked(final NSButton sender) {
        sender.setEnabled(false);
        Executors.newSingleThreadExecutor().submit(new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    new ErrorsMetadataDumpService().dump();
                }
                catch (Throwable throwable) {
                    StatusBarPreferencesController.this.invoke((MainAction)new DefaultMainAction(){

                        public void run() {
                            sender.setEnabled(true);
                        }
                    });
                    throw throwable;
                }
                StatusBarPreferencesController.this.invoke((MainAction)new /* invalid duplicate definition of identical inner class */);
                return null;
            }
        });
        super.logShowButtonClicked(sender);
    }

    protected static enum SyncPreferencesToolbarItem {
        notifications{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"Notifications", (String)"Notifications");
            }

            @Override
            public String image() {
                return "bell.badge";
            }
        }
        ,
        loginitem{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"Login Item", (String)"Loginitem");
            }
        }
        ,
        sync{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"Sync", (String)"Disk");
            }
        };


        public abstract String label();

        public String image() {
            return String.format("preferences-%s.pdf", this.name());
        }
    }

    protected static class SyncPreferencesLabel
    extends ToolbarWindowController.Label {
        public SyncPreferencesLabel(SyncPreferencesToolbarItem item) {
            super(item.name(), item.label(), item.image());
        }
    }

    public static class Factory {
        private Factory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PreferencesController instance(AbstractMenuDelegate menu) {
            NSApplication nSApplication = NSApplication.sharedApplication();
            synchronized (nSApplication) {
                if (null == shared) {
                    shared = new StatusBarPreferencesController(menu){

                        public void invalidate() {
                            shared = null;
                        }
                    };
                    shared.loadBundle();
                }
                return shared;
            }
        }
    }
}

