/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.application;

import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSStatusItem;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.transfer.TransferProgress;
import ch.iterate.mountainduck.indexer.DirectoryIndexer;
import ch.iterate.mountainduck.service.BackgroundStatusListener;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatusBarIconListener
implements BackgroundStatusListener {
    private static final Logger log = LogManager.getLogger((String)StatusBarIconListener.class.getName());
    private final NSStatusItem status;
    private final NSImage idle;
    private final NSImage paused;
    private int image;
    private Timer timer;

    public StatusBarIconListener(NSStatusItem status) {
        this(status, (NSImage)IconCacheFactory.get().iconNamed(String.format("app-%s.tiff", PreferencesFactory.get().getProperty("app.icon.idle.index")), Integer.valueOf(16)), (NSImage)IconCacheFactory.get().iconNamed(String.format("app-%s.tiff", PreferencesFactory.get().getProperty("app.icon.pause.index")), Integer.valueOf(16)));
    }

    public StatusBarIconListener(NSStatusItem status, NSImage idle, NSImage paused) {
        this.status = status;
        this.idle = idle;
        this.idle.setTemplate(true);
        this.paused = paused;
        this.paused.setTemplate(true);
        this.image = 0;
    }

    public void refresh(SyncQueue.Status status) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Refresh with status %s", status));
        }
        switch (status) {
            case idle: 
            case paused: 
            case pausing: 
            case stopped: {
                this.stop(status);
                break;
            }
            case busy: {
                this.start();
            }
        }
    }

    public void refresh(DirectoryIndexer.Status status) {
    }

    public void refresh(TransferProgress progress) {
    }

    private synchronized void start() {
        if (null == this.timer) {
            if (log.isInfoEnabled()) {
                log.info("Start status image animation");
            }
            this.timer = new Timer("icon", true);
            this.timer.schedule(new TimerTask(){
                private final boolean reverse = PreferencesFactory.get().getBoolean("app.icon.animation.reverse");
                int increment = 1;

                @Override
                public void run() {
                    StatusBarIconListener.this.image = Math.abs((StatusBarIconListener.this.image + this.increment) % 10);
                    if (9 == StatusBarIconListener.this.image || 0 == StatusBarIconListener.this.image) {
                        if (this.reverse) {
                            this.increment = -this.increment;
                        } else if (9 == StatusBarIconListener.this.image) {
                            StatusBarIconListener.this.image = 0;
                        }
                    }
                    String name = String.format("app-%d.tiff", StatusBarIconListener.this.image);
                    NSImage img = (NSImage)IconCacheFactory.get().iconNamed(name, Integer.valueOf(16));
                    if (null == img) {
                        log.error(String.format("Failure loading image %s", name));
                        return;
                    }
                    img.setTemplate(true);
                    StatusBarIconListener.this.status.button().setImage(img);
                }
            }, 0L, 100L);
        }
    }

    private synchronized void stop(SyncQueue.Status queue) {
        if (this.timer != null) {
            if (log.isInfoEnabled()) {
                log.info("Stop status image animation");
            }
            this.timer.cancel();
            this.timer = null;
        }
        switch (queue) {
            case paused: 
            case pausing: 
            case stopped: {
                this.status.button().setImage(this.paused);
                break;
            }
            default: {
                this.status.button().setImage(this.idle);
            }
        }
    }
}

