/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.application;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSStatusBar;
import ch.cyberduck.binding.application.NSStatusItem;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSNotificationCenter;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DisabledTranscriptListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.local.RevealService;
import ch.cyberduck.core.logging.UnifiedSystemLogTranscriptListener;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.iterate.mountainduck.application.ModalPanelAlertRunner;
import ch.iterate.mountainduck.application.StatusBarIconListener;
import ch.iterate.mountainduck.application.menu.StatusBarBookmarkMenuDelegate;
import ch.iterate.mountainduck.application.menu.StatusBarSearchController;
import ch.iterate.mountainduck.fs.ConnectCallback;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.fs.FileidMapperFactory;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemController;
import ch.iterate.mountainduck.fs.FilesystemDirectoryGenerations;
import ch.iterate.mountainduck.fs.FilesystemDirectoryGenerationsFactory;
import ch.iterate.mountainduck.fs.FilesystemMountBackgroundAction;
import ch.iterate.mountainduck.fs.FilesystemMountRegistry;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.fs.FilesystemOperationsFactory;
import ch.iterate.mountainduck.fs.FilesystemUnmountBackgroundAction;
import ch.iterate.mountainduck.fs.UnpairBackgroundAction;
import ch.iterate.mountainduck.fs.nfs.NfsFilesystem;
import ch.iterate.mountainduck.service.BackgroundStatusListener;
import ch.iterate.mountainduck.service.FileBadgeService;
import ch.iterate.mountainduck.service.MountRegistryBackgroundStatusListener;
import ch.iterate.mountainduck.service.MultipleBackgroundStatusListener;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.service.WorkspaceReloadService;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.Foundation;

public class StatusBarController
extends ProxyController
implements ConnectCallback {
    private static final Logger log = LogManager.getLogger((String)StatusBarController.class.getName());
    private final NSStatusBar statusBar = NSStatusBar.systemStatusBar();
    private final NSStatusItem statusItem = this.statusBar.statusItemWithLength(NSStatusBar.NSSquareStatusItemLength);
    private final NSMenu mainMenu = NSMenu.menu();
    private final StatusBarBookmarkMenuDelegate bookmarkMenuDelegate;
    private NSImage icon;
    private final AbstractHostCollection bookmarks;
    private final FileBadgeService badge;
    private final TranscriptListener transcript = PreferencesFactory.get().getBoolean("connection.transcript.enable") ? new UnifiedSystemLogTranscriptListener() : new DisabledTranscriptListener();
    private final FilesystemMountRegistry mounts = FilesystemMountRegistry.get();
    private final StatusBarSearchController searchController;

    public StatusBarController(AbstractHostCollection bookmarks, AbstractHostCollection history, AbstractHostCollection bonjour, FileBadgeService badge) {
        this((NSImage)IconCacheFactory.get().iconNamed("app-idle.tiff", Integer.valueOf(16)), bookmarks, history, bonjour, badge);
    }

    public StatusBarController(NSImage icon, AbstractHostCollection bookmarks, AbstractHostCollection history, AbstractHostCollection bonjour, FileBadgeService badge) {
        this.icon = icon;
        this.bookmarks = bookmarks;
        this.badge = badge;
        this.searchController = new StatusBarSearchController();
        this.bookmarkMenuDelegate = new StatusBarBookmarkMenuDelegate(this, this.searchController, bookmarks, history, bonjour);
        NSNotificationCenter.defaultCenter().addObserver(this.id(), Foundation.selector((String)"searchFieldTextDidChange:"), "NSControlTextDidChangeNotification", this.searchController.getSearchField().id());
        this.badge.withListener((BackgroundStatusListener)new MountRegistryBackgroundStatusListener((BackgroundStatusListener)new MultipleBackgroundStatusListener(new BackgroundStatusListener[]{new StatusBarIconListener(this.statusItem), this.bookmarkMenuDelegate})));
        this.icon.setTemplate(true);
        this.statusItem.button().setImage(icon);
        this.mainMenu.setAutoenablesItems(false);
        this.mainMenu.setDelegate(this.bookmarkMenuDelegate.id());
        this.statusItem.setMenu(this.mainMenu);
    }

    public void connect(Host bookmark, RevealService reveal) {
        FileidMapper fileid = FileidMapperFactory.get();
        FilesystemDirectoryGenerations generations = FilesystemDirectoryGenerationsFactory.get();
        WorkspaceReloadService reload = new WorkspaceReloadService();
        FilesystemOperations operations = FilesystemOperationsFactory.getDefault((Controller)this, (Host)bookmark, (FileidMapper)fileid, (FilesystemDirectoryGenerations)generations, (FileBadgeService)this.badge, (ReloadService)reload, (ConnectCallback)this);
        NfsFilesystem fs = new NfsFilesystem(bookmark, operations, fileid, generations, (ReloadService)reload);
        this.connect((Filesystem)fs, reveal);
    }

    protected void connect(Filesystem fs, RevealService reveal) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Loaded filesystem instance %s", fs));
        }
        this.background((BackgroundAction)new FilesystemMountBackgroundAction((Controller)this, fs, reveal));
        this.bookmarkMenuDelegate.setNeedsUpdate(true);
    }

    public void disconnect(Host bookmark, boolean delete) {
        Filesystem fs = this.mounts.get(bookmark);
        if (null == fs) {
            return;
        }
        this.disconnect(fs);
    }

    protected void disconnect(Filesystem fs) {
        this.disconnect(fs, new FilesystemUnmountBackgroundAction.Callback(){

            public void done(Filesystem fs) {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Unmounted filesystem %s", fs));
                }
                StatusBarController.this.bookmarkMenuDelegate.setNeedsUpdate(true);
            }
        });
    }

    protected Future<Boolean> disconnect(Filesystem fs, FilesystemUnmountBackgroundAction.Callback callback) {
        Future action = new FilesystemController((Controller)this).background((BackgroundAction)new FilesystemUnmountBackgroundAction((Controller)this, fs, callback));
        this.bookmarkMenuDelegate.setNeedsUpdate(true);
        return action;
    }

    public void log(TranscriptListener.Type type, String message) {
        this.transcript.log(type, message);
    }

    public void delete(Collection<Host> collection, Host bookmark) {
        String message = String.format("%s\n%s %s", LocaleFactory.localizedString((String)"Do you want to delete the selected bookmark?", (String)"Localizable"), Character.toString('\u2022'), BookmarkNameProvider.toString((Host)bookmark));
        NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Delete Bookmark", (String)"Main"), (String)message, (String)LocaleFactory.localizedString((String)"Delete", (String)"Main"), (String)LocaleFactory.localizedString((String)"Cancel", (String)"Alert"), null);
        if (new ModalPanelAlertRunner().run(alert) == 1) {
            this.doDelete(collection, bookmark);
        }
    }

    protected void doDelete(Collection<Host> collection, Host bookmark) {
        collection.remove((Object)bookmark);
        Filesystem fs = this.mounts.get(bookmark);
        if (null == fs) {
            this.background((BackgroundAction)new UnpairBackgroundAction(bookmark));
        } else {
            this.disconnect(fs, new FilesystemUnmountBackgroundAction.Callback(){

                public void done(Filesystem fs) {
                    StatusBarController.this.background((BackgroundAction)new UnpairBackgroundAction(fs.getHost()));
                }
            });
        }
    }

    public void searchFieldTextDidChange(NSNotification notification) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Update menu %s", this.mainMenu));
        }
        this.bookmarkMenuDelegate.filter(this.mainMenu, this.searchController.getFilter());
    }
}

