/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.application;

import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.ui.cocoa.controller.BookmarkController;
import ch.cyberduck.ui.cocoa.controller.DefaultBookmarkController;
import ch.iterate.mountainduck.application.StatusBarController;
import ch.iterate.mountainduck.fs.ConnectMode;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemMountRegistry;
import java.util.HashMap;
import java.util.Map;
import org.rococoa.Foundation;
import org.rococoa.ID;

public class StatusBarBookmarkController
extends DefaultBookmarkController
implements FilesystemMountRegistry.Listener {
    private final FilesystemMountRegistry registry = FilesystemMountRegistry.get();
    private NSButton readonlyCheckbox;
    private NSButton deleteButton;
    private NSButton connectButton;
    private NSTextField optionsLabel;
    private NSPopUpButton syncPopup;

    public StatusBarBookmarkController(final StatusBarController controller, final AbstractHostCollection collection, final Host bookmark) {
        super(bookmark);
        this.registry.addListener((FilesystemMountRegistry.Listener)this);
        this.setCallback(new SheetCallback(){

            public void callback(int option) {
                switch (option) {
                    case 1: {
                        StatusBarBookmarkController.this.connectButton.setEnabled(false);
                        controller.connect(bookmark);
                        break;
                    }
                    case -1: {
                        String message = String.format("%s\n%s %s", LocaleFactory.localizedString((String)"Do you want to delete the selected bookmark?", (String)"Localizable"), Character.toString('\u2022'), BookmarkNameProvider.toString((Host)bookmark));
                        NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Delete Bookmark", (String)"Main"), (String)message, (String)LocaleFactory.localizedString((String)"Delete", (String)"Main"), (String)LocaleFactory.localizedString((String)"Cancel", (String)"Alert"), null);
                        StatusBarBookmarkController.this.alert(alert, new SheetCallback(){

                            public void callback(int returncode) {
                                switch (returncode) {
                                    case 1: {
                                        StatusBarBookmarkController.this.window.orderOut(null);
                                        controller.doDelete((Collection<Host>)collection, bookmark);
                                    }
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    public void invalidate() {
        this.registry.removeListener((FilesystemMountRegistry.Listener)this);
        super.invalidate();
    }

    public void setOptionsLabel(NSTextField t) {
        this.optionsLabel = t;
        this.optionsLabel.setStringValue(LocaleFactory.localizedString((String)"Options:", (String)"Disk"));
    }

    public void setReadonlyCheckbox(final NSButton b) {
        this.readonlyCheckbox = b;
        this.readonlyCheckbox.setTarget(this.id());
        this.readonlyCheckbox.setAction(Foundation.selector((String)"readonlyCheckboxClicked:"));
        this.readonlyCheckbox.setTitle(LocaleFactory.localizedString((String)"Read only", (String)"Disk"));
        this.addObserver(new BookmarkController.BookmarkObserver(){

            public void change(Host bookmark) {
                b.setState(Boolean.TRUE.equals(bookmark.getReadonly()) ? 1 : 0);
            }
        });
    }

    public void readonlyCheckboxClicked(NSButton sender) {
        this.bookmark.setReadonly(Boolean.valueOf(sender.state() == 1));
    }

    public void setSyncPopup(final NSPopUpButton syncPopup) {
        this.syncPopup = syncPopup;
        this.syncPopup.removeAllItems();
        this.syncPopup.addItemWithTitle(DEFAULT);
        this.syncPopup.lastItem().setToolTip(ConnectMode.valueOf((String)PreferencesFactory.get().getProperty("fs.sync.mode")).tooltip());
        this.syncPopup.menu().addItem(NSMenuItem.separatorItem());
        for (ConnectMode mode : ConnectMode.values()) {
            if (!this.preferences.getList("fs.sync.mode.enabled").contains(mode.name())) continue;
            this.syncPopup.addItemWithTitle(mode.toString());
            this.syncPopup.lastItem().setToolTip(mode.tooltip());
            this.syncPopup.lastItem().setRepresentedObject(mode.name());
        }
        this.syncPopup.setEnabled(this.preferences.getList("fs.sync.mode.enabled").size() > 1);
        this.syncPopup.setTarget(this.id());
        this.syncPopup.setAction(Foundation.selector((String)"syncPopupClicked:"));
        this.addObserver(new BookmarkController.BookmarkObserver(){

            public void change(Host bookmark) {
                syncPopup.setEnabled(null == StatusBarBookmarkController.this.registry.get(bookmark));
                if (!ConnectMode.isConfigured((Host)bookmark)) {
                    syncPopup.selectItemWithTitle(DEFAULT);
                } else {
                    ConnectMode mode = ConnectMode.get((Host)bookmark);
                    syncPopup.selectItemAtIndex(syncPopup.indexOfItemWithRepresentedObject(mode.name()));
                }
            }
        });
    }

    public void syncPopupClicked(NSPopUpButton sender) {
        if (sender.selectedItem().title().equals(DEFAULT)) {
            ConnectMode.set((Host)this.bookmark, null);
        } else {
            ConnectMode.set((Host)this.bookmark, (ConnectMode)ConnectMode.valueOf((String)sender.selectedItem().representedObject()));
        }
        this.update();
    }

    public void setDeleteButton(NSButton b) {
        this.deleteButton = b;
        this.deleteButton.setTitle(LocaleFactory.localizedString((String)"Delete", (String)"Localizable"));
        this.deleteButton.setTarget(this.id());
        this.deleteButton.setAction(Foundation.selector((String)"closeSheet:"));
        this.deleteButton.setEnabled(true);
    }

    public void setConnectButton(final NSButton b) {
        this.connectButton = b;
        this.connectButton.setTitle(LocaleFactory.localizedString((String)"Connect", (String)"Connection"));
        this.connectButton.setTarget(this.id());
        this.connectButton.setAction(Foundation.selector((String)"closeSheet:"));
        this.addObserver(new BookmarkController.BookmarkObserver(){

            public void change(Host bookmark) {
                b.setEnabled(null == StatusBarBookmarkController.this.registry.get(bookmark));
            }
        });
    }

    public void mounted(Filesystem fs) {
        this.connectButton.setEnabled(null == this.registry.get(this.bookmark));
        this.syncPopup.setEnabled(null == this.registry.get(this.bookmark));
        if (null != this.registry.get(this.bookmark)) {
            this.window.orderOut(null);
        }
    }

    public void unmounted(Filesystem fs) {
        this.connectButton.setEnabled(null == this.registry.get(this.bookmark));
        this.syncPopup.setEnabled(null == this.registry.get(this.bookmark));
    }

    public void cancel(ID sender) {
        this.window.close();
    }

    public boolean validate() {
        if (this.options.password) {
            this.bookmark.getCredentials().setPassword(this.passwordField.stringValue());
        }
        return super.validate();
    }

    public static final class Factory {
        private static final Map<Host, BookmarkController> open = new HashMap<Host, BookmarkController>();

        private Factory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static BookmarkController create(StatusBarController controller, final AbstractHostCollection collection, Host host) {
            NSApplication nSApplication = NSApplication.sharedApplication();
            synchronized (nSApplication) {
                if (!open.containsKey(host)) {
                    StatusBarBookmarkController c = new StatusBarBookmarkController(controller, collection, host){

                        @Override
                        public void invalidate() {
                            open.remove(this.bookmark);
                            super.invalidate();
                        }
                    };
                    c.addObserver(new BookmarkController.BookmarkObserver(){

                        public void change(Host bookmark) {
                            collection.collectionItemChanged((Object)bookmark);
                        }
                    });
                    c.loadBundle();
                    open.put(host, (BookmarkController)c);
                }
                return Factory.get(host);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static BookmarkController get(Host host) {
            NSApplication nSApplication = NSApplication.sharedApplication();
            synchronized (nSApplication) {
                return open.get(host);
            }
        }
    }
}

