/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.application;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.application.AlertSheetReturnCodeMapper;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.application.NSWorkspace;
import ch.cyberduck.binding.foundation.NSAppleEventDescriptor;
import ch.cyberduck.binding.foundation.NSAppleEventManager;
import ch.cyberduck.binding.foundation.NSAppleScript;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.CrashReporter;
import ch.cyberduck.core.DefaultPathKindDetector;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.HistoryCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.HostReaderFactory;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.ProfileReaderFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.ProviderHelpServiceFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.aquaticprime.DisabledLicenseVerifierCallback;
import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.aquaticprime.LicenseFactory;
import ch.cyberduck.core.aquaticprime.LicenseVerifier;
import ch.cyberduck.core.aquaticprime.LicenseVerifierCallback;
import ch.cyberduck.core.azure.AzureProtocol;
import ch.cyberduck.core.b2.B2Protocol;
import ch.cyberduck.core.bonjour.NotificationRendezvousListener;
import ch.cyberduck.core.bonjour.Rendezvous;
import ch.cyberduck.core.bonjour.RendezvousCollection;
import ch.cyberduck.core.bonjour.RendezvousFactory;
import ch.cyberduck.core.bonjour.RendezvousListener;
import ch.cyberduck.core.box.BoxProtocol;
import ch.cyberduck.core.brick.BrickProtocol;
import ch.cyberduck.core.ctera.CteraProtocol;
import ch.cyberduck.core.dav.DAVProtocol;
import ch.cyberduck.core.dav.DAVSSLProtocol;
import ch.cyberduck.core.dropbox.DropboxProtocol;
import ch.cyberduck.core.eue.EueProtocol;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.HostParserException;
import ch.cyberduck.core.freenet.FreenetProtocol;
import ch.cyberduck.core.ftp.FTPProtocol;
import ch.cyberduck.core.ftp.FTPTLSProtocol;
import ch.cyberduck.core.googledrive.DriveProtocol;
import ch.cyberduck.core.googlestorage.GoogleStorageProtocol;
import ch.cyberduck.core.hubic.HubicProtocol;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.importer.CloudMounterBookmarkCollection;
import ch.cyberduck.core.importer.Expandrive3BookmarkCollection;
import ch.cyberduck.core.importer.Expandrive4BookmarkCollection;
import ch.cyberduck.core.importer.Expandrive5BookmarkCollection;
import ch.cyberduck.core.importer.Expandrive6BookmarkCollection;
import ch.cyberduck.core.importer.Expandrive7BookmarkCollection;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.importer.Transmit4BookmarkCollection;
import ch.cyberduck.core.importer.Transmit5BookmarkCollection;
import ch.cyberduck.core.irods.IRODSProtocol;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationLauncherFactory;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.local.DefaultLocalDirectoryFeature;
import ch.cyberduck.core.local.LocalTrashFactory;
import ch.cyberduck.core.local.RevealService;
import ch.cyberduck.core.local.RevealServiceFactory;
import ch.cyberduck.core.local.TemporaryFileService;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import ch.cyberduck.core.logging.LoggerPrintStream;
import ch.cyberduck.core.nextcloud.NextcloudProtocol;
import ch.cyberduck.core.nio.LocalProtocol;
import ch.cyberduck.core.notification.NotificationService;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.oauth.OAuth2TokenListenerRegistry;
import ch.cyberduck.core.onedrive.OneDriveProtocol;
import ch.cyberduck.core.onedrive.SharepointProtocol;
import ch.cyberduck.core.onedrive.SharepointSiteProtocol;
import ch.cyberduck.core.openstack.SwiftProtocol;
import ch.cyberduck.core.owncloud.OwncloudProtocol;
import ch.cyberduck.core.preferences.ApplicationLoginRegistry;
import ch.cyberduck.core.preferences.ApplicationLoginRegistryFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SecurityApplicationGroupSupportDirectoryFinder;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import ch.cyberduck.core.s3.S3Protocol;
import ch.cyberduck.core.sds.SDSProtocol;
import ch.cyberduck.core.sftp.SFTPProtocol;
import ch.cyberduck.core.storegate.StoregateProtocol;
import ch.cyberduck.core.threading.AbstractBackgroundAction;
import ch.cyberduck.core.threading.AutoreleaseActionOperationBatcher;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.BackgroundActionRegistry;
import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.core.updater.PeriodicUpdateChecker;
import ch.cyberduck.core.updater.PeriodicUpdateCheckerFactory;
import ch.cyberduck.core.urlhandler.SchemeHandler;
import ch.cyberduck.core.urlhandler.SchemeHandlerFactory;
import ch.cyberduck.ui.cocoa.controller.BookmarkController;
import ch.iterate.mountainduck.DefaultsProxyLocale;
import ch.iterate.mountainduck.DisabledShutdownTimer;
import ch.iterate.mountainduck.ShutdownTimer;
import ch.iterate.mountainduck.ShutdownTimerFactory;
import ch.iterate.mountainduck.application.ModalPanelAlertRunner;
import ch.iterate.mountainduck.application.StatusBarBookmarkController;
import ch.iterate.mountainduck.application.StatusBarController;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemMountRegistry;
import ch.iterate.mountainduck.fs.FilesystemUnmountBackgroundAction;
import ch.iterate.mountainduck.fs.NotificationFilesystemMountRegistryListener;
import ch.iterate.mountainduck.fs.SchedulerMountRegistryListener;
import ch.iterate.mountainduck.fs.SessionSerializationFilesystemMountRegistryListener;
import ch.iterate.mountainduck.fs.SidebarFilesystemListener;
import ch.iterate.mountainduck.nativity.FIFinderSyncController;
import ch.iterate.mountainduck.nativity.FinderContextMenuService;
import ch.iterate.mountainduck.nativity.FinderImageFileIconService;
import ch.iterate.mountainduck.nativity.NativityControlFactory;
import ch.iterate.mountainduck.nativity.NativityFilesystemMountListener;
import ch.iterate.mountainduck.nativity.NativityService;
import ch.iterate.mountainduck.preferences.ApplicationUserDefaultsPreferences;
import ch.iterate.mountainduck.registration.ExpiryLicenseVerifier;
import ch.iterate.mountainduck.registration.LicenseVerifierChain;
import ch.iterate.mountainduck.registration.UpgradeLicenseVerifier;
import ch.iterate.mountainduck.service.DisabledRevealService;
import ch.iterate.mountainduck.service.FileBadgeService;
import com.liferay.nativity.control.NativityControl;
import com.sun.jna.ptr.ByReference;
import java.io.PrintStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.ObjCObjectByReference;
import org.rococoa.cocoa.foundation.NSUInteger;

public class StatusBarApplication
extends ProxyController
implements NSApplication.Delegate {
    private static final Logger log = LogManager.getLogger((String)StatusBarApplication.class.getName());
    private final NSWorkspace workspace = NSWorkspace.sharedWorkspace();
    private final Preferences preferences = PreferencesFactory.get();
    private final RevealService reveal = RevealServiceFactory.get();
    private AbstractHostCollection sessions;
    private final FilesystemMountRegistry registry = FilesystemMountRegistry.get();
    private final FilesystemMountRegistry.Listener serializeListener = new SessionSerializationFilesystemMountRegistryListener();
    private ShutdownTimer shutdown = new DisabledShutdownTimer();
    private final PeriodicUpdateChecker updater = PeriodicUpdateCheckerFactory.get((Controller)this);
    private final NativityControl nativity = NativityControlFactory.get();
    private final AbstractHostCollection bookmarks = BookmarkCollection.defaultCollection();
    private final HistoryCollection history = HistoryCollection.defaultCollection();
    private final RendezvousCollection bonjour = RendezvousCollection.defaultCollection();
    private StatusBarController controller;
    public static final int kInternetEventClass = 1196773964;
    public static final int kAEGetURL = 1196773964;
    public static final int kAEFetchURL = 1179996748;
    public static final int keyAEResult = 0x2D2D2D2D;

    private StatusBarApplication() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... arguments) {
        AutoreleaseActionOperationBatcher autorelease = new AutoreleaseActionOperationBatcher(Integer.valueOf(1));
        try {
            NSApplication app = NSApplication.sharedApplication();
            ApplicationUserDefaultsPreferences preferences = new ApplicationUserDefaultsPreferences();
            PreferencesFactory.set((Preferences)preferences);
            if (log.isInfoEnabled()) {
                log.info(String.format("Using core version %s", new Preferences.Version()));
            }
            LocaleFactory.set((Locale)new DefaultsProxyLocale(LocaleFactory.get()));
            app.setActivationPolicy(preferences.getBoolean("application.dock.icon.enable") ? NSApplication.NSApplicationActivationPolicy.NSApplicationActivationPolicyRegular.ordinal() : NSApplication.NSApplicationActivationPolicy.NSApplicationActivationPolicyAccessory.ordinal());
            ProtocolFactory protocols = ProtocolFactory.get();
            protocols.register(new Protocol[]{new FTPProtocol(), new FTPTLSProtocol(), new SFTPProtocol(), new DAVProtocol(), new DAVSSLProtocol(), new SwiftProtocol(), new S3Protocol(), new GoogleStorageProtocol(), new AzureProtocol(), new IRODSProtocol(), new DriveProtocol(), new HubicProtocol(), new DropboxProtocol(), new B2Protocol(), new OneDriveProtocol(), new SharepointProtocol(), new SharepointSiteProtocol(), new SDSProtocol(), new StoregateProtocol(), new BrickProtocol(), new NextcloudProtocol(), new OwncloudProtocol(), new LocalProtocol(), new CteraProtocol(), new FreenetProtocol(), new EueProtocol(), new BoxProtocol()});
            protocols.load();
            StatusBarApplication delegate = new StatusBarApplication();
            app.setDelegate(delegate.id());
            app.activateIgnoringOtherApps(false);
            app.run();
        }
        finally {
            autorelease.operate();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean application_openFile(NSApplication app, String filename) {
        Local f;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Open file %s", filename));
        }
        if (!(f = LocalFactory.get((String)filename)).exists()) return false;
        if ("duck".equals(f.getExtension())) {
            try {
                Host bookmark = (Host)HostReaderFactory.get().read(f);
                if (null == bookmark) {
                    return false;
                }
                if (!this.bookmarks.contains((Object)bookmark)) {
                    this.bookmarks.add((Object)bookmark);
                    BookmarkController c = StatusBarBookmarkController.Factory.create(this.controller, this.bookmarks, bookmark);
                    new ModalPanelAlertRunner().run(c.window());
                    return true;
                } else {
                    this.controller.connect(bookmark);
                }
                return true;
            }
            catch (AccessDeniedException e) {
                log.error(e.getMessage());
                return false;
            }
        }
        if ("cyberduckprofile".equals(f.getExtension())) {
            try {
                Protocol profile = (Protocol)ProfileReaderFactory.get().read(f);
                if (null == profile) {
                    return false;
                }
                if (!profile.isEnabled()) return true;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Register profile %s", profile));
                }
                ProtocolFactory.get().register(new Protocol[]{profile});
                Local profiles = LocalFactory.get((Local)SupportDirectoryFinderFactory.get().find(), (String)this.preferences.getProperty("profiles.folder.name"));
                new DefaultLocalDirectoryFeature().mkdir(profiles);
                f.copy(LocalFactory.get((Local)profiles, (String)f.getName()));
                Host bookmark = new Host(profile, profile.getDefaultHostname(), profile.getDefaultPort());
                this.bookmarks.add((Object)bookmark);
                BookmarkController c = StatusBarBookmarkController.Factory.create(this.controller, this.bookmarks, bookmark);
                new ModalPanelAlertRunner().run(c.window());
                return true;
            }
            catch (AccessDeniedException e) {
                log.error(e.getMessage());
                return false;
            }
        } else {
            if (!"mountainducklicense".equals(f.getExtension())) return true;
            License l = LicenseFactory.get((Local)f);
            if (new LicenseVerifierChain(new LicenseVerifier[]{l, new ExpiryLicenseVerifier(l), new UpgradeLicenseVerifier(l)}).verify((LicenseVerifierCallback)new DisabledLicenseVerifierCallback())) {
                try {
                    f.copy(LocalFactory.get((Local)SupportDirectoryFinderFactory.get().find(), (String)f.getName()));
                    NSAlert alert = NSAlert.alert((String)l.toString(), (String)(LocaleFactory.localizedString((String)"Thanks for your purchase!", (String)"Registration") + "\n\n" + LocaleFactory.localizedString((String)"Your registration key has been copied to the Application Support folder.", (String)"License")), (String)LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), null, null);
                    alert.setAlertStyle(1);
                    switch (new ModalPanelAlertRunner().run(alert)) {
                        default: 
                    }
                    this.shutdown.unregister();
                    return true;
                }
                catch (AccessDeniedException e) {
                    log.error(e.getMessage());
                    return false;
                }
            } else {
                NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Not a valid registration key", (String)"License"), (String)LocaleFactory.localizedString((String)"This registration key does not appear to be valid.", (String)"License"), (String)LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), null, null);
                alert.setAlertStyle(0);
                alert.setShowsHelp(true);
                alert.setDelegate(new ProxyController(){

                    public boolean alertShowHelp(NSAlert alert) {
                        BrowserLauncherFactory.get().open(ProviderHelpServiceFactory.get().help());
                        return true;
                    }
                }.id());
                switch (new ModalPanelAlertRunner().run(alert)) {
                    default: 
                }
            }
        }
        return true;
    }

    public boolean application_openTempFile(NSApplication app, String s) {
        return false;
    }

    public boolean applicationShouldOpenUntitledFile(NSApplication app) {
        return false;
    }

    public boolean applicationOpenUntitledFile(NSApplication app) {
        return false;
    }

    public boolean applicationShouldHandleReopen_hasVisibleWindows(NSApplication app, boolean b) {
        return true;
    }

    public void applicationDidFinishLaunching(NSNotification notification) {
        if (this.preferences.getBoolean("application.support.directory.migrate") && !StringUtils.equals((CharSequence)"duck", (CharSequence)PreferencesFactory.get().getProperty("application.container.name"))) {
            Local appdata = SupportDirectoryFinderFactory.get().find();
            Local previous = new SecurityApplicationGroupSupportDirectoryFinder(String.format("G69SCX94XU.%s", "duck")).find();
            if (previous.exists()) {
                try {
                    if (appdata.exists()) {
                        log.warn(String.format("Trashing application support folder %s", appdata));
                        LocalTrashFactory.get().trash(appdata);
                    }
                    log.warn(String.format("Migrate application support folder from %s to %s", previous, appdata));
                    previous.rename(appdata);
                }
                catch (AccessDeniedException e) {
                    log.warn(String.format("Failure migrating %s to security application group directory %s. %s", previous, appdata, e.getMessage()));
                }
            } else {
                log.debug(String.format("No previous application support folder found in %s", previous));
            }
        }
        License license = LicenseFactory.find((LicenseVerifierCallback)new DisabledLicenseVerifierCallback());
        if (log.isInfoEnabled()) {
            log.info(String.format("Registered to %s", license));
        }
        try {
            this.history.load();
            this.bonjour.load();
            this.bookmarks.load();
        }
        catch (AccessDeniedException e) {
            log.error(String.format("Failure %s loading bookmarks", new Object[]{e}));
        }
        if (this.preferences.getBoolean("bookmark.importer.enable")) {
            this.background((BackgroundAction)new ImporterBackgroundAction());
        }
        if (this.preferences.getBoolean("finder.sidebar.favourite.enable")) {
            this.registry.addListener((FilesystemMountRegistry.Listener)new SidebarFilesystemListener());
        }
        this.registry.addListener((FilesystemMountRegistry.Listener)new NotificationFilesystemMountRegistryListener());
        if (this.preferences.getBoolean("browser.serialize")) {
            this.registry.addListener(this.serializeListener);
        }
        this.registry.addListener((FilesystemMountRegistry.Listener)new SchedulerMountRegistryListener());
        FinderImageFileIconService badger = new FinderImageFileIconService(this.nativity);
        this.controller = new StatusBarController(this.bookmarks, (AbstractHostCollection)this.history, (AbstractHostCollection)this.bonjour, (FileBadgeService)badger);
        this.addShutdownHook();
        this.shutdown = ShutdownTimerFactory.get((Controller)this.controller);
        this.shutdown.register(license);
        NotificationServiceFactory.get().addListener(new NotificationService.Listener(){

            public void callback(String identifier) {
                if (Scheme.isURL((String)identifier)) {
                    BrowserLauncherFactory.get().open(identifier);
                } else {
                    Host bookmark = StatusBarApplication.this.bookmarks.lookup(identifier);
                    if (null == bookmark) {
                        if (StringUtils.isNotBlank((CharSequence)identifier)) {
                            log.warn(String.format("No bookmark for %s", identifier));
                            StatusBarApplication.this.reveal.reveal(LocalFactory.get((String)identifier), StatusBarApplication.this.preferences.getBoolean("mount.reveal.url.select"));
                        }
                    } else {
                        Filesystem fs = StatusBarApplication.this.registry.get(bookmark);
                        if (null == fs) {
                            log.warn(String.format("No filesystem for %s", bookmark));
                            return;
                        }
                        if (!StatusBarApplication.this.reveal.reveal(fs.getMountpoint(), StatusBarApplication.this.preferences.getBoolean("mount.reveal.url.select"))) {
                            log.warn(String.format("Failure revealing %s in %s", fs.getMountpoint(), fs));
                        }
                    }
                }
            }
        });
        if (log.isInfoEnabled()) {
            log.info(String.format("Connect to control %s", this.nativity));
        }
        this.registry.addListener((FilesystemMountRegistry.Listener)new NativityFilesystemMountListener((NativityService)new FinderContextMenuService((Controller)this.controller, this.nativity)));
        this.registry.addListener((FilesystemMountRegistry.Listener)new NativityFilesystemMountListener((NativityService)badger, (NativityFilesystemMountListener.Callback)new PluginKitCallback()));
        final Rendezvous rendezvous = RendezvousFactory.instance();
        rendezvous.addListener((RendezvousListener)new NotificationRendezvousListener(rendezvous){

            public void serviceResolved(String identifier, Host host) {
                if (StatusBarApplication.this.preferences.getInteger("rendezvous.notification.limit") > 0) {
                    super.serviceResolved(identifier, host);
                }
            }
        });
        this.background((BackgroundAction)new AbstractBackgroundAction<Void>(){

            public Void run() {
                rendezvous.init();
                return null;
            }
        });
        this.workspace.notificationCenter().addObserver(this.id(), Foundation.selector((String)"finderWillUnmountNotification:"), "NSWorkspaceWillUnmountNotification", null);
        this.sessions = new BookmarkCollection(LocalFactory.get((Local)SupportDirectoryFinderFactory.get().find(), (String)"Sessions"), "session");
        if (this.preferences.getBoolean("browser.serialize")) {
            this.background((BackgroundAction)new AbstractBackgroundAction<Void>(){

                public Void run() throws BackgroundException {
                    StatusBarApplication.this.sessions.load();
                    return null;
                }

                public void cleanup() {
                    Iterator iterator = StatusBarApplication.this.sessions.iterator();
                    while (iterator.hasNext()) {
                        Host host = StatusBarApplication.this.bookmarks.lookup(((Host)iterator.next()).getUuid());
                        if (host != null) {
                            if (log.isInfoEnabled()) {
                                log.info(String.format("New browser for saved session %s", host));
                            }
                            StatusBarApplication.this.controller.connect(host, (RevealService)new DisabledRevealService());
                        }
                        iterator.remove();
                    }
                }
            });
        }
        if (this.preferences.getBoolean("loginitem.enable")) {
            ApplicationLoginRegistry registry = ApplicationLoginRegistryFactory.get();
            registry.register(new Application(this.preferences.getProperty("bundle.identifier"), this.preferences.getProperty("application.name")));
        }
        CrashReporter reporter = CrashReporter.create();
        if (log.isInfoEnabled()) {
            log.info("Check for crash report");
        }
        reporter.checkForCrash(this.preferences.getProperty("website.crash"));
        if (this.preferences.getBoolean("update.check")) {
            this.updater.check(true);
            this.updater.register();
        }
        SchemeHandler schemeHandler = SchemeHandlerFactory.get();
        if (this.preferences.getBoolean("defaulthandler.reminder") && this.preferences.getInteger("uses") > 0 && !schemeHandler.isDefaultHandler(Arrays.asList(Scheme.ftp.name(), Scheme.ftps.name(), Scheme.sftp.name()), new Application(this.preferences.getProperty("application.identifier")))) {
            NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)String.format("Set %s as default application for FTP and SFTP locations?", this.preferences.getProperty("application.name")), (String)"Configuration"), (String)LocaleFactory.localizedString((String)String.format("As the default application, %s will open when you click on FTP or SFTP links in other applications, such as your web browser. You can change this setting in the Preferences later.", this.preferences.getProperty("application.name")), (String)"Configuration"), (String)LocaleFactory.localizedString((String)"Change", (String)"Configuration"), null, (String)LocaleFactory.localizedString((String)"Cancel", (String)"Configuration"));
            alert.setAlertStyle(1);
            alert.setShowsSuppressionButton(true);
            alert.suppressionButton().setTitle(LocaleFactory.localizedString((String)"Don't ask again", (String)"Configuration"));
            int choice = alert.runModal();
            if (alert.suppressionButton().state() == 1) {
                this.preferences.setProperty("defaulthandler.reminder", false);
            }
            if (choice == 1) {
                schemeHandler.setDefaultHandler(new Application(this.preferences.getProperty("application.identifier")), Arrays.asList(Scheme.ftp.name(), Scheme.ftps.name(), Scheme.sftp.name()));
            }
        }
        ProtocolFactory protocols = ProtocolFactory.get();
        if (this.bookmarks.isEmpty()) {
            final Host bookmark = new Host(protocols.forName(this.preferences.getProperty("connection.protocol.default")));
            if (this.preferences.getBoolean("menu.bookmark.add.enable") && this.preferences.getBoolean("menu.bookmark.edit.enable")) {
                this.bookmarks.add((Object)bookmark);
                BookmarkController c = StatusBarBookmarkController.Factory.create(this.controller, this.bookmarks, bookmark);
                new ModalPanelAlertRunner().run(c.window());
            } else {
                this.controller.connect(bookmark, new RevealService(){

                    public boolean reveal(Local local, boolean select) {
                        StatusBarApplication.this.bookmarks.add((Object)bookmark);
                        return PreferencesFactory.get().getBoolean("browser.open.untitled") ? StatusBarApplication.this.reveal.reveal(local, select) : new DisabledRevealService().reveal(local, select);
                    }
                });
            }
        }
        for (String handler : Arrays.asList(this.preferences.getProperty("oauth.handler.scheme"), null == protocols.forType(Protocol.Type.googlestorage) ? null : StringUtils.substringBefore((String)protocols.forType(Protocol.Type.googlestorage).getOAuthRedirectUrl(), (int)58), null == protocols.forType(Protocol.Type.googledrive) ? null : StringUtils.substringBefore((String)protocols.forType(Protocol.Type.googledrive).getOAuthRedirectUrl(), (int)58))) {
            if (null == handler) continue;
            if (log.isInfoEnabled()) {
                log.info(String.format("Register OAuth handler %s", handler));
            }
            schemeHandler.setDefaultHandler(new Application(this.preferences.getProperty("application.identifier")), Collections.singletonList(handler));
        }
        for (Protocol protocol : protocols.find()) {
            String[] schemes;
            for (String scheme : schemes = protocol.getSchemes()) {
                if (!Arrays.stream(Scheme.values()).filter(Predicate.isEqual(Scheme.s3).negate()).noneMatch(s -> s.name().equals(scheme))) continue;
                if (log.isInfoEnabled()) {
                    log.info(String.format("Register custom scheme %s", scheme));
                }
                schemeHandler.setDefaultHandler(new Application(this.preferences.getProperty("application.identifier")), Collections.singletonList(scheme));
            }
        }
        NSAppleEventManager.sharedAppleEventManager().setEventHandler_andSelector_forEventClass_andEventID(this.id(), Foundation.selector((String)"handleGetURLEvent:withReplyEvent:"), 1196773964, 1196773964);
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.checkTerminate(NSApplication.sharedApplication(), true);
            this.applicationWillTerminate(null);
        }));
    }

    public void finderWillUnmountNotification(NSNotification notification) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Received notification %s from workspace", notification.userInfo()));
        }
        if (notification.userInfo().objectForKey("NSDevicePath") == null) {
            log.warn("Missing NSDevicePath in notification dictionary");
            return;
        }
        String device = notification.userInfo().objectForKey("NSDevicePath").toString();
        for (Filesystem fs : this.registry.values()) {
            if (null == fs.getMountpoint() || !device.equals(fs.getMountpoint().getAbsolute())) continue;
            if (log.isInfoEnabled()) {
                log.info(String.format("Handle unmount notification from Finder.app for device %s with filesystem %s", device, fs));
            }
            this.controller.disconnect(fs);
            break;
        }
    }

    public NSUInteger applicationShouldTerminate(NSApplication app) {
        return this.checkTerminate(app, this.preferences.getBoolean("browser.disconnect.confirm"));
    }

    private NSUInteger checkTerminate(final NSApplication app, boolean confirm) {
        OAuth2TokenListenerRegistry oauth = OAuth2TokenListenerRegistry.get();
        oauth.shutdown();
        Set volumes = this.registry.values();
        if (confirm) {
            for (Filesystem fs : volumes) {
                switch (fs.getMountStatus()) {
                    case busy: {
                        NSAlert alert = NSAlert.alert((String)MessageFormat.format(LocaleFactory.localizedString((String)"Disconnect from {0}", (String)"Localizable"), fs.getHost().getHostname()), (String)LocaleFactory.localizedString((String)"The connection will be closed.", (String)"Localizable"), (String)LocaleFactory.localizedString((String)"Disconnect", (String)"Main"), (String)LocaleFactory.localizedString((String)"Cancel", (String)"Alert"), null);
                        alert.setAlertStyle(0);
                        switch (new ModalPanelAlertRunner().run(alert)) {
                            case -1: 
                            case 0: {
                                return NSApplication.NSTerminateCancel;
                            }
                        }
                    }
                }
            }
        }
        this.registry.removeListener(this.serializeListener);
        if (volumes.isEmpty()) {
            return NSApplication.NSTerminateNow;
        }
        final CountDownLatch count = new CountDownLatch(volumes.size());
        for (Filesystem fs : volumes) {
            if (log.isInfoEnabled()) {
                log.info(String.format("Disconnect %s", fs));
            }
            this.controller.disconnect(fs, new FilesystemUnmountBackgroundAction.Callback(){

                public void done(Filesystem fs) {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Unmounted filesystem %s", fs));
                    }
                    count.countDown();
                    if (count.getCount() == 0L) {
                        if (log.isInfoEnabled()) {
                            log.info(String.format("Terminate application %s", app));
                        }
                        app.replyToApplicationShouldTerminate(true);
                    }
                }
            });
        }
        return NSApplication.NSTerminateLater;
    }

    public void applicationWillTerminate(NSNotification notification) {
        this.shutdown.unregister();
        this.nativity.disconnect();
        this.updater.unregister();
        TemporaryFileService temp = TemporaryFileServiceFactory.get();
        if (temp != null) {
            temp.shutdown();
        }
        RendezvousFactory.instance().quit();
        BackgroundActionRegistry actions = this.controller.getRegistry();
        for (BackgroundAction action : (BackgroundAction[])actions.toArray((Object[])new BackgroundAction[actions.size()])) {
            if (action == null) continue;
            action.cancel();
        }
        this.registry.clear();
        this.workspace.notificationCenter().removeObserver(this.id());
        NotificationServiceFactory.get().unregister();
    }

    public boolean applicationShouldTerminateAfterLastWindowClosed(NSApplication app) {
        return false;
    }

    public void updateMenuClicked(ID sender) {
        PeriodicUpdateChecker updater = PeriodicUpdateCheckerFactory.get();
        updater.check(false);
    }

    public void handleGetURLEvent_withReplyEvent(NSAppleEventDescriptor event, NSAppleEventDescriptor reply) {
        log.debug(String.format("Received URL from Apple Event %s", event));
        NSAppleEventDescriptor param = event.paramDescriptorForKeyword(0x2D2D2D2D);
        if (null == param) {
            log.error("No URL parameter");
            return;
        }
        String url = param.stringValue();
        if (StringUtils.isEmpty((CharSequence)url)) {
            log.error("URL parameter is empty");
            return;
        }
        try {
            if (StringUtils.contains((CharSequence)url, (CharSequence)":oauth")) {
                String action = StringUtils.substringAfter((String)url, (String)":oauth");
                List pairs = URLEncodedUtils.parse((URI)URI.create(action), (Charset)Charset.defaultCharset());
                String state = "";
                String code = "";
                for (NameValuePair pair : pairs) {
                    if (StringUtils.equals((CharSequence)pair.getName(), (CharSequence)"state")) {
                        String string = state = StringUtils.equals((CharSequence)pair.getName(), (CharSequence)"state") ? pair.getValue() : "";
                    }
                    if (!StringUtils.equals((CharSequence)pair.getName(), (CharSequence)"code")) continue;
                    code = StringUtils.equals((CharSequence)pair.getName(), (CharSequence)"code") ? pair.getValue() : "";
                }
                OAuth2TokenListenerRegistry oauth = OAuth2TokenListenerRegistry.get();
                oauth.notify(state, code);
            } else if (StringUtils.startsWith((CharSequence)url, (CharSequence)CteraProtocol.CTERA_REDIRECT_URI)) {
                String action = StringUtils.removeStart((String)url, (String)String.format("%s:", this.preferences.getProperty("oauth.handler.scheme")));
                List pairs = URLEncodedUtils.parse((URI)URI.create(action), (Charset)Charset.defaultCharset());
                String code = "";
                for (NameValuePair pair : pairs) {
                    if (!StringUtils.equals((CharSequence)pair.getName(), (CharSequence)"ActivationCode")) continue;
                    code = StringUtils.equals((CharSequence)pair.getName(), (CharSequence)"ActivationCode") ? pair.getValue() : "";
                }
                OAuth2TokenListenerRegistry oauth = OAuth2TokenListenerRegistry.get();
                oauth.notify("", code);
            } else {
                Host host = HostParser.parse((String)url);
                if (!this.reveal(host)) {
                    host.setDefaultPath(host.getProtocol().getDefaultPath());
                    this.bookmarks.add((Object)host);
                    BookmarkController c = StatusBarBookmarkController.Factory.create(this.controller, this.bookmarks, host);
                    new ModalPanelAlertRunner().run(c.window());
                }
            }
        }
        catch (HostParserException e) {
            log.warn(e.getDetail());
        }
    }

    private boolean reveal(Host input) {
        Optional bookmark = this.bookmarks.find(input);
        if (bookmark.isPresent()) {
            String workdir;
            Filesystem fs = this.registry.get((Host)bookmark.get());
            String string = workdir = StringUtils.isEmpty((CharSequence)input.getDefaultPath()) ? String.valueOf('/') : input.getDefaultPath();
            if (null == fs) {
                this.controller.connect((Host)bookmark.get(), (local, select) -> this.reveal(workdir, (Host)bookmark.get(), local));
            } else {
                this.reveal(workdir, (Host)bookmark.get(), fs.getMountpoint());
            }
            return true;
        }
        return false;
    }

    private boolean reveal(String workdir, Host bookmark, Local fallback) {
        String stripped = StringUtils.removeStart((String)workdir, (String)bookmark.getDefaultPath());
        Local local = StringUtils.isBlank((CharSequence)stripped) ? fallback : LocalFactory.get((Local)fallback, (String)stripped);
        switch (new DefaultPathKindDetector().detect(workdir)) {
            case file: {
                if (!ApplicationLauncherFactory.get().open(local)) {
                    log.warn(String.format("Failure opening path %s in %s", local, fallback));
                    return false;
                }
                return true;
            }
        }
        if (!this.reveal.reveal(local)) {
            log.warn(String.format("Failure revealing path %s in %s", local, fallback));
            return false;
        }
        return true;
    }

    static {
        System.err.close();
        System.setErr((PrintStream)new LoggerPrintStream());
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new LoggingUncaughtExceptionHandler());
    }

    private final class ImporterBackgroundAction
    extends AbstractBackgroundAction<Void> {
        private final Preferences preferences = PreferencesFactory.get();
        private final List<ThirdpartyBookmarkCollection> collections;

        public ImporterBackgroundAction() {
            this(Arrays.asList(new Transmit5BookmarkCollection(), new Transmit4BookmarkCollection(), new Expandrive3BookmarkCollection(), new Expandrive4BookmarkCollection(), new Expandrive5BookmarkCollection(), new Expandrive6BookmarkCollection(), new Expandrive7BookmarkCollection(), new CloudMounterBookmarkCollection()));
        }

        public ImporterBackgroundAction(List<ThirdpartyBookmarkCollection> collections) {
            this.collections = collections;
        }

        public Void run() {
            for (ThirdpartyBookmarkCollection t : this.collections) {
                if (!t.isInstalled()) {
                    if (!log.isInfoEnabled()) continue;
                    log.info(String.format("No application installed for %s", t.getBundleIdentifier()));
                    continue;
                }
                try {
                    t.load();
                }
                catch (AccessDeniedException e) {
                    log.warn(String.format("Failure %s loading bookmarks from %s", new Object[]{e, t}));
                }
                if (!t.isEmpty()) continue;
                this.preferences.setProperty(t.getConfiguration(), true);
            }
            return null;
        }

        public void cleanup() {
            for (ThirdpartyBookmarkCollection t : this.collections) {
                t.filter(StatusBarApplication.this.bookmarks);
                if (t.isEmpty()) {
                    this.preferences.setProperty(t.getConfiguration(), true);
                    continue;
                }
                NSAlert alert = NSAlert.alert((String)MessageFormat.format(LocaleFactory.localizedString((String)"Import {0} Bookmarks", (String)"Configuration"), t.getName()), (String)MessageFormat.format(LocaleFactory.localizedString((String)"{0} bookmarks found. Do you want to add these to your bookmarks?", (String)"Configuration"), t.size()), (String)LocaleFactory.localizedString((String)"Import", (String)"Configuration"), null, (String)LocaleFactory.localizedString((String)"Cancel", (String)"Configuration"));
                alert.setShowsSuppressionButton(true);
                alert.suppressionButton().setTitle(LocaleFactory.localizedString((String)"Don't ask again", (String)"Configuration"));
                alert.setAlertStyle(1);
                int choice = new AlertSheetReturnCodeMapper().getOption(alert.runModal());
                if (alert.suppressionButton().state() == 1) {
                    this.preferences.setProperty(t.getConfiguration(), true);
                }
                if (choice != 1) continue;
                StatusBarApplication.this.bookmarks.addAll((Collection)t);
                this.preferences.setProperty(t.getConfiguration(), true);
            }
        }
    }

    private final class PluginKitCallback
    implements NativityFilesystemMountListener.Callback {
        private PluginKitCallback() {
        }

        public void prompt() {
            if (StatusBarApplication.this.preferences.getBoolean("finderextension.prompt.enable")) {
                NSAlert alert = NSAlert.alert((String)LocaleFactory.localizedString((String)"Enable Finder Extension", (String)"Disk"), (String)MessageFormat.format(LocaleFactory.localizedString((String)"Open System Preferences to enable the {0} Finder Extension.", (String)"Disk"), StatusBarApplication.this.preferences.getProperty("application.name")), (String)LocaleFactory.localizedString((String)"Open System Preferences", (String)"Disk"), null, (String)LocaleFactory.localizedString((String)"Cancel", (String)"Configuration"));
                alert.setShowsSuppressionButton(true);
                alert.suppressionButton().setTitle(LocaleFactory.localizedString((String)"Don't ask again", (String)"Configuration"));
                alert.setAlertStyle(1);
                int choice = new AlertSheetReturnCodeMapper().getOption(alert.runModal());
                if (alert.suppressionButton().state() == 1) {
                    StatusBarApplication.this.preferences.setProperty("finderextension.prompt.enable", false);
                }
                if (choice == 1) {
                    if (Factory.Platform.osversion.matches("10\\.(12|13).*")) {
                        ObjCObjectByReference error;
                        String script = "tell application \"System Preferences\"\nactivate\nreveal anchor \"Extensions\" of pane \"com.apple.preferences.extensions\"\nend tell";
                        NSAppleScript as = NSAppleScript.createWithSource((String)"tell application \"System Preferences\"\nactivate\nreveal anchor \"Extensions\" of pane \"com.apple.preferences.extensions\"\nend tell");
                        if (null == as.executeAndReturnError((ByReference)(error = new ObjCObjectByReference()))) {
                            NSDictionary d = (NSDictionary)error.getValueAs(NSDictionary.class);
                            log.warn(String.format("Failure running script %s. %s", "tell application \"System Preferences\"\nactivate\nreveal anchor \"Extensions\" of pane \"com.apple.preferences.extensions\"\nend tell", d.objectForKey("NSAppleScriptErrorBriefMessage")));
                        }
                    } else {
                        FIFinderSyncController.showExtensionManagementInterface();
                    }
                }
            }
        }
    }
}

