/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.application;

import ch.cyberduck.binding.AbstractTableDelegate;
import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.ListDataSource;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSTableColumn;
import ch.cyberduck.binding.application.NSTableView;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.foundation.NSAppleScript;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSNumber;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSString;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.ArrayList;
import java.util.List;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSInteger;

public class NotificationsPreferencesPanelController
extends BundleController {
    private final Preferences preferences = PreferencesFactory.get();
    private NSButton notificationsButton;
    private NSView panelNotifications;
    private NSTableView notificationsTable;
    private ListDataSource notificationsTableModel;
    private AbstractTableDelegate<String, NotificationsColumn> notificationsTableDelegate;
    private final List<Notification> notifications = new ArrayList<Notification>();

    protected String getBundleName() {
        return "Notifications";
    }

    public void setNotificationsTable(NSTableView t) {
        this.notificationsTable = t;
        this.notificationsTable.setAllowsMultipleSelection(false);
        this.notificationsTable.setColumnAutoresizingStyle(NSTableView.NSTableViewUniformColumnAutoresizingStyle);
        this.notifications.add(new Notification(LocaleFactory.localizedString((String)"Filesystem mounted", (String)"Disk"), "connection.mount.notification.enable"));
        this.notifications.add(new Notification(LocaleFactory.localizedString((String)"Filesystem unmounted", (String)"Disk"), "connection.unmount.notification.enable"));
        this.notifications.add(new Notification(LocaleFactory.localizedString((String)"Pause Sync", (String)"Disk"), "fs.sync.queue.reachability.notification.pause.enable"));
        this.notifications.add(new Notification(LocaleFactory.localizedString((String)"Resume Sync", (String)"Disk"), "fs.sync.queue.reachability.notification.resume.enable"));
        this.notifications.add(new Notification(LocaleFactory.localizedString((String)"File Added", (String)"Disk"), "fs.sync.notification.placeholder"));
        this.notifications.add(new Notification(LocaleFactory.localizedString((String)"File Deleted", (String)"Disk"), "fs.sync.notification.delete"));
        this.notifications.add(new Notification(LocaleFactory.localizedString((String)"File Updated", (String)"Disk"), "fs.sync.notification.metadata"));
        this.notifications.add(new Notification(LocaleFactory.localizedString((String)"File Uncached", (String)"Disk"), "fs.sync.notification.purge"));
        this.notifications.add(new Notification(LocaleFactory.localizedString((String)"Download complete", (String)"Status"), "fs.sync.notification.download"));
        this.notifications.add(new Notification(LocaleFactory.localizedString((String)"Upload complete", (String)"Status"), "fs.sync.notification.upload"));
        this.notifications.add(new Notification(LocaleFactory.localizedString((String)"Sync Error", (String)"Disk"), "fs.sync.notification.error"));
        this.notificationsTableModel = new ListDataSource(){

            public NSInteger numberOfRowsInTableView(NSTableView view) {
                return new NSInteger((long)NotificationsPreferencesPanelController.this.notifications.size());
            }

            public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
                if (row.intValue() < NotificationsPreferencesPanelController.this.notifications.size()) {
                    String identifier = tableColumn.identifier();
                    Notification n = (Notification)NotificationsPreferencesPanelController.this.notifications.get(row.intValue());
                    if (identifier.equals(NotificationsColumn.checkbox.name())) {
                        return NSNumber.numberWithBoolean((boolean)NotificationsPreferencesPanelController.this.preferences.getBoolean(n.getProperty()));
                    }
                    if (identifier.equals(NotificationsColumn.description.name())) {
                        return NSString.stringWithString((String)n.getLabel());
                    }
                }
                return null;
            }

            public void tableView_setObjectValue_forTableColumn_row(NSTableView view, NSObject value, NSTableColumn tableColumn, NSInteger row) {
                if (row.intValue() < NotificationsPreferencesPanelController.this.notifications.size()) {
                    String identifier = tableColumn.identifier();
                    Notification n = (Notification)NotificationsPreferencesPanelController.this.notifications.get(row.intValue());
                    if (identifier.equals(NotificationsColumn.checkbox.name())) {
                        NSNumber v = (NSNumber)Rococoa.cast((ObjCObject)value, NSNumber.class);
                        NotificationsPreferencesPanelController.this.preferences.setProperty(n.getProperty(), v.boolValue());
                    }
                }
            }
        };
        this.notificationsTable.setDataSource(this.notificationsTableModel.id());
        this.notificationsTableDelegate = new AbstractTableDelegate<String, NotificationsColumn>(this.notificationsTable.tableColumnWithIdentifier(NotificationsColumn.checkbox.name())){

            public void enterKeyPressed(ID sender) {
            }

            public void deleteKeyPressed(ID sender) {
            }

            public String tooltip(String c, NotificationsColumn column) {
                return c;
            }

            public void tableColumnClicked(NSTableView view, NSTableColumn column) {
            }

            public void tableRowDoubleClicked(ID sender) {
            }

            public void selectionDidChange(NSNotification notification) {
            }

            protected boolean isTypeSelectSupported() {
                return false;
            }
        };
        this.notificationsTable.setDelegate(this.notificationsTableDelegate.id());
        this.notificationsTable.sizeToFit();
    }

    public void notificationsCheckboxButtonClicked(NSButton sender) {
    }

    public void setPanelNotifications(NSView panelNotifications) {
        this.panelNotifications = panelNotifications;
    }

    public void setNotificationsButton(NSButton b) {
        this.notificationsButton = b;
        this.notificationsButton.setTarget(this.id());
        this.notificationsButton.setAction(Foundation.selector((String)"notificationsButtonClicked:"));
    }

    public void notificationsButtonClicked(NSButton sender) {
        String script = "tell application \"System Preferences\"\nactivate\nreveal pane \"com.apple.preference.notifications\"\nend tell";
        NSAppleScript.createWithSource((String)"tell application \"System Preferences\"\nactivate\nreveal pane \"com.apple.preference.notifications\"\nend tell").executeAndReturnError(null);
    }

    public NSView getPanel() {
        return this.panelNotifications;
    }

    private static final class Notification {
        private final String label;
        private final String property;

        public Notification(String label, String property) {
            this.label = label;
            this.property = property;
        }

        public String getLabel() {
            return this.label;
        }

        public String getProperty() {
            return this.property;
        }
    }

    private static enum NotificationsColumn {
        checkbox,
        description;

    }
}

