/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.application;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.SheetController;
import ch.cyberduck.binding.SheetInvoker;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.AlertSheetReturnCodeMapper;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.binding.foundation.NSThread;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.ui.cocoa.controller.BookmarkController;
import ch.iterate.mountainduck.application.StatusBarBookmarkController;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModalPanelAlertRunner
extends ProxyController {
    private static final Logger log = LogManager.getLogger((String)ModalPanelAlertRunner.class.getName());
    private static final NSApplication app = NSApplication.sharedApplication();
    private static final Map<CountDownLatch, NSWindow> awaits = new HashMap<CountDownLatch, NSWindow>();
    private final boolean floating;

    public ModalPanelAlertRunner() {
        this(true);
    }

    public ModalPanelAlertRunner(boolean floating) {
        this.floating = floating;
    }

    private void activate(NSWindow window) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Activate window %s", window));
        }
        window.setHidesOnDeactivate(false);
        window.setPreventsApplicationTerminationWhenModal(false);
        window.center();
        app.activateIgnoringOtherApps(true);
        if (this.floating) {
            window.setLevel(3);
            window.makeKeyAndOrderFront(null);
        } else {
            window.orderFront(null);
        }
    }

    public int run(final NSAlert alert) {
        final CountDownLatch signal = new CountDownLatch(1);
        final AtomicInteger option = new AtomicInteger(-1);
        final NSWindow window = alert.window();
        this.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                ModalPanelAlertRunner.this.activate(window);
                option.set(alert.runModal());
                signal.countDown();
            }
        }, true);
        this.await(signal, alert.window());
        return new AlertSheetReturnCodeMapper().getOption(option.get());
    }

    public int run(Host bookmark, SheetController alert, CountDownLatch signal) {
        BookmarkController parent = StatusBarBookmarkController.Factory.get(bookmark);
        int returncode = null != parent ? new SheetInvoker((SheetCallback)alert, (WindowController)parent, (WindowController)alert, signal).beginSheet() : this.run(alert, signal);
        return returncode;
    }

    public int run(Host bookmark, SheetController alert) {
        BookmarkController parent = StatusBarBookmarkController.Factory.get(bookmark);
        int returncode = null != parent ? new SheetInvoker((SheetCallback)alert, (WindowController)parent, (WindowController)alert).beginSheet() : this.run(alert);
        return returncode;
    }

    public int run(SheetController controller) {
        return this.run(controller, CloseCallback.close);
    }

    public int run(SheetController controller, CloseCallback close) {
        return this.run(controller, new CountDownLatch(1), close);
    }

    public int run(SheetController controller, CountDownLatch signal) {
        return this.run(controller, signal, CloseCallback.close);
    }

    public int run(SheetController controller, CountDownLatch signal, CloseCallback close) {
        return this.run(controller, signal, close, SignalCallback.countdown);
    }

    public int run(SheetController controller, CloseCallback close, SignalCallback count) {
        return this.run(controller, new CountDownLatch(1), close, count);
    }

    public int run(final SheetController controller, final CountDownLatch signal, final CloseCallback close, final SignalCallback count) {
        final AtomicInteger option = new AtomicInteger(-1);
        controller.setCallback(new SheetCallback(){

            public void callback(int returncode) {
                controller.callback(returncode);
                option.set(returncode);
                close.callback(controller, returncode);
                count.callback(signal);
            }
        });
        this.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Load bundle for alert %s", controller));
                }
                controller.loadBundle();
                NSWindow window = controller.window();
                ModalPanelAlertRunner.this.activate(window);
            }
        }, true);
        this.await(signal, controller.window());
        if (signal.getCount() == 0L) {
            this.invoke((MainAction)new DefaultMainAction(){

                public void run() {
                    controller.window().orderOut(null);
                }
            }, true);
        }
        return option.get();
    }

    public void run(NSWindow window) {
        this.run(window, new CountDownLatch(0));
    }

    public void run(final NSWindow window, CountDownLatch signal) {
        this.invoke((MainAction)new DefaultMainAction(){

            public void run() {
                ModalPanelAlertRunner.this.activate(window);
            }
        }, true);
        this.await(signal, window);
    }

    private void await(CountDownLatch signal, NSWindow window) {
        awaits.put(signal, window);
        if (!NSThread.isMainThread()) {
            try {
                Uninterruptibles.awaitUninterruptibly((CountDownLatch)signal);
            }
            finally {
                awaits.remove(signal);
            }
        }
    }

    public static void abort() {
        for (CountDownLatch lock : awaits.keySet()) {
            lock.countDown();
        }
        NSApplication.sharedApplication().abortModal();
    }

    public static enum CloseCallback {
        close{

            @Override
            void callback(SheetController controller, int returncode) {
                controller.window().orderOut(null);
            }
        }
        ,
        noop{

            @Override
            void callback(SheetController controller, int returncode) {
            }
        };


        abstract void callback(SheetController var1, int var2);
    }

    public static enum SignalCallback {
        countdown{

            @Override
            void callback(CountDownLatch signal) {
                signal.countDown();
            }
        }
        ,
        noop{

            @Override
            void callback(CountDownLatch signal) {
            }
        };


        abstract void callback(CountDownLatch var1);
    }
}

