/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.FileContentCryptor;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.common.CipherSupplier;
import org.cryptomator.cryptolib.common.DestroyableSecretKey;
import org.cryptomator.cryptolib.common.MacSupplier;
import org.cryptomator.cryptolib.v1.FileHeaderImpl;

class FileContentCryptorImpl
implements FileContentCryptor {
    private final Masterkey masterkey;
    private final SecureRandom random;

    FileContentCryptorImpl(Masterkey masterkey, SecureRandom random) {
        this.masterkey = masterkey;
        this.random = random;
    }

    @Override
    public boolean canSkipAuthentication() {
        return true;
    }

    @Override
    public int cleartextChunkSize() {
        return 32768;
    }

    @Override
    public int ciphertextChunkSize() {
        return 32816;
    }

    @Override
    public ByteBuffer encryptChunk(ByteBuffer cleartextChunk, long chunkNumber, FileHeader header) {
        byte[] nonce = new byte[16];
        this.random.nextBytes(nonce);
        return this.encryptChunk(cleartextChunk, chunkNumber, header, nonce);
    }

    @Override
    public ByteBuffer encryptChunk(ByteBuffer cleartextChunk, long chunkNumber, FileHeader header, byte[] chunkNonce) {
        ByteBuffer ciphertextChunk = ByteBuffer.allocate(32816);
        this.encryptChunk(cleartextChunk, ciphertextChunk, chunkNumber, header, chunkNonce);
        ciphertextChunk.flip();
        return ciphertextChunk;
    }

    @Override
    public void encryptChunk(ByteBuffer cleartextChunk, ByteBuffer ciphertextChunk, long chunkNumber, FileHeader header) {
        byte[] nonce = new byte[16];
        this.random.nextBytes(nonce);
        this.encryptChunk(cleartextChunk, ciphertextChunk, chunkNumber, header, nonce);
    }

    @Override
    public void encryptChunk(ByteBuffer cleartextChunk, ByteBuffer ciphertextChunk, long chunkNumber, FileHeader header, byte[] chunkNonce) {
        if (cleartextChunk.remaining() <= 0 || cleartextChunk.remaining() > 32768) {
            throw new IllegalArgumentException("Invalid cleartext chunk size: " + cleartextChunk.remaining() + ", expected range [1, " + 32768 + "]");
        }
        if (ciphertextChunk.remaining() < 32816) {
            throw new IllegalArgumentException("Invalid cipehrtext chunk size: " + ciphertextChunk.remaining() + ", must fit up to " + 32816 + " bytes.");
        }
        FileHeaderImpl headerImpl = FileHeaderImpl.cast(header);
        this.encryptChunk(cleartextChunk, ciphertextChunk, chunkNumber, headerImpl.getNonce(), headerImpl.getPayload().getContentKey(), chunkNonce);
    }

    @Override
    public ByteBuffer decryptChunk(ByteBuffer ciphertextChunk, long chunkNumber, FileHeader header, boolean authenticate) throws AuthenticationFailedException {
        ByteBuffer cleartextChunk = ByteBuffer.allocate(32768);
        this.decryptChunk(ciphertextChunk, cleartextChunk, chunkNumber, header, authenticate);
        cleartextChunk.flip();
        return cleartextChunk;
    }

    @Override
    public void decryptChunk(ByteBuffer ciphertextChunk, ByteBuffer cleartextChunk, long chunkNumber, FileHeader header, boolean authenticate) throws AuthenticationFailedException {
        if (ciphertextChunk.remaining() < 48 || ciphertextChunk.remaining() > 32816) {
            throw new IllegalArgumentException("Invalid ciphertext chunk size: " + ciphertextChunk.remaining() + ", expected range [" + 48 + ", " + 32816 + "]");
        }
        if (cleartextChunk.remaining() < 32768) {
            throw new IllegalArgumentException("Invalid cleartext chunk size: " + cleartextChunk.remaining() + ", must fit up to " + 32768 + " bytes.");
        }
        FileHeaderImpl headerImpl = FileHeaderImpl.cast(header);
        if (authenticate && !this.checkChunkMac(headerImpl.getNonce(), chunkNumber, ciphertextChunk)) {
            throw new AuthenticationFailedException("Authentication of chunk " + chunkNumber + " failed.");
        }
        this.decryptChunk(ciphertextChunk, cleartextChunk, headerImpl.getPayload().getContentKey());
    }

    void encryptChunk(ByteBuffer cleartextChunk, ByteBuffer ciphertextChunk, long chunkNumber, byte[] headerNonce, DestroyableSecretKey fileKey, byte[] nonce) {
        try (DestroyableSecretKey fk = fileKey.copy();){
            Cipher cipher = CipherSupplier.AES_CTR.forEncryption(fk, new IvParameterSpec(nonce));
            ciphertextChunk.put(nonce);
            assert (ciphertextChunk.remaining() >= cipher.getOutputSize(cleartextChunk.remaining()) + 32);
            int bytesEncrypted = cipher.doFinal(cleartextChunk, ciphertextChunk);
            ByteBuffer ciphertextBuf = ciphertextChunk.asReadOnlyBuffer();
            ciphertextBuf.position(16).limit(16 + bytesEncrypted);
            byte[] authenticationCode = this.calcChunkMac(headerNonce, chunkNumber, nonce, ciphertextBuf);
            assert (authenticationCode.length == 32);
            ciphertextChunk.put(authenticationCode);
        }
        catch (ShortBufferException e) {
            throw new IllegalStateException("Buffer allocated for reported output size apparently not big enough.", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException("Unexpected exception for CTR ciphers.", e);
        }
    }

    void decryptChunk(ByteBuffer ciphertextChunk, ByteBuffer cleartextChunk, DestroyableSecretKey fileKey) {
        assert (ciphertextChunk.remaining() >= 48);
        try (DestroyableSecretKey fk = fileKey.copy();){
            byte[] nonce = new byte[16];
            ByteBuffer chunkNonceBuf = ciphertextChunk.asReadOnlyBuffer();
            chunkNonceBuf.position(0).limit(16);
            chunkNonceBuf.get(nonce);
            ByteBuffer payloadBuf = ciphertextChunk.asReadOnlyBuffer();
            payloadBuf.position(16).limit(ciphertextChunk.limit() - 32);
            Cipher cipher = CipherSupplier.AES_CTR.forDecryption(fk, new IvParameterSpec(nonce));
            assert (cleartextChunk.remaining() >= cipher.getOutputSize(payloadBuf.remaining()));
            cipher.doFinal(payloadBuf, cleartextChunk);
        }
        catch (ShortBufferException e) {
            throw new IllegalStateException("Buffer allocated for reported output size apparently not big enough.", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException("Unexpected exception for CTR ciphers.", e);
        }
    }

    boolean checkChunkMac(byte[] headerNonce, long chunkNumber, ByteBuffer chunkBuf) {
        assert (chunkBuf.remaining() >= 48);
        ByteBuffer chunkNonceBuf = chunkBuf.asReadOnlyBuffer();
        chunkNonceBuf.position(0).limit(16);
        ByteBuffer payloadBuf = chunkBuf.asReadOnlyBuffer();
        payloadBuf.position(16).limit(chunkBuf.limit() - 32);
        ByteBuffer expectedMacBuf = chunkBuf.asReadOnlyBuffer();
        expectedMacBuf.position(chunkBuf.limit() - 32);
        byte[] chunkNonce = new byte[16];
        chunkNonceBuf.get(chunkNonce);
        byte[] expectedMac = new byte[32];
        expectedMacBuf.get(expectedMac);
        byte[] calculatedMac = this.calcChunkMac(headerNonce, chunkNumber, chunkNonce, payloadBuf);
        return MessageDigest.isEqual(expectedMac, calculatedMac);
    }

    private byte[] calcChunkMac(byte[] headerNonce, long chunkNumber, byte[] chunkNonce, ByteBuffer ciphertext) {
        try (DestroyableSecretKey mk = this.masterkey.getMacKey();){
            byte[] chunkNumberBigEndian = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(chunkNumber).array();
            Mac mac = MacSupplier.HMAC_SHA256.withKey(mk);
            mac.update(headerNonce);
            mac.update(chunkNumberBigEndian);
            mac.update(chunkNonce);
            mac.update(ciphertext);
            byte[] byArray = mac.doFinal();
            return byArray;
        }
    }
}

