/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import java.security.SecureRandom;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.v1.FileContentCryptorImpl;
import org.cryptomator.cryptolib.v1.FileHeaderCryptorImpl;
import org.cryptomator.cryptolib.v1.FileNameCryptorImpl;

class CryptorImpl
implements Cryptor {
    private final Masterkey masterkey;
    private final FileContentCryptorImpl fileContentCryptor;
    private final FileHeaderCryptorImpl fileHeaderCryptor;
    private final FileNameCryptorImpl fileNameCryptor;

    CryptorImpl(Masterkey masterkey, SecureRandom random) {
        this.masterkey = masterkey;
        this.fileHeaderCryptor = new FileHeaderCryptorImpl(masterkey, random);
        this.fileContentCryptor = new FileContentCryptorImpl(masterkey, random);
        this.fileNameCryptor = new FileNameCryptorImpl(masterkey);
    }

    @Override
    public FileContentCryptorImpl fileContentCryptor() {
        this.assertNotDestroyed();
        return this.fileContentCryptor;
    }

    @Override
    public FileHeaderCryptorImpl fileHeaderCryptor() {
        this.assertNotDestroyed();
        return this.fileHeaderCryptor;
    }

    @Override
    public FileNameCryptorImpl fileNameCryptor() {
        this.assertNotDestroyed();
        return this.fileNameCryptor;
    }

    @Override
    public boolean isDestroyed() {
        return this.masterkey.isDestroyed();
    }

    @Override
    public void close() {
        this.destroy();
    }

    @Override
    public void destroy() {
        this.masterkey.destroy();
    }

    private void assertNotDestroyed() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("Cryptor destroyed.");
        }
    }
}

