/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import com.google.common.base.Preconditions;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import java.util.Objects;
import javax.security.auth.Destroyable;
import org.cryptomator.cryptolib.common.Destroyables;

public class ECKeyPair
implements Destroyable {
    private final KeyPair keyPair;
    private boolean destroyed;

    ECKeyPair(KeyPair keyPair) {
        Preconditions.checkArgument((boolean)(keyPair.getPrivate() instanceof ECPrivateKey));
        Preconditions.checkArgument((boolean)(keyPair.getPublic() instanceof ECPublicKey));
        this.keyPair = keyPair;
    }

    public KeyPair keyPair() {
        return this.keyPair;
    }

    public ECPrivateKey getPrivate() {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0);
        assert (this.keyPair.getPrivate() instanceof ECPrivateKey);
        return (ECPrivateKey)this.keyPair.getPrivate();
    }

    public ECPublicKey getPublic() {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0);
        assert (this.keyPair.getPublic() instanceof ECPublicKey);
        return (ECPublicKey)this.keyPair.getPublic();
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void destroy() {
        Destroyables.destroySilently(this.keyPair.getPrivate());
        this.destroyed = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECKeyPair that = (ECKeyPair)o;
        return MessageDigest.isEqual(this.getPublic().getEncoded(), that.getPublic().getEncoded());
    }

    public int hashCode() {
        int result = Objects.hash(this.keyPair.getPublic().getAlgorithm());
        result = 31 * result + Arrays.hashCode(this.keyPair.getPublic().getEncoded());
        return result;
    }
}

