/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs.nfs;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.fs.nfs.NfsErrorMapper;
import ch.iterate.mountainduck.fs.nfs.NfsVirtualFileSystem;
import java.io.IOException;
import javax.security.auth.Subject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dcache.nfs.v4.NfsIdMapping;
import org.dcache.nfs.v4.xdr.nfsace4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.vfs.AclCheckable;
import org.dcache.nfs.vfs.DirectoryStream;
import org.dcache.nfs.vfs.FsStat;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;

public class SynchronizedNfsFilesystemDelegate
implements NfsVirtualFileSystem {
    private static final Logger log = LogManager.getLogger((String)SynchronizedNfsFilesystemDelegate.class.getName());
    private final NfsVirtualFileSystem delegate;
    private final FileidMapper<Inode> fileid;

    public SynchronizedNfsFilesystemDelegate(NfsVirtualFileSystem delegate, FileidMapper<Inode> fileid) {
        this.delegate = delegate;
        this.fileid = fileid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Path reverse(Inode inode) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.reverse(inode);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    @Override
    public void invalidate(Inode inode) throws NotfoundException {
        this.delegate.invalidate(inode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(Inode inode, int i, stateid4 stateid) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                this.delegate.open(inode, i, stateid);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Inode inode, stateid4 stateid) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                this.delegate.close(inode, stateid);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int access(Subject subject, Inode inode, int i) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.access(subject, inode, i);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Inode create(Inode inode, Stat.Type type, String s, Subject subject, int i) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.create(inode, type, s, subject, i);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    public FsStat getFsStat() throws IOException {
        return this.delegate.getFsStat();
    }

    public Inode getRootInode() throws IOException {
        return this.delegate.getRootInode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Inode lookup(Inode inode, String s) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.lookup(inode, s);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Inode link(Inode inode, Inode inode1, String s, Subject subject) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.link(inode, inode1, s, subject);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectoryStream list(Inode inode, byte[] bytes, long l) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.list(inode, bytes, l);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] directoryVerifier(Inode inode) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.directoryVerifier(inode);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Inode mkdir(Inode inode, String s, Subject subject, int i) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.mkdir(inode, s, subject, i);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean move(Inode inode, String s, Inode inode1, String s1) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.move(inode, s, inode1, s1);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Inode parentOf(Inode inode) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.parentOf(inode);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(Inode inode, byte[] bytes, long l, int i) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.read(inode, bytes, l, i);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readlink(Inode inode) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.readlink(inode);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Inode inode, String s) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                this.delegate.remove(inode, s);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Inode symlink(Inode inode, String s, String s1, Subject subject, int i) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.symlink(inode, s, s1, subject, i);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualFileSystem.WriteResult write(Inode inode, byte[] bytes, long l, int i, VirtualFileSystem.StabilityLevel stabilityLevel) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.write(inode, bytes, l, i, stabilityLevel);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Inode inode, long l, int i) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                this.delegate.commit(inode, l, i);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat getattr(Inode inode) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.getattr(inode);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setattr(Inode inode, Stat stat) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                this.delegate.setattr(inode, stat);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public nfsace4[] getAcl(Inode inode) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.getAcl(inode);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAcl(Inode inode, nfsace4[] nfsace4s) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                this.delegate.setAcl(inode, nfsace4s);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasIOLayout(Inode inode) throws IOException {
        try {
            Path path = this.fileid.reverse((Object)inode);
            synchronized (path) {
                return this.delegate.hasIOLayout(inode);
            }
        }
        catch (NotfoundException e) {
            throw new NfsErrorMapper().map((BackgroundException)e);
        }
    }

    public AclCheckable getAclCheckable() {
        return this.delegate.getAclCheckable();
    }

    public NfsIdMapping getIdMapper() {
        return this.delegate.getIdMapper();
    }

    public boolean getCaseInsensitive() {
        return this.delegate.getCaseInsensitive();
    }

    public boolean getCasePreserving() {
        return this.delegate.getCasePreserving();
    }
}

