/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs.nfs;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.NotfoundException;
import ch.iterate.mountainduck.fs.nfs.NfsVirtualFileSystem;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.dcache.nfs.util.Opaque;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.vfs.DirectoryEntry;
import org.dcache.nfs.vfs.DirectoryStream;
import org.dcache.nfs.vfs.ForwardingFileSystem;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;

public class NfsMetadataCache
extends ForwardingFileSystem
implements NfsVirtualFileSystem {
    private final NfsVirtualFileSystem delegate;
    private final Cache<Opaque, Stat> statCache;

    public NfsMetadataCache(NfsVirtualFileSystem delegate, int maxSize, int expiryms) {
        this.delegate = delegate;
        this.statCache = CacheBuilder.newBuilder().maximumSize((long)maxSize).expireAfterWrite((long)expiryms, TimeUnit.MILLISECONDS).softValues().build();
    }

    private void invalidateStatCache(Inode inode) {
        this.statCache.invalidate((Object)new Opaque(inode.getFileId()));
    }

    private Stat statFromCacheOrLoad(Inode inode) throws IOException {
        try {
            return (Stat)this.statCache.get((Object)new Opaque(inode.getFileId()), () -> this.delegate.getattr(inode));
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            Throwables.throwIfInstanceOf((Throwable)t, IOException.class);
            throw new IOException(e.getMessage(), t);
        }
    }

    public Stat getattr(Inode inode) throws IOException {
        return this.statFromCacheOrLoad(inode);
    }

    public void commit(Inode inode, long offset, int count) throws IOException {
        this.invalidateStatCache(inode);
        this.delegate.commit(inode, offset, count);
    }

    public Inode symlink(Inode parent, String path, String link, Subject subject, int mode) throws IOException {
        Inode inode = this.delegate.symlink(parent, path, link, subject, mode);
        this.invalidateStatCache(parent);
        return inode;
    }

    public void remove(Inode parent, String path) throws IOException {
        Inode inode = this.lookup(parent, path);
        this.delegate.remove(parent, path);
        this.invalidateStatCache(parent);
        this.invalidateStatCache(inode);
    }

    public boolean move(Inode src, String oldName, Inode dest, String newName) throws IOException {
        boolean changed = this.delegate.move(src, oldName, dest, newName);
        if (changed) {
            this.invalidateStatCache(src);
            this.invalidateStatCache(dest);
        }
        return changed;
    }

    @Override
    public void open(Inode inode, int mode, stateid4 stateid) throws IOException {
        this.delegate.open(inode, mode, stateid);
    }

    @Override
    public void close(Inode inode, stateid4 stateid) throws IOException {
        this.delegate.close(inode, stateid);
    }

    @Override
    public Path reverse(Inode inode) throws IOException {
        return this.delegate.reverse(inode);
    }

    @Override
    public void invalidate(Inode inode) throws NotfoundException {
        this.delegate.invalidate(inode);
        this.invalidateStatCache(inode);
    }

    public Inode create(Inode parent, Stat.Type type, String path, Subject subject, int mode) throws IOException {
        Inode inode = this.delegate.create(parent, type, path, subject, mode);
        this.invalidateStatCache(parent);
        return inode;
    }

    public void setattr(Inode inode, Stat stat) throws IOException {
        this.delegate.setattr(inode, stat);
        this.invalidateStatCache(inode);
    }

    public Inode mkdir(Inode parent, String path, Subject subject, int mode) throws IOException {
        Inode inode = this.delegate.mkdir(parent, path, subject, mode);
        this.invalidateStatCache(parent);
        return inode;
    }

    public Inode link(Inode parent, Inode link, String path, Subject subject) throws IOException {
        Inode inode = this.delegate.link(parent, link, path, subject);
        this.invalidateStatCache(parent);
        this.invalidateStatCache(inode);
        return inode;
    }

    public VirtualFileSystem.WriteResult write(Inode inode, byte[] data, long offset, int count, VirtualFileSystem.StabilityLevel stabilityLevel) throws IOException {
        VirtualFileSystem.WriteResult write = this.delegate.write(inode, data, offset, count, stabilityLevel);
        this.invalidateStatCache(inode);
        return write;
    }

    public VirtualFileSystem.WriteResult write(Inode inode, ByteBuffer data, long offset, VirtualFileSystem.StabilityLevel stabilityLevel) throws IOException {
        VirtualFileSystem.WriteResult write = this.delegate.write(inode, data, offset, stabilityLevel);
        this.invalidateStatCache(inode);
        return write;
    }

    protected VirtualFileSystem delegate() {
        return this.delegate;
    }

    public DirectoryStream list(Inode inode, byte[] verifier, long cookie) throws IOException {
        DirectoryStream entries = this.delegate.list(inode, verifier, cookie);
        for (DirectoryEntry entry : entries) {
            this.invalidateStatCache(entry.getInode());
        }
        this.invalidateStatCache(inode);
        return entries;
    }

    public void removeXattr(Inode inode, String attr) throws IOException {
        this.delegate.removeXattr(inode, attr);
        this.invalidateStatCache(inode);
    }

    public void setXattr(Inode inode, String attr, byte[] value, VirtualFileSystem.SetXattrMode mode) throws IOException {
        this.delegate.setXattr(inode, attr, value, mode);
        this.invalidateStatCache(inode);
    }
}

