/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs.nfs;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemDirectoryGenerations;
import ch.iterate.mountainduck.fs.FilesystemMountRegistry;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.fs.MountService;
import ch.iterate.mountainduck.fs.MountServiceFactory;
import ch.iterate.mountainduck.fs.VolumeIconServiceFilesystemOperations;
import ch.iterate.mountainduck.fs.nfs.ICNSVolumeIconService;
import ch.iterate.mountainduck.fs.nfs.NfsClientCache;
import ch.iterate.mountainduck.fs.nfs.NfsFileSystemDelegate;
import ch.iterate.mountainduck.fs.nfs.NfsMetadataCache;
import ch.iterate.mountainduck.fs.nfs.NfsOperationFactory;
import ch.iterate.mountainduck.fs.nfs.NfsVirtualFileSystem;
import ch.iterate.mountainduck.fs.nfs.StringErrorExceptionMappingService;
import ch.iterate.mountainduck.fs.nfs.SynchronizedNfsFilesystemDelegate;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.service.VolumeIconService;
import com.sun.jna.LastErrorException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dcache.nfs.ExportFile;
import org.dcache.nfs.ExportTable;
import org.dcache.nfs.v4.ClientCache;
import org.dcache.nfs.v4.ClientRecoveryStore;
import org.dcache.nfs.v4.EphemeralClientRecoveryStore;
import org.dcache.nfs.v4.NFSServerV41;
import org.dcache.nfs.v4.NFSv4StateHandler;
import org.dcache.nfs.v4.OperationExecutor;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.dcache.oncrpc4j.rpc.OncRpcProgram;
import org.dcache.oncrpc4j.rpc.OncRpcSvc;
import org.dcache.oncrpc4j.rpc.OncRpcSvcBuilder;
import org.dcache.oncrpc4j.rpc.RpcDispatchable;
import org.glassfish.grizzly.threadpool.FixedThreadPool;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public class NfsFilesystem
implements Filesystem {
    private static final Logger log = LogManager.getLogger((String)NfsFilesystem.class.getName());
    private final Host bookmark;
    private final FileidMapper<Inode> fileid;
    private final FilesystemDirectoryGenerations generations;
    private final FilesystemOperations<Inode> operations;
    private final ReloadService reload;
    private final MountService mount;
    private OncRpcSvc rpc;
    private Local volume;
    protected NfsVirtualFileSystem delegate;
    private final Preferences preferences = PreferencesFactory.get();
    private final ThreadPoolConfig configuration = ThreadPoolConfig.defaultConfig();
    protected final FixedThreadPool executor;

    public NfsFilesystem(Host bookmark, FilesystemOperations<Inode> operations, FileidMapper<Inode> fileid, FilesystemDirectoryGenerations generations, ReloadService reload) {
        int threadPoolSize = this.preferences.getInteger("fs.pool.threads");
        this.configuration.setCorePoolSize(threadPoolSize).setMaxPoolSize(threadPoolSize);
        this.configuration.setPoolName("NFS Worker Thread");
        this.configuration.setQueue(new LinkedTransferQueue());
        this.configuration.setDaemon(false);
        this.executor = new FixedThreadPool(this.configuration);
        this.bookmark = bookmark;
        this.fileid = fileid;
        this.generations = generations;
        this.reload = reload;
        this.operations = new VolumeIconServiceFilesystemOperations(operations, fileid, (VolumeIconService)new ICNSVolumeIconService());
        this.mount = MountServiceFactory.get(fileid);
    }

    public Local getMountpoint() {
        return this.volume;
    }

    public FilesystemOperations<?> getOperations() {
        return this.operations;
    }

    public ReloadService getReloadService() {
        return this.reload;
    }

    public void mount(Path workdir, Local volume) throws BackgroundException {
        this.mount(workdir, volume, Filesystem.Options.readwrite);
    }

    public void mount(Path workdir, Filesystem.Options options) throws BackgroundException {
        this.mount(workdir, FilesystemMountRegistry.get().register((Filesystem)this), options);
    }

    public void mount(Path workdir, Local volume, Filesystem.Options options) throws BackgroundException {
        ExportFile exports;
        this.volume = volume;
        if (log.isInfoEnabled()) {
            log.info(String.format("Mount %s with options %s and operations %s to %s", workdir, options, this.operations, volume));
        }
        this.operations.open(workdir, volume);
        this.rpc = new OncRpcSvcBuilder().withTCP().withBindAddress(InetAddress.getLoopbackAddress().getHostAddress()).withIpProtocolType(6).withWorkerThreadIoStrategy().withoutAutoPublish().withWorkerThreadExecutionService((ExecutorService)this.executor).build();
        try {
            exports = new ExportFile((Reader)new StringReader("/ *(rw,no_root_squash)"));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        this.delegate = new SynchronizedNfsFilesystemDelegate(new NfsFileSystemDelegate(this.bookmark, volume, this.operations, this.generations, workdir, this.fileid), this.fileid);
        if (this.preferences.getBoolean("fs.metadata.cache.enable")) {
            this.delegate = new NfsMetadataCache(this.delegate, this.preferences.getInteger("fs.metadata.cache.size"), this.preferences.getInteger("fs.metadata.cache.expiry.ms"));
        }
        NFSServerV41 nfs4 = new NFSServerV41.Builder().withOperationExecutor((OperationExecutor)new NfsOperationFactory(this.delegate)).withVfs((VirtualFileSystem)this.delegate).withStateHandler(new NFSv4StateHandler(0x1FFFFFFF, 0, (ClientRecoveryStore)new EphemeralClientRecoveryStore(), (ClientCache)new NfsClientCache())).withExportTable((ExportTable)exports).build();
        this.rpc.register(new OncRpcProgram(100003, 4), (RpcDispatchable)nfs4);
        try {
            this.rpc.start();
            if (log.isInfoEnabled()) {
                log.info(String.format("Listening for TCP on port %d", this.rpc.getInetSocketAddress(6).getPort()));
            }
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        InetSocketAddress address = this.rpc.getInetSocketAddress(6);
        this.mount.mount(this.bookmark, address, workdir, volume, options);
    }

    public void unmount() throws BackgroundException {
        if (null == this.volume) {
            throw new LocalAccessDeniedException();
        }
        try {
            this.mount.unmount(this.volume);
            if (this.rpc != null) {
                this.rpc.stop();
            }
            this.fileid.clear();
            try {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Remove directory for mountpoint %s", this.volume));
                }
                this.volume.delete();
            }
            catch (AccessDeniedException | NotfoundException e) {
                log.warn(String.format("Failure removing volume directory %s", this.volume));
            }
        }
        catch (LastErrorException e) {
            throw new StringErrorExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        finally {
            this.operations.close();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NfsFilesystem{");
        sb.append("bookmark=").append(this.bookmark);
        sb.append(", volume=").append(this.volume);
        sb.append(", operations=").append(this.operations);
        sb.append('}');
        return sb.toString();
    }
}

