/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs.nfs;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathRelativizer;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.unicode.NFCNormalizer;
import ch.cyberduck.core.unicode.NFDNormalizer;
import ch.cyberduck.core.unicode.UnicodeNormalizer;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemDirectoryGenerations;
import ch.iterate.mountainduck.fs.FilesystemIncrementalListProgressListener;
import ch.iterate.mountainduck.fs.FilesystemListProgressListener;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.fs.nfs.InodeMapper;
import ch.iterate.mountainduck.fs.nfs.NfsErrorMapper;
import ch.iterate.mountainduck.fs.nfs.NfsVirtualFileSystem;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.Subjects;
import org.dcache.auth.UidPrincipal;
import org.dcache.nfs.v4.NfsIdMapping;
import org.dcache.nfs.v4.SimpleIdMap;
import org.dcache.nfs.v4.acl.Acls;
import org.dcache.nfs.v4.xdr.nfsace4;
import org.dcache.nfs.v4.xdr.stateid4;
import org.dcache.nfs.vfs.AclCheckable;
import org.dcache.nfs.vfs.DirectoryEntry;
import org.dcache.nfs.vfs.DirectoryStream;
import org.dcache.nfs.vfs.FsStat;
import org.dcache.nfs.vfs.Inode;
import org.dcache.nfs.vfs.Stat;
import org.dcache.nfs.vfs.VirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NfsFileSystemDelegate
implements NfsVirtualFileSystem {
    private static final org.apache.logging.log4j.Logger log = LogManager.getLogger((String)NfsFileSystemDelegate.class.getName());
    private static final long STATIC_TIMESTAMP = System.currentTimeMillis();
    private final Preferences preferences = PreferencesFactory.get();
    private final Host bookmark;
    private final Local mountpoint;
    private final FilesystemDirectoryGenerations generations;
    private final Path workdir;
    private final FilesystemOperations<Inode> fs;
    private final FileidMapper<Inode> fileid;
    private final UnicodeNormalizer nfc = new NFCNormalizer();
    private final UnicodeNormalizer nfd = new NFDNormalizer();
    private static final int ROOT_UID = 0;
    private final int uid;
    private final int gid;
    private final Map<stateid4, Integer> openStates = new ConcurrentHashMap<stateid4, Integer>();

    public NfsFileSystemDelegate(Host bookmark, Local mountpoint, FilesystemOperations<Inode> fs, FilesystemDirectoryGenerations generations, Path workdir, FileidMapper<Inode> fileid) {
        this.bookmark = bookmark;
        this.mountpoint = mountpoint;
        this.generations = generations;
        this.workdir = workdir;
        this.fs = fs;
        this.fileid = fileid;
        Subject currentUser = UnixUtils.getCurrentUser();
        this.uid = (int)Subjects.getUid((Subject)currentUser);
        this.gid = (int)Subjects.getPrimaryGid((Subject)currentUser);
    }

    @Override
    public Path reverse(Inode inode) throws IOException {
        try {
            return this.fs.reverse((Object)inode);
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    @Override
    public void invalidate(Inode inode) throws NotfoundException {
        this.fs.invalidate(this.fileid.reverse((Object)inode));
    }

    public int access(Subject user, Inode inode, int mode) throws IOException {
        if (user.getPrincipals().stream().anyMatch(principal -> principal.getName().equals(String.valueOf(0)))) {
            log.warn(String.format("Allow access for root subject %s", user));
            return mode;
        }
        if (user.getPrincipals().stream().noneMatch(principal -> principal.getName().equals(String.valueOf(this.uid)))) {
            log.warn(String.format("Deny access for subject %s", user));
            throw new NfsErrorMapper().map((BackgroundException)new LocalAccessDeniedException());
        }
        return mode;
    }

    @Override
    public void open(Inode inode, int mode, stateid4 stateid) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace(String.format("open %s in mode %s and state %s", inode, mode, stateid));
        }
        try {
            Path file = this.reverse(inode);
            if (file.isFile()) {
                FilesystemCallbacks.Mode flags;
                FilesystemCallbacks.Mode mode2 = flags = (mode & 4) != 0 ? FilesystemCallbacks.Mode.write : FilesystemCallbacks.Mode.read;
                if (this.openStates.putIfAbsent(stateid, mode) != null) {
                    Integer m = this.openStates.get(stateid);
                    if (mode > m) {
                        this.openStates.put(stateid, mode);
                        if (log.isInfoEnabled()) {
                            log.info(String.format("open %s in mode %s (extend access mode)", file.getName(), mode));
                        }
                    }
                    if (flags == FilesystemCallbacks.Mode.write) {
                        this.fs.open(file, flags, Long.valueOf(this.fs.getattr(file).getSize()), Application.notfound);
                    }
                } else {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("open %s in mode %s (new)", file.getName(), mode));
                    }
                    this.fs.open(file, flags, Long.valueOf(this.fs.getattr(file).getSize()), Application.notfound);
                }
            }
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    public FsStat getFsStat() {
        try {
            Quota.Space quota = this.fs.quota(this.workdir);
            try {
                return new FsStat(Math.addExact(quota.used, quota.available), 0L, quota.used.longValue(), (long)this.fileid.size());
            }
            catch (ArithmeticException e) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Ignore failure %s", e.getMessage()));
                }
                return new FsStat(Long.MAX_VALUE, 0L, quota.used.longValue(), (long)this.fileid.size());
            }
        }
        catch (BackgroundException e) {
            log.warn(String.format("Ignore failure %s", e.getMessage()));
            return new FsStat(Long.MAX_VALUE, 0L, 0L, (long)this.fileid.size());
        }
    }

    public Inode getRootInode() {
        return (Inode)this.fileid.getOrCreate(this.workdir);
    }

    public Inode lookup(Inode parent, String path) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("lookup %s", path));
        }
        try {
            Path file = this.lookup(this.reverse(parent), path);
            return (Inode)this.fileid.getOrCreate(file);
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    private Path lookup(Path parent, String path) throws BackgroundException {
        try {
            return this.fs.find(parent, this.nfc.normalize((CharSequence)path).toString());
        }
        catch (NotfoundException e) {
            return this.fs.find(parent, path, FilesystemCallbacks.Flags.offline);
        }
    }

    public byte[] directoryVerifier(Inode inode) {
        return inode.getFileId();
    }

    public DirectoryStream list(Inode parent, byte[] verifier, long fromCookie) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("list %s with cookie %d", parent, fromCookie));
        }
        try {
            Path next;
            long outCookie = fromCookie;
            Path directory = this.reverse(parent);
            if (log.isInfoEnabled()) {
                log.info(String.format("list %s with cookie %d", directory, fromCookie));
            }
            FilesystemIncrementalListProgressListener listener = new FilesystemIncrementalListProgressListener(this.bookmark);
            this.fs.list(directory, (FilesystemListProgressListener)listener, fromCookie);
            ArrayList<DirectoryEntry> entries = new ArrayList<DirectoryEntry>();
            int i = 0;
            while ((next = listener.next()) != null) {
                if ((long)i < fromCookie) {
                    ++i;
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Add file %s", next));
                }
                Inode inode = (Inode)this.fileid.updateOrCreate(next);
                entries.add(new DirectoryEntry(this.nfd.normalize((CharSequence)next.getName()).toString(), inode, this.stat(inode, next, next.attributes()), ++outCookie));
                ++i;
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("Return %d entries for directory %s", entries.size(), directory));
            }
            return new DirectoryStream(verifier, entries);
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    public Inode create(Inode parent, Stat.Type type, String path, Subject subject, int mode) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("create %s", path));
        }
        try {
            try {
                Path file = this.lookup(this.reverse(parent), path);
                return (Inode)this.fileid.get(file);
            }
            catch (NotfoundException e) {
                Path file = this.fs.getComposer().compose(this.reverse(parent), this.nfc.normalize((CharSequence)path).toString(), EnumSet.of(AbstractPath.Type.file));
                return (Inode)this.fs.touch(file);
            }
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    public Inode link(Inode parent, Inode link, String path, Subject subject) throws IOException {
        try {
            throw new UnsupportedException();
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    public Inode symlink(Inode parent, String linkName, String targetName, Subject subject, int mode) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("symlink %s", targetName));
        }
        try {
            if (!this.preferences.getBoolean("fs.symlink.enable")) {
                throw new UnsupportedException("Symlink support is disabled");
            }
            try {
                Path file = this.fs.getComposer().compose(this.reverse(parent), this.nfc.normalize((CharSequence)linkName).toString(), EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.symboliclink));
                Path target = StringUtils.startsWith((CharSequence)targetName, (CharSequence)String.valueOf('/')) ? this.fs.getComposer().compose(this.workdir, PathRelativizer.relativize((String)this.mountpoint.getAbsolute(), (String)this.nfc.normalize((CharSequence)targetName).toString()), EnumSet.of(AbstractPath.Type.file)) : this.fs.getComposer().compose(this.reverse(parent), PathRelativizer.relativize((String)this.mountpoint.getAbsolute(), (String)this.nfc.normalize((CharSequence)targetName).toString()), EnumSet.of(AbstractPath.Type.file));
                file.setSymlinkTarget(target);
                return (Inode)this.fs.symlink(file, target);
            }
            catch (UnsupportedException e) {
                throw new AccessDeniedException(e.getDetail(), (Throwable)e);
            }
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    public Inode mkdir(Inode parent, String path, Subject subject, int mode) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("mkdir %s", path));
        }
        try {
            Path directory = this.fs.getComposer().compose(this.reverse(parent), this.nfc.normalize((CharSequence)path).toString(), EnumSet.of(AbstractPath.Type.directory));
            return (Inode)this.fs.mkdir(directory);
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    public boolean move(Inode src, String oldName, Inode dest, String newName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("move %s to %s", oldName, newName));
        }
        try {
            Path file = this.lookup(this.reverse(src), oldName);
            Path target = this.fs.getComposer().compose(this.reverse(dest), this.nfc.normalize((CharSequence)newName).toString(), file.getType());
            this.fs.rename(file, target);
            return true;
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    public Inode parentOf(Inode inode) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("parentOf %s", inode));
        }
        return (Inode)this.fileid.getOrCreate(this.reverse(inode).getParent());
    }

    public int read(Inode inode, byte[] chunk, long offset, int count) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("read %s with offset %d and count %d", inode, offset, count));
        }
        try {
            Path file = this.reverse(inode);
            if (log.isDebugEnabled()) {
                log.debug(String.format("read %s with offset %d and count %d", file, offset, count));
            }
            return this.fs.read(file, chunk, offset, count);
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    public VirtualFileSystem.WriteResult write(Inode inode, byte[] chunk, long offset, int count, VirtualFileSystem.StabilityLevel stabilityLevel) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("write %s with offset %d and count %d", inode, offset, count));
        }
        try {
            Path file = this.reverse(inode);
            if (log.isDebugEnabled()) {
                log.debug(String.format("write %s with offset %d and count %d", file, offset, count));
            }
            long time = System.currentTimeMillis();
            Path parent = file.getParent();
            parent.attributes().setAccessedDate(time);
            parent.attributes().setModificationDate(time);
            return new VirtualFileSystem.WriteResult(VirtualFileSystem.StabilityLevel.FILE_SYNC, this.fs.write(file, chunk, count, offset));
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    public void remove(Inode parent, String path) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("remove %s", path));
        }
        try {
            Path file = this.lookup(this.reverse(parent), path);
            this.fs.delete(file);
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    public String readlink(Inode inode) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("readlink %s", inode));
        }
        try {
            Path file = this.reverse(inode);
            if (file.isSymbolicLink()) {
                String target = this.readlink(this.workdir, file);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Return target %s for symbolic link %s", target, file));
                }
                return target;
            }
            throw new NotfoundException(file.getAbsolute());
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    protected String readlink(Path workdir, Path file) throws NotfoundException {
        if (null == file.getSymlinkTarget()) {
            log.warn(String.format("Missing symlink taret for %s", file));
            throw new NotfoundException(file.getAbsolute());
        }
        if (!file.getSymlinkTarget().isChild(workdir)) {
            log.warn(String.format("Symlink taret for %s outside of working directory %s", file, workdir));
            return null;
        }
        StringBuilder normalized = new StringBuilder();
        if (file.getParent().isChild(workdir)) {
            normalized.append(StringUtils.repeat((String)"../", (int)StringUtils.split((String)PathRelativizer.relativize((String)workdir.getAbsolute(), (String)file.getParent().getAbsolute()), (char)'/').length));
        }
        normalized.append(PathRelativizer.relativize((String)workdir.getAbsolute(), (String)file.getSymlinkTarget().getAbsolute()));
        return StringUtils.removeEnd((String)normalized.toString(), (String)String.valueOf('/'));
    }

    @Override
    public void close(Inode inode, stateid4 stateid) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("close %s and state %s", inode, stateid));
        }
        try {
            Path file = this.reverse(inode);
            if (file.isFile() && this.openStates.containsKey(stateid)) {
                Integer mode = this.openStates.remove(stateid);
                if (log.isInfoEnabled()) {
                    log.info(String.format("close %s in mode %d", file, mode));
                }
                this.fs.close(file, (mode & 4) != 0 ? FilesystemCallbacks.Mode.write : FilesystemCallbacks.Mode.read, Application.notfound);
            }
        }
        catch (InodeMapper.InodeNotfoundException e) {
            log.warn(String.format("Ignore close for invalid file handle %s", inode));
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    public void commit(Inode inode, long offset, int count) throws IOException {
        try {
            throw new UnsupportedException();
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    public Stat getattr(Inode inode) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace(String.format("getattr %s", inode));
        }
        try {
            Path file = this.reverse(inode);
            PathAttributes attributes = this.fs.getattr(file);
            if (log.isTraceEnabled()) {
                log.trace(String.format("Return attributes %s for file %s", attributes, file));
            }
            return this.stat(inode, file, attributes);
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    private Stat stat(Inode inode, Path file, PathAttributes attributes) {
        Stat stat = new Stat();
        stat.setFileid(this.fileid.fromInode((Object)inode));
        stat.setIno((int)this.fileid.fromInode((Object)inode));
        stat.setNlink(1);
        if (file.isDirectory()) {
            Long timestamp = this.generations.get(file);
            if (log.isTraceEnabled()) {
                log.trace(String.format("Set generation timestamp %d for %s", timestamp, file));
            }
            stat.setGeneration(timestamp.longValue());
        } else {
            stat.setGeneration(attributes.getModificationDate());
        }
        if (-1L == attributes.getModificationDate()) {
            log.debug(String.format("Unknown modification date for %s", file));
            stat.setMTime(STATIC_TIMESTAMP);
        } else {
            stat.setMTime(attributes.getModificationDate());
        }
        if (-1L == attributes.getCreationDate()) {
            log.trace(String.format("Unknown creation date for %s", file));
            stat.setCTime(STATIC_TIMESTAMP);
        } else if (443779200000L == attributes.getCreationDate()) {
            stat.setCTime(STATIC_TIMESTAMP);
        } else {
            stat.setCTime(attributes.getCreationDate());
        }
        if (-1L == attributes.getAccessedDate()) {
            log.trace(String.format("Unknown access date for %s", file));
            stat.setATime(STATIC_TIMESTAMP);
        } else {
            stat.setATime(attributes.getAccessedDate());
        }
        stat.setSize(-1L == attributes.getSize() ? 0L : attributes.getSize());
        int mode = 0;
        if (file.isSymbolicLink() && this.preferences.getBoolean("fs.symlink.enable")) {
            if (!file.getSymlinkTarget().isChild(this.workdir)) {
                log.warn(String.format("Failure resolving symbolic link target %s", file.getSymlinkTarget()));
                mode |= file.isDirectory() ? 16384 : 32768;
            } else {
                mode |= 0xA000;
            }
        } else {
            mode |= file.isDirectory() ? 16384 : 32768;
        }
        Permission permission = attributes.getPermission();
        if (Permission.EMPTY.equals((Object)permission)) {
            mode = file.isDirectory() ? (mode |= Integer.valueOf(new Permission(Permission.Action.all, Permission.Action.read_execute, Permission.Action.read_execute).getMode(), 8).intValue()) : (mode |= Integer.valueOf(new Permission(Permission.Action.read_write, Permission.Action.read, Permission.Action.read).getMode(), 8).intValue());
        } else {
            mode |= Integer.valueOf(attributes.getPermission().getMode(), 8).intValue();
            if (file.isDirectory()) {
                mode |= Integer.valueOf(new Permission(Permission.Action.read_execute, Permission.Action.read_execute, Permission.Action.read_execute).getMode(), 8).intValue();
            }
        }
        stat.setMode(mode);
        stat.setUid(this.uid);
        stat.setGid(this.gid);
        stat.setDev(17);
        stat.setRdev(17);
        if (log.isTraceEnabled()) {
            log.trace(String.format("Return attributes '%s' for %s", stat, file));
        }
        return stat;
    }

    public void setattr(Inode inode, Stat stat) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("setattr %s with stat %s", inode, stat));
        }
        try {
            Path file = this.reverse(inode);
            if (stat.isDefined(Stat.StatAttribute.MODE)) {
                Permission permission = new Permission(Stat.modeToString((int)stat.getMode()));
                this.fs.setattr(file, permission);
            }
            if (stat.isDefined(Stat.StatAttribute.SIZE)) {
                long size = stat.getSize();
                this.fs.truncate(file, size);
            }
            if (stat.isDefined(Stat.StatAttribute.ATIME)) {
                file.attributes().setAccessedDate(stat.getATime());
            }
            if (stat.isDefined(Stat.StatAttribute.CTIME)) {
                file.attributes().setCreationDate(stat.getCTime());
            }
            if (stat.isDefined(Stat.StatAttribute.MTIME)) {
                this.fs.setattr(file, stat.getMTime());
            }
        }
        catch (BackgroundException e) {
            throw new NfsErrorMapper().map(e);
        }
    }

    public nfsace4[] getAcl(Inode inode) throws IOException {
        Path file = this.reverse(inode);
        if (Permission.EMPTY.equals((Object)file.attributes().getPermission())) {
            return Acls.of((int)Integer.valueOf(new Permission(Permission.Action.all, Permission.Action.all, Permission.Action.all).getMode(), 8), (boolean)file.isDirectory());
        }
        return Acls.of((int)Integer.valueOf(file.attributes().getPermission().getMode(), 8), (boolean)file.isDirectory());
    }

    public void setAcl(Inode inode, nfsace4[] acl) {
    }

    public boolean hasIOLayout(Inode inode) {
        return true;
    }

    public AclCheckable getAclCheckable() {
        return AclCheckable.ALLOW_ALL;
    }

    public NfsIdMapping getIdMapper() {
        return new SimpleIdMap();
    }

    public boolean getCaseInsensitive() {
        switch (this.bookmark.getProtocol().getCaseSensitivity()) {
            case insensitive: {
                return true;
            }
        }
        return false;
    }

    public boolean getCasePreserving() {
        return true;
    }

    static final class UnixUtils {
        private static final Logger _log = LoggerFactory.getLogger(UnixUtils.class);

        UnixUtils() {
        }

        public static Subject getCurrentUser() {
            try {
                long[] groups;
                Class<?> unixSystemClass = Class.forName("com.sun.security.auth.module.UnixSystem");
                Object unixSystemInstance = unixSystemClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method getUidMethod = unixSystemClass.getDeclaredMethod("getUid", new Class[0]);
                Method getGidMethod = unixSystemClass.getDeclaredMethod("getGid", new Class[0]);
                Method getGroupsMethod = unixSystemClass.getDeclaredMethod("getGroups", new Class[0]);
                Subject subject = new Subject();
                subject.getPrincipals().add((Principal)new UidPrincipal(((Long)getUidMethod.invoke(unixSystemInstance, new Object[0])).longValue()));
                subject.getPrincipals().add((Principal)new GidPrincipal(((Long)getGidMethod.invoke(unixSystemInstance, new Object[0])).longValue(), true));
                for (long gid : groups = (long[])getGroupsMethod.invoke(unixSystemInstance, new Object[0])) {
                    subject.getPrincipals().add((Principal)new GidPrincipal(gid, false));
                }
                return subject;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                _log.debug("couldn't get current unix user", (Throwable)e);
                return null;
            }
        }
    }
}

