/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs.nfs;

import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LockedException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.QuotaException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.iterate.mountainduck.exception.DirectoryNotEmptyException;
import ch.iterate.mountainduck.exception.FileAlreadyExistsException;
import ch.iterate.mountainduck.fs.nfs.InodeMapper;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dcache.nfs.status.AccessException;
import org.dcache.nfs.status.DQuotException;
import org.dcache.nfs.status.ExistException;
import org.dcache.nfs.status.NfsIoException;
import org.dcache.nfs.status.NoEntException;
import org.dcache.nfs.status.NotEmptyException;
import org.dcache.nfs.status.NotSuppException;
import org.dcache.nfs.status.StaleException;

public final class NfsErrorMapper {
    private static final Logger log = LogManager.getLogger((String)NfsErrorMapper.class.getName());

    public IOException map(BackgroundException e) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Map failure %s", new Object[]{e}));
        }
        if (e instanceof DirectoryNotEmptyException) {
            return new NotEmptyException(e.getDetail(), (Throwable)e);
        }
        if (e instanceof InodeMapper.InodeNotfoundException) {
            return new StaleException(e.getDetail(), (Throwable)e);
        }
        if (e instanceof NotfoundException) {
            return new NoEntException(e.getDetail(), (Throwable)e);
        }
        if (e instanceof UnsupportedException) {
            return new NotSuppException(e.getDetail(), (Throwable)e);
        }
        if (e instanceof FileAlreadyExistsException) {
            return new ExistException(e.getDetail(), (Throwable)e);
        }
        if (e instanceof LockedException) {
            return new AccessException(e.getDetail());
        }
        if (e instanceof AccessDeniedException) {
            log.warn(String.format("Map failure %s to NFS access fault", new Object[]{e}));
            return new AccessException(e.getDetail(), (Throwable)e);
        }
        if (e instanceof QuotaException) {
            return new DQuotException(e.getDetail(), (Throwable)e);
        }
        log.error(String.format("Map failure %s to NFS server fault", new Object[]{e}));
        return new NfsIoException(e.getDetail(), (Throwable)e);
    }
}

