/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs.nfs;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.NotfoundException;
import ch.iterate.mountainduck.fs.FileidMapper;
import ch.iterate.mountainduck.fs.FilesystemCacheReference;
import com.google.common.primitives.Longs;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dcache.nfs.vfs.FileHandle;
import org.dcache.nfs.vfs.Inode;

public class InodeMapper
implements FileidMapper<Inode> {
    private static final Logger log = LogManager.getLogger((String)InodeMapper.class.getName());
    private final AtomicLong counter = new AtomicLong(1L);
    private final BidiMap<Long, FilesystemCacheReference> fileid = new DualHashBidiMap();

    public Inode toInode(long inodeNumber) {
        return new Inode(new FileHandle.FileHandleBuilder().setExportIdx(1).build(Longs.toByteArray((long)inodeNumber)));
    }

    public long fromInode(Inode inode) {
        return Longs.fromByteArray((byte[])inode.getFileId());
    }

    public synchronized Inode updateOrCreate(Path file) {
        FilesystemCacheReference reference = new FilesystemCacheReference(file);
        if (this.fileid.containsValue((Object)reference)) {
            Long inode = (Long)this.fileid.getKey((Object)reference);
            this.fileid.replace((Object)inode, (Object)reference);
            return this.toInode(inode);
        }
        return this.create(file);
    }

    public synchronized Inode getOrCreate(Path file) {
        FilesystemCacheReference reference = new FilesystemCacheReference(file);
        if (this.fileid.containsValue((Object)reference)) {
            return this.toInode((Long)this.fileid.getKey((Object)reference));
        }
        return this.create(file);
    }

    public synchronized Inode get(Path file) throws NotfoundException {
        Long key = (Long)this.fileid.getKey((Object)new FilesystemCacheReference(file));
        if (null == key) {
            log.trace(String.format("No inode mapping for file %s", file.getAbsolute()));
            throw new InodeNotfoundException(String.format("No inode mapping for file %s", file.getAbsolute()));
        }
        return this.toInode(key);
    }

    private Inode create(Path file) {
        long id = this.counter.getAndIncrement();
        FilesystemCacheReference previous = (FilesystemCacheReference)this.fileid.put((Object)id, (Object)new FilesystemCacheReference(file));
        if (null != previous) {
            log.error(String.format("Previous reference for id %s was not null but %s", id, previous));
        }
        Inode inode = this.toInode(id);
        if (log.isInfoEnabled()) {
            log.info(String.format("Set file inode %s with id %s for path %s", inode, id, file));
        }
        return inode;
    }

    public synchronized Path reverse(Inode inode) throws NotfoundException {
        FilesystemCacheReference reference = (FilesystemCacheReference)this.fileid.get((Object)this.fromInode(inode));
        if (null == reference) {
            throw new InodeNotfoundException(inode.toString());
        }
        Path file = reference.getFile();
        if (log.isTraceEnabled()) {
            log.trace(String.format("Return path %s for inode %s", file, inode));
        }
        return file;
    }

    public synchronized Inode swap(Path file, Path destination) throws NotfoundException {
        Long id = (Long)this.fileid.getKey((Object)new FilesystemCacheReference(file));
        if (null == id) {
            throw new InodeNotfoundException(file.getAbsolute());
        }
        this.fileid.replace((Object)id, (Object)new FilesystemCacheReference(destination));
        if (file.isDirectory()) {
            this.fileid.values().removeIf(reference -> reference.getFile().isChild(file));
        }
        return this.toInode(id);
    }

    public synchronized void clear() {
        this.fileid.clear();
    }

    public synchronized Inode remove(Path file) {
        Long value = (Long)this.fileid.removeValue((Object)new FilesystemCacheReference(file));
        if (null == value) {
            return null;
        }
        Inode inode = this.toInode(value);
        if (log.isInfoEnabled()) {
            log.info(String.format("Removed inode %s with id %s for path %s", inode, value, file));
        }
        return inode;
    }

    public int size() {
        return this.fileid.size();
    }

    public static final class InodeNotfoundException
    extends NotfoundException {
        public InodeNotfoundException(String detail) {
            super(detail);
        }

        public InodeNotfoundException(String detail, Throwable cause) {
            super(detail, cause);
        }
    }
}

