/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue.tape;

import ch.iterate.mountainduck.sync.metadata.DefaultOperationSerializer;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import com.dd.plist.NSDictionary;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLPropertyListParser;
import com.squareup.tape2.ObjectQueue;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.xml.sax.SAXException;

public class TapeXmlPropertyListConverter
implements ObjectQueue.Converter<SerializableOperation> {
    public SerializableOperation from(byte[] bytes) throws IOException {
        try {
            NSDictionary dict = (NSDictionary)XMLPropertyListParser.parse((byte[])bytes);
            return new DefaultOperationSerializer().deserialize(dict);
        }
        catch (PropertyListFormatException | ParseException | ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    public void toStream(SerializableOperation operation, OutputStream bytes) throws IOException {
        NSDictionary dict = new DefaultOperationSerializer().serialize(operation);
        IOUtils.write((String)dict.toXMLPropertyList(), (OutputStream)bytes, (Charset)StandardCharsets.UTF_8);
    }
}

