/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue.tape;

import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.exception.LocalNotfoundException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.AbstractRetryCallable;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.transfer.TransferItem;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.QueueAbortCallback;
import ch.iterate.mountainduck.sync.queue.QueueAcquireCallback;
import ch.iterate.mountainduck.sync.queue.QueueCoalescedCallback;
import ch.iterate.mountainduck.sync.queue.QueueCompletedCallback;
import ch.iterate.mountainduck.sync.queue.QueueDiscardCallback;
import ch.iterate.mountainduck.sync.queue.QueueErrorCallback;
import ch.iterate.mountainduck.sync.queue.QueueSkipCallback;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import ch.iterate.mountainduck.sync.queue.tape.ConcurrentObjectQueue;
import ch.iterate.mountainduck.sync.queue.tape.OperationSkipException;
import ch.iterate.mountainduck.sync.queue.tape.TapeSyncQueueAttributesUpdater;
import ch.iterate.mountainduck.sync.queue.tape.TapeSyncQueueCoalescing;
import ch.iterate.mountainduck.sync.queue.tape.TapeSyncQueueReferenceUpdater;
import ch.iterate.mountainduck.sync.queue.tape.TapeSyncQueueReferenceUpdaterDiscardCallback;
import ch.iterate.mountainduck.sync.queue.tape.TapeSyncQueueReferenceUpdaterErrorCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TapeSyncQueueWorkerReader
implements Callable<Void> {
    private static final Logger log = LogManager.getLogger((String)TapeSyncQueueWorkerReader.class.getName());
    private final Host bookmark;
    private final ConcurrentObjectQueue<SerializableOperation> queue;
    private final SyncQueue proxy;
    private final MetadataService<?> metadata;
    private final TapeSyncQueueReferenceUpdater reference;
    private final TapeSyncQueueAttributesUpdater attributes;
    private final QueueAbortCallback shutdown;
    private final QueueAcquireCallback acquire;
    private final QueueErrorCallback error;
    private final QueueDiscardCallback discard;
    private final QueueCompletedCallback completed;
    private final QueueCoalescedCallback coalesce;
    private final QueueSkipCallback skip;
    private final TapeSyncQueueCoalescing coalescing;
    private final Preferences preferences = PreferencesFactory.get();

    public TapeSyncQueueWorkerReader(Host bookmark, ConcurrentObjectQueue<SerializableOperation> queue, SyncQueue proxy, MetadataService<?> metadata, TapeSyncQueueReferenceUpdater reference, TapeSyncQueueAttributesUpdater attributes, QueueAbortCallback shutdown, QueueAcquireCallback acquire, QueueErrorCallback error, QueueDiscardCallback discard, QueueCoalescedCallback coalesce, QueueSkipCallback skip, QueueCompletedCallback completed) {
        this.bookmark = bookmark;
        this.queue = queue;
        this.proxy = proxy;
        this.metadata = metadata;
        this.reference = reference;
        this.attributes = attributes;
        this.shutdown = shutdown;
        this.acquire = acquire;
        this.error = new TapeSyncQueueReferenceUpdaterErrorCallback(reference, error);
        this.discard = new TapeSyncQueueReferenceUpdaterDiscardCallback(reference, discard);
        this.coalesce = coalesce;
        this.skip = skip;
        this.coalescing = new TapeSyncQueueCoalescing(queue, reference, metadata);
        this.completed = completed;
    }

    @Override
    public Void call() {
        HashMap distinct = new HashMap();
        if (log.isDebugEnabled()) {
            log.debug("Filter pending operations by distinct file in cache");
        }
        this.queue.asList().forEach(operation -> distinct.putIfAbsent(operation.getLocal(), operation));
        for (SerializableOperation operation2 : distinct.values()) {
            this.acquire.operationResumed(operation2);
        }
        distinct.clear();
        while (!this.shutdown.isStopped()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Peek for operation in worker queue with size %d", this.queue.size()));
            }
            try {
                SerializableOperation operation3 = this.queue.poll();
                if (null == operation3) {
                    log.debug(String.format("Abort reading from worker queue %s", this.queue));
                    break;
                }
                try {
                    switch (operation3.getOperation()) {
                        case write: 
                        case read: 
                        case delete: 
                        case mkdir: {
                            if (this.metadata.read(operation3.getLocal(), MetadataStorage.Key.skip) == null) break;
                            this.coalescing.clear(operation3);
                            log.warn(String.format("Skip operation %s already coalesced", operation3));
                            throw new OperationSkipException(operation3, String.format("Skip operation %s previously coalesced", operation3));
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Sync operation %s", operation3));
                    }
                    this.discard(new OperationRetryCallable(operation3).call());
                }
                catch (OperationSkipException e) {
                    this.skipped(e.getOperation());
                }
                catch (BackgroundException failure) {
                    this.error(operation3, failure);
                }
            }
            catch (Error | Exception e) {
                log.error(String.format("Failure %s polling worker queue", e), e);
                try {
                    this.queue.close();
                }
                catch (IOException c) {
                    log.warn(String.format("Ignore failure %s closing queue", c));
                }
                break;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    protected void error(SerializableOperation operation, BackgroundException failure) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void discard(SerializableOperation operation) throws IOException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Remove operation %s from worker queue", operation));
        }
        try {
            this.queue.remove();
        }
        catch (Throwable throwable) {
            switch (operation.getOperation()) {
                case write: 
                case read: {
                    this.discard.operationDiscarded(new SerializableOperation[]{new SerializableOperation(Operation.list, operation.getLocal(), operation.getRemote().isFile() ? operation.getRemote().getParent() : operation.getRemote())});
                    break;
                }
                default: {
                    this.discard.operationDiscarded(new SerializableOperation[]{operation});
                }
            }
            this.completed.operationCompleted(operation);
            throw throwable;
        }
        switch (operation.getOperation()) {
            case write: 
            case read: {
                this.discard.operationDiscarded(new SerializableOperation[]{new SerializableOperation(Operation.list, operation.getLocal(), operation.getRemote().isFile() ? operation.getRemote().getParent() : operation.getRemote())});
                break;
            }
            default: {
                this.discard.operationDiscarded(new SerializableOperation[]{operation});
            }
        }
        this.completed.operationCompleted(operation);
    }

    protected void skipped(SerializableOperation operation) throws IOException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Remove skipped operation %s from worker queue", operation));
        }
        try {
            this.queue.remove();
        }
        catch (Throwable throwable) {
            log.warn(String.format("Skip file status update for skipped operation %s", operation));
            switch (operation.getOperation()) {
                default: 
            }
            this.skip.operationSkipped(operation);
            this.completed.operationCompleted(operation);
            throw throwable;
        }
        log.warn(String.format("Skip file status update for skipped operation %s", operation));
        switch (operation.getOperation()) {
            default: 
        }
        this.skip.operationSkipped(operation);
        this.completed.operationCompleted(operation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TapeSyncQueueWorkerReader{");
        sb.append("workerQueue=").append(this.queue);
        sb.append(", proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }

    private final class OperationRetryCallable
    extends AbstractRetryCallable<SerializableOperation> {
        private final SerializableOperation task;

        public OperationRetryCallable(SerializableOperation task) {
            super(TapeSyncQueueWorkerReader.this.bookmark, TapeSyncQueueWorkerReader.this.preferences.getInteger("fs.sync.retry.count"), TapeSyncQueueWorkerReader.this.preferences.getInteger("fs.sync.retry.delay"));
            this.task = task;
        }

        public SerializableOperation call() throws BackgroundException {
            SerializableOperation operation = TapeSyncQueueWorkerReader.this.attributes.update(TapeSyncQueueWorkerReader.this.reference.update(this.task, true, false));
            try {
                switch (operation.getOperation()) {
                    case purge: {
                        TapeSyncQueueWorkerReader.this.proxy.purge(operation.getLocal(), operation.getRemote());
                        break;
                    }
                    case read: {
                        ArrayList<TransferItem> transfers = new ArrayList<TransferItem>();
                        transfers.add(new TransferItem(operation.getRemote(), operation.getLocal()));
                        Map<TransferItem, SerializableOperation> coalesced = TapeSyncQueueWorkerReader.this.coalescing.collect(operation, TapeSyncQueueWorkerReader.this.coalesce);
                        transfers.addAll(coalesced.keySet());
                        this.read(operation, transfers, coalesced);
                        break;
                    }
                    case write: {
                        ArrayList<TransferItem> transfers = new ArrayList<TransferItem>();
                        transfers.add(new TransferItem(operation.getRemote(), operation.getLocal()));
                        Map<TransferItem, SerializableOperation> coalesced = TapeSyncQueueWorkerReader.this.coalescing.collect(operation, EnumSet.of(Operation.write, Operation.mkdir), TapeSyncQueueWorkerReader.this.coalesce);
                        transfers.addAll(coalesced.keySet());
                        this.write(operation, transfers, coalesced);
                        break;
                    }
                    case rename: {
                        TapeSyncQueueWorkerReader.this.proxy.rename(operation.getLocal(), operation.getLocalArg(), operation.getRemote(), operation.getArg());
                        break;
                    }
                    case delete: {
                        ArrayList<TransferItem> transfers = new ArrayList<TransferItem>();
                        transfers.add(new TransferItem(operation.getRemote(), operation.getLocal()));
                        Map<TransferItem, SerializableOperation> coalesced = TapeSyncQueueWorkerReader.this.coalescing.collect(operation, TapeSyncQueueWorkerReader.this.coalesce);
                        transfers.addAll(coalesced.keySet());
                        this.delete(transfers, coalesced);
                        break;
                    }
                    case mkdir: {
                        TapeSyncQueueWorkerReader.this.proxy.mkdir(operation.getLocal(), operation.getRemote());
                        break;
                    }
                    case timestamp: {
                        TapeSyncQueueWorkerReader.this.proxy.timestamp(operation.getLocal(), operation.getRemote(), Long.valueOf(operation.getAttr().getModificationDate()));
                        break;
                    }
                    case chmod: {
                        TapeSyncQueueWorkerReader.this.proxy.chmod(operation.getLocal(), operation.getRemote(), operation.getAttr().getPermission());
                        break;
                    }
                    case symlink: {
                        TapeSyncQueueWorkerReader.this.proxy.symlink(operation.getLocal(), operation.getLocalArg(), operation.getRemote(), operation.getArg());
                        break;
                    }
                    case lock: {
                        TapeSyncQueueWorkerReader.this.proxy.lock(operation.getLocal(), operation.getRemote());
                        break;
                    }
                    case unlock: {
                        TapeSyncQueueWorkerReader.this.proxy.unlock(operation.getLocal(), operation.getRemote(), operation.getAttr().getLockId());
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info(String.format("Completed sync operation %s", operation));
                }
                return operation;
            }
            catch (BackgroundException failure) {
                if (!this.retry(failure, (ProgressListener)new DisabledProgressListener(), new ShutdownBackgroundActionState())) {
                    log.warn(String.format("Cancel retry for operation %s with failure %s", new Object[]{operation, failure}));
                    throw failure;
                }
                log.warn(String.format("Repeat operation %s with failure %s", new Object[]{operation, failure}));
                return this.call();
            }
        }

        private void delete(List<TransferItem> transfers, final Map<TransferItem, SerializableOperation> coalesced) throws BackgroundException {
            TapeSyncQueueWorkerReader.this.proxy.delete(transfers, new QueueDiscardCallback(){

                public void operationDiscarded(SerializableOperation ... operations) {
                    for (SerializableOperation o : operations) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Remove completed operation %s from coalesced set", o));
                        }
                        if (!coalesced.entrySet().removeIf(entry -> ((SerializableOperation)entry.getValue()).getLocal().equals((Object)o.getLocal()))) continue;
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Mark coalesced operation %s with skip flag", o));
                        }
                        TapeSyncQueueWorkerReader.this.coalescing.skip(o);
                    }
                    TapeSyncQueueWorkerReader.this.discard.operationDiscarded(operations);
                }
            });
        }

        private void read(SerializableOperation operation, List<TransferItem> transfers, final Map<TransferItem, SerializableOperation> coalesced) throws BackgroundException {
            TapeSyncQueueWorkerReader.this.proxy.read(transfers, new QueueDiscardCallback(){

                public void operationDiscarded(SerializableOperation ... operations) {
                    for (SerializableOperation o : operations) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Remove completed operation %s from coalesced set", o));
                        }
                        if (!coalesced.entrySet().removeIf(entry -> ((SerializableOperation)entry.getValue()).getLocal().equals((Object)o.getLocal()))) continue;
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Mark coalesced operation %s with skip flag", o));
                        }
                        TapeSyncQueueWorkerReader.this.coalescing.skip(o);
                    }
                    TapeSyncQueueWorkerReader.this.discard.operationDiscarded(operations);
                }
            }, new QueueErrorCallback(){

                public void operationFailed(SerializableOperation operation, BackgroundException failure) {
                    TapeSyncQueueWorkerReader.this.error.operationFailed(operation, failure);
                }
            });
        }

        private void write(SerializableOperation operation, List<TransferItem> transfers, final Map<TransferItem, SerializableOperation> coalesced) throws BackgroundException {
            TapeSyncQueueWorkerReader.this.proxy.write(transfers, TapeSyncQueueWorkerReader.this.coalesce, new QueueDiscardCallback(){

                public void operationDiscarded(SerializableOperation ... operations) {
                    for (SerializableOperation o : operations) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Remove completed operation %s from coalesced set", o));
                        }
                        if (!coalesced.entrySet().removeIf(entry -> ((SerializableOperation)entry.getValue()).getLocal().equals((Object)o.getLocal()))) continue;
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Mark coalesced operation %s with skip flag", o));
                        }
                        TapeSyncQueueWorkerReader.this.coalescing.skip(o);
                    }
                    TapeSyncQueueWorkerReader.this.discard.operationDiscarded(operations);
                }
            }, new QueueErrorCallback(){

                public void operationFailed(SerializableOperation operation, BackgroundException failure) {
                    if (failure instanceof LocalAccessDeniedException || failure instanceof LocalNotfoundException) {
                        try {
                            SerializableOperation updated = TapeSyncQueueWorkerReader.this.reference.update(operation, true, false);
                            if (!updated.equals((Object)operation)) {
                                log.warn(String.format("Retry failed operation %s with updated reference %s for failure %s", new Object[]{operation, updated, failure}));
                                try {
                                    TransferItem item = new TransferItem(updated.getRemote(), updated.getLocal());
                                    TapeSyncQueueWorkerReader.this.proxy.write(Collections.singletonList(item), TapeSyncQueueWorkerReader.this.coalesce, TapeSyncQueueWorkerReader.this.discard, TapeSyncQueueWorkerReader.this.error, updated.getApplication());
                                    return;
                                }
                                catch (BackgroundException e) {
                                    log.warn(String.format("Skip retry of operation %s with failure %s. %s", new Object[]{operation, failure, e}));
                                }
                            }
                        }
                        catch (OperationSkipException ignored) {
                            log.warn(String.format("Skip retry for operation %s with failure %s", new Object[]{operation, failure}));
                        }
                    }
                    TapeSyncQueueWorkerReader.this.error.operationFailed(operation, failure);
                }
            }, operation.getApplication());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("OperationRetryCallable{");
            sb.append("operation=").append(this.task);
            sb.append('}');
            return sb.toString();
        }

        private final class ShutdownBackgroundActionState
        implements BackgroundActionState {
            private ShutdownBackgroundActionState() {
            }

            public boolean isCanceled() {
                return TapeSyncQueueWorkerReader.this.shutdown.isStopped();
            }

            public boolean isRunning() {
                return true;
            }
        }
    }
}

