/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue.tape;

import ch.cyberduck.core.Path;
import ch.iterate.mountainduck.fs.FilenameMatchPathPredicate;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import ch.iterate.mountainduck.sync.queue.tape.ConcurrentObjectQueue;
import ch.iterate.mountainduck.sync.queue.tape.OperationSkipException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TapeSyncQueueReferenceUpdater {
    private static final Logger log = LogManager.getLogger((String)TapeSyncQueueReferenceUpdater.class.getName());
    private final LocalCache<?> cache;
    private final ConcurrentObjectQueue<SerializableOperation>[] queues;

    public TapeSyncQueueReferenceUpdater(LocalCache<?> cache, ConcurrentObjectQueue<SerializableOperation> ... queues) {
        this.cache = cache;
        this.queues = queues;
    }

    public SerializableOperation update(SerializableOperation operation, boolean local, boolean remote) throws OperationSkipException {
        if (null == operation) {
            return null;
        }
        SerializableOperation updated = operation;
        switch (operation.getOperation()) {
            default: {
                for (ConcurrentObjectQueue<SerializableOperation> queue : this.queues) {
                    for (SerializableOperation next : queue.asList()) {
                        if (next.equals((Object)updated)) continue;
                        switch (next.getOperation()) {
                            case purge: {
                                if (Operation.read != operation.getOperation()) break;
                                if (new FilenameMatchPathPredicate(next.getRemote()).test(updated.getRemote())) {
                                    throw new OperationSkipException(updated, String.format("Skip operation %s with pending purge for file %s", updated, next.getRemote()));
                                }
                                if (!new FilenameMatchPathPredicate(next.getRemote()).isChild(updated.getRemote())) break;
                                throw new OperationSkipException(updated, String.format("Skip operation %s with pending purge for parent %s", updated, next.getRemote()));
                            }
                            case delete: {
                                if (Operation.rename == operation.getOperation()) break;
                                if (new FilenameMatchPathPredicate(next.getRemote()).test(updated.getRemote())) {
                                    throw new OperationSkipException(updated, String.format("Skip operation %s with pending delete for file %s", updated, next.getRemote()));
                                }
                                if (!new FilenameMatchPathPredicate(next.getRemote()).isChild(updated.getRemote())) break;
                                throw new OperationSkipException(updated, String.format("Skip operation %s with pending delete for parent %s", updated, next.getRemote()));
                            }
                            case rename: {
                                if (Operation.rename == operation.getOperation()) break;
                                if (new FilenameMatchPathPredicate(next.getRemote()).test(updated.getRemote())) {
                                    updated = new SerializableOperation(updated).withRemote(next.getArg()).withLocal(next.getLocalArg());
                                    if (log.isInfoEnabled()) {
                                        log.info(String.format("Found pending rename operation %s. Update references for operation %s to %s", next, updated, updated));
                                    }
                                }
                                if (!new FilenameMatchPathPredicate(updated.getRemote()).isChild(next.getRemote())) break;
                                Path r = new Path(String.format("%s%s%s", next.getArg().getAbsolute(), Character.valueOf('/'), StringUtils.removeStart((String)updated.getRemote().getAbsolute(), (String)next.getRemote().getAbsolute())), updated.getRemote().getType());
                                updated = new SerializableOperation(updated).withRemote(r).withLocal(this.cache.toLocal(r));
                                if (!log.isInfoEnabled()) break;
                                log.info(String.format("Found pending rename operation %s. Update references for operation %s to %s", next, updated, updated));
                            }
                        }
                    }
                }
                break;
            }
            case delete: {
                for (ConcurrentObjectQueue<SerializableOperation> queue : this.queues) {
                    for (SerializableOperation next : queue.asList()) {
                        if (next.equals((Object)updated)) continue;
                        switch (next.getOperation()) {
                            case write: {
                                if (!new FilenameMatchPathPredicate(next.getRemote()).test(updated.getRemote())) break;
                                throw new OperationSkipException(updated, String.format("Skip operation %s with pending write for file %s", updated, next.getRemote()));
                            }
                        }
                    }
                }
            }
        }
        if (!local) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Reset local to %s for operation %s", operation.getLocal(), updated));
            }
            updated.withLocal(operation.getLocal());
        }
        if (!remote) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Reset remote to %s for operation %s", operation.getRemote(), updated));
            }
            updated.withRemote(operation.getRemote());
        }
        if (log.isDebugEnabled() && updated.equals((Object)operation)) {
            log.debug(String.format("No reference update for operation %s", operation));
        }
        return updated;
    }
}

