/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue.tape;

import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import ch.iterate.mountainduck.sync.queue.tape.ConcurrentObjectQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TapeSyncQueueDuplicateFinder {
    private static final Logger log = LogManager.getLogger((String)TapeSyncQueueDuplicateFinder.class.getName());
    private final ConcurrentObjectQueue<SerializableOperation> queue;
    private final Operation type;

    public TapeSyncQueueDuplicateFinder(ConcurrentObjectQueue<SerializableOperation> queue, Operation type) {
        this.queue = queue;
        this.type = type;
    }

    public boolean find(SerializableOperation operation) {
        if (!operation.getOperation().equals((Object)this.type)) {
            log.debug(String.format("Skip finding duplicate for operation of type %s", this.type));
            return false;
        }
        for (SerializableOperation next : this.queue.asList()) {
            if (!next.equals((Object)operation)) continue;
            if (log.isInfoEnabled()) {
                log.info(String.format("Duplicate found for %s", operation));
            }
            return true;
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("No duplicates found for %s", operation));
        }
        return false;
    }
}

