/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue.tape;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferItem;
import ch.iterate.mountainduck.fs.FilenameMatchPathPredicate;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.QueueCoalescedCallback;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import ch.iterate.mountainduck.sync.queue.tape.ConcurrentObjectQueue;
import ch.iterate.mountainduck.sync.queue.tape.OperationSkipException;
import ch.iterate.mountainduck.sync.queue.tape.TapeSyncQueueReferenceUpdater;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TapeSyncQueueCoalescing {
    private static final Logger log = LogManager.getLogger((String)TapeSyncQueueCoalescing.class.getName());
    private final ConcurrentObjectQueue<SerializableOperation> queue;
    private final TapeSyncQueueReferenceUpdater reference;
    private final MetadataService<?> metadata;
    private static final long DELAY = PreferencesFactory.get().getLong("fs.sync.coalesce.delay.ms");
    private static final int LIMIT = PreferencesFactory.get().getInteger("fs.sync.coalesce.limit");

    public TapeSyncQueueCoalescing(ConcurrentObjectQueue<SerializableOperation> queue, TapeSyncQueueReferenceUpdater reference, MetadataService<?> metadata) {
        this.queue = queue;
        this.reference = reference;
        this.metadata = metadata;
    }

    public Map<TransferItem, SerializableOperation> collect(SerializableOperation operation, QueueCoalescedCallback listener) {
        return this.collect(operation, EnumSet.of(operation.getOperation()), listener);
    }

    public Map<TransferItem, SerializableOperation> collect(SerializableOperation operation, EnumSet<Operation> types, QueueCoalescedCallback listener) {
        if (DELAY > 0L) {
            log.warn(String.format("Delay coalescing for %dms for operation %s", DELAY, operation));
            try {
                TimeUnit.MILLISECONDS.sleep(DELAY);
            }
            catch (InterruptedException e) {
                log.warn(String.format("Failure with delay for coalescing of operation %s. %s", operation, e.getMessage()));
            }
        }
        ConcurrentHashMap<TransferItem, SerializableOperation> transfers = new ConcurrentHashMap<TransferItem, SerializableOperation>();
        int n = 0;
        for (SerializableOperation o : this.queue.asList()) {
            SerializableOperation next;
            if (n >= LIMIT) {
                if (!log.isDebugEnabled()) break;
                log.debug(String.format("Stop coalescing after %d operations", n));
                break;
            }
            try {
                next = this.reference.update(o, true, false);
            }
            catch (OperationSkipException e) {
                continue;
            }
            if (types.contains(next.getOperation())) {
                if (0 == n && next.equals((Object)operation)) {
                    ++n;
                    continue;
                }
                if (!new FilenameMatchPathPredicate(next.getRemote()).test(operation.getRemote())) {
                    if (null != this.metadata.read(next.getLocal(), MetadataStorage.Key.skip)) {
                        log.warn(String.format("Ignore operation %s with skip flag set", next));
                        continue;
                    }
                    if (null != this.metadata.read(next.getLocal(), MetadataStorage.Key.error)) {
                        log.warn(String.format("Ignore operation %s with error flag set and abort coalescing", next));
                        break;
                    }
                    TransferItem item = new TransferItem(next.getRemote(), next.getLocal());
                    if (transfers.containsKey(item)) {
                        if (log.isWarnEnabled()) {
                            log.warn(String.format("Set skip flag for file %s with duplicate operation already coalesced %s", next.getRemote(), next));
                        }
                        this.skip(next);
                    } else {
                        if (log.isInfoEnabled()) {
                            log.info(String.format("Add transfer item %s", item));
                        }
                        transfers.put(item, next);
                        if (log.isInfoEnabled()) {
                            log.info(String.format("Coalesce %s with %s in single transfer (%d items)", next, operation, transfers.size()));
                        }
                        listener.operationCoalesced(next);
                    }
                } else if (operation.equals((Object)next)) {
                    if (log.isWarnEnabled()) {
                        log.warn(String.format("Set skip flag for file %s with duplicate operation %s", next.getRemote(), next));
                    }
                    this.skip(next);
                }
                ++n;
                continue;
            }
            if (Operation.timestamp.equals((Object)next.getOperation()) || Operation.chmod.equals((Object)next.getOperation())) continue;
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Coalesced %d files for operation %s", transfers.size(), operation));
        }
        return transfers;
    }

    public void clear(SerializableOperation operation) {
        if (0L == this.decrementSkip(operation.getLocal())) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Delete skip flag for file %s", operation.getRemote()));
            }
            this.metadata.delete(operation.getLocal(), MetadataStorage.Key.skip);
        }
    }

    public void skip(SerializableOperation operation) {
        this.incrementSkip(operation.getLocal());
    }

    private long incrementSkip(Local local) {
        long count = this.readSkipCount(local) + 1L;
        this.writeSkipCount(local, count);
        return count;
    }

    private long decrementSkip(Local local) {
        long count = this.readSkipCount(local) - 1L;
        this.writeSkipCount(local, count);
        return count;
    }

    private void writeSkipCount(Local local, long value) {
        NSDictionary skip = new NSDictionary();
        skip.put(MetadataStorage.Key.skip.name(), (Object)String.valueOf(value));
        this.metadata.write(local, MetadataStorage.Key.skip, skip);
    }

    private long readSkipCount(Local local) {
        NSObject value;
        NSDictionary skip = this.metadata.read(local, MetadataStorage.Key.skip);
        if (skip != null && (value = skip.objectForKey(MetadataStorage.Key.skip.name())) != null) {
            return Long.parseLong(value.toString());
        }
        return 0L;
    }
}

