/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue.tape;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.mountainduck.sync.conflict.ChecksumConflictResolutionStrategy;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.QueueAbortCallback;
import ch.iterate.mountainduck.sync.queue.QueueAcquireCallback;
import ch.iterate.mountainduck.sync.queue.QueueCoalescedCallback;
import ch.iterate.mountainduck.sync.queue.QueueCompletedCallback;
import ch.iterate.mountainduck.sync.queue.QueueDiscardCallback;
import ch.iterate.mountainduck.sync.queue.QueueErrorCallback;
import ch.iterate.mountainduck.sync.queue.QueueSkipCallback;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import ch.iterate.mountainduck.sync.queue.tape.ConcurrentObjectQueue;
import ch.iterate.mountainduck.sync.queue.tape.TapeSyncQueueAttributesUpdater;
import ch.iterate.mountainduck.sync.queue.tape.TapeSyncQueueDuplicateFinder;
import ch.iterate.mountainduck.sync.queue.tape.TapeSyncQueueReferenceUpdater;
import ch.iterate.mountainduck.sync.queue.tape.TapeSyncQueueWorkerReader;
import com.dd.plist.NSDictionary;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TapeSyncQueueBufferReader
implements Callable<Void> {
    private static final Logger log = LogManager.getLogger((String)TapeSyncQueueBufferReader.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final MetadataService<?> metadata;
    private final ConcurrentObjectQueue<SerializableOperation> bufferQueue;
    private final ConcurrentObjectQueue<SerializableOperation> workerQueue;
    private final ThreadPool workerPool;
    private final QueueAcquireCallback acquire;
    private final QueueAbortCallback shutdown;

    public TapeSyncQueueBufferReader(Host bookmark, SyncQueue proxy, MetadataService<?> metadata, TapeSyncQueueReferenceUpdater reference, TapeSyncQueueAttributesUpdater attributes, ConcurrentObjectQueue<SerializableOperation> bufferQueue, ConcurrentObjectQueue<SerializableOperation> workerQueue, QueueAbortCallback shutdown, QueueErrorCallback error, QueueAcquireCallback acquire, QueueDiscardCallback discard, QueueCoalescedCallback coalesce, QueueSkipCallback skip, QueueCompletedCallback completed) {
        this.metadata = metadata;
        this.bufferQueue = bufferQueue;
        this.workerQueue = workerQueue;
        this.shutdown = shutdown;
        this.acquire = acquire;
        this.workerPool = ThreadPoolFactory.get((String)workerQueue.name(), (int)1, (ThreadPool.Priority)ThreadPool.Priority.valueOf((String)PreferencesFactory.get().getProperty("fs.sync.queue.thread.priority")), new LinkedBlockingQueue(), (Thread.UncaughtExceptionHandler)new LoggingUncaughtExceptionHandler());
        this.workerPool.execute((Callable)new TapeSyncQueueWorkerReader(bookmark, workerQueue, proxy, metadata, reference, attributes, shutdown, acquire, error, discard, coalesce, skip, completed));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() {
        try {
            block14: while (!this.shutdown.isStopped()) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Peek for operation in buffer queue with size %d", this.bufferQueue.size()));
                }
                try {
                    SerializableOperation operation = this.bufferQueue.poll();
                    if (null == operation) {
                        log.debug(String.format("Abort reading from buffer queue %s", this.bufferQueue));
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Acquired lock for operation %s in queue %s", operation, this.workerQueue));
                    }
                    switch (operation.getOperation()) {
                        case write: {
                            if (!operation.getRemote().isFile()) break;
                            try {
                                Checksum checksum = ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.valueOf((String)this.preferences.getProperty("fs.sync.queue.checksum"))).compute(operation.getLocal().getInputStream(), new TransferStatus());
                                switch (new ChecksumConflictResolutionStrategy(this.metadata).resolve(operation.getLocal(), new PathAttributes().withChecksum(checksum))) {
                                    case equal: {
                                        if (log.isWarnEnabled()) {
                                            log.warn(String.format("Skip operation %s with equal checksum", operation));
                                        }
                                        this.bufferQueue.remove();
                                        continue block14;
                                    }
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug(String.format("Set write in progress flag for file %s with checksum %s", operation.getRemote(), checksum));
                                }
                                NSDictionary dict = new NSDictionary();
                                dict.put("Checksum", (Object)checksum.hash);
                                this.metadata.write(operation.getLocal(), MetadataStorage.Key.write, dict);
                                operation.withChecksum(checksum);
                                break;
                            }
                            catch (AccessDeniedException | ChecksumException | IllegalArgumentException e) {
                                log.warn(String.format("Failure creating checksum for %s", operation.getLocal()));
                            }
                        }
                    }
                    if (new TapeSyncQueueDuplicateFinder(this.workerQueue, Operation.write).find(operation) || new TapeSyncQueueDuplicateFinder(this.workerQueue, Operation.timestamp).find(operation) || new TapeSyncQueueDuplicateFinder(this.workerQueue, Operation.chmod).find(operation)) {
                        log.warn(String.format("Skip duplicate operation %s", operation));
                    } else {
                        if (log.isInfoEnabled()) {
                            log.info(String.format("Put operation %s to worker queue %s", operation, this.workerQueue));
                        }
                        this.acquire.operationAcquired(operation);
                        this.workerQueue.add(operation);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Remove operation %s from buffer queue %s", operation, this.bufferQueue));
                    }
                    this.bufferQueue.remove();
                }
                catch (Error | Exception e) {
                    log.error(String.format("Failure %s polling buffer queue", e), e);
                    try {
                        this.bufferQueue.close();
                        break;
                    }
                    catch (IOException c) {
                        log.warn(String.format("Ignore failure %s closing queue", c));
                        break;
                    }
                }
            }
            this.workerQueue.notifier().awake();
        }
        catch (Throwable throwable) {
            this.workerQueue.notifier().awake();
            if (log.isInfoEnabled()) {
                log.info(String.format("Shutdown worker pool %s", this.workerPool));
            }
            this.workerPool.shutdown(true);
            throw throwable;
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Shutdown worker pool %s", this.workerPool));
        }
        this.workerPool.shutdown(true);
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TapeSyncQueueBufferReader{");
        sb.append("bufferQueue=").append(this.bufferQueue);
        sb.append(", workerQueue=").append(this.workerQueue);
        sb.append('}');
        return sb.toString();
    }
}

