/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue.tape;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.serializer.PathAttributesDictionary;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import ch.iterate.mountainduck.sync.status.PlaceholderStatusService;
import com.dd.plist.NSDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TapeSyncQueueAttributesUpdater {
    private static final Logger log = LogManager.getLogger((String)TapeSyncQueueAttributesUpdater.class.getName());
    private final LocalCache<?> cache;
    private final MetadataService<?> metadata;

    public TapeSyncQueueAttributesUpdater(LocalCache<?> cache, MetadataService<?> metadata) {
        this.cache = cache;
        this.metadata = metadata;
    }

    public SerializableOperation update(SerializableOperation operation) {
        switch (new PlaceholderStatusService(this.cache, this.metadata).getStatus(operation.getLocal()).getState()) {
            case unknown: 
            case local: {
                log.warn(String.format("Skip reading metadata for file %s", operation.getRemote()));
                break;
            }
            default: {
                PathAttributes attr;
                Local local;
                switch (operation.getOperation()) {
                    case rename: {
                        local = operation.getLocalArg();
                        break;
                    }
                    default: {
                        local = operation.getLocal();
                    }
                }
                NSDictionary meta = this.metadata.read(local, MetadataStorage.Key.metadata);
                if (null == meta) {
                    log.error(String.format("Missing metadata for file %s", operation.getRemote()));
                    attr = new PathAttributes(operation.getRemote().attributes());
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Read metadata for %s", operation));
                    }
                    attr = new PathAttributesDictionary().deserialize((Object)meta);
                }
                if (null != attr.getVersionId()) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Nullify version for %s in operation %s", operation.getRemote(), operation));
                    }
                    attr.setVersionId(null);
                }
                if (null != attr.getFileId()) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Nullify file id for %s in operation %s", operation.getRemote(), operation));
                    }
                    attr.setFileId(null);
                }
                operation.getRemote().setAttributes(attr);
            }
        }
        return operation;
    }
}

