/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue.tape;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.DefaultLocalDirectoryFeature;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.AlertCallback;
import ch.cyberduck.core.threading.DefaultFailureDiagnostics;
import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.core.threading.NamedThreadFactory;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.transfer.TransferItem;
import ch.iterate.mountainduck.fs.NotificationServiceAlertCallback;
import ch.iterate.mountainduck.fs.status.FileStatusService;
import ch.iterate.mountainduck.service.ReloadService;
import ch.iterate.mountainduck.sync.SyncQueuePauseDiagnostics;
import ch.iterate.mountainduck.sync.cache.CacheEncryptor;
import ch.iterate.mountainduck.sync.cache.LocalCache;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.lock.QueueLock;
import ch.iterate.mountainduck.sync.metadata.DefaultExceptionSerializer;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import ch.iterate.mountainduck.sync.queue.BlockingSyncQueue;
import ch.iterate.mountainduck.sync.queue.LockingQueueNotifier;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.QueueAbortCallback;
import ch.iterate.mountainduck.sync.queue.QueueAcquireCallback;
import ch.iterate.mountainduck.sync.queue.QueueCoalescedCallback;
import ch.iterate.mountainduck.sync.queue.QueueCompletedCallback;
import ch.iterate.mountainduck.sync.queue.QueueDiscardCallback;
import ch.iterate.mountainduck.sync.queue.QueueErrorCallback;
import ch.iterate.mountainduck.sync.queue.QueueNotifier;
import ch.iterate.mountainduck.sync.queue.QueueSkipCallback;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import ch.iterate.mountainduck.sync.queue.SerializableOperationException;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import ch.iterate.mountainduck.sync.queue.tape.ConcurrentObjectQueue;
import ch.iterate.mountainduck.sync.queue.tape.SerializableOperationQueue;
import ch.iterate.mountainduck.sync.queue.tape.TapeBinaryPropertyListConverter;
import ch.iterate.mountainduck.sync.queue.tape.TapeSyncQueueAttributesUpdater;
import ch.iterate.mountainduck.sync.queue.tape.TapeSyncQueueBufferReader;
import ch.iterate.mountainduck.sync.queue.tape.TapeSyncQueueReferenceUpdater;
import ch.iterate.mountainduck.sync.status.DeleteInProgressStatusService;
import com.dd.plist.NSDictionary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TapeSyncQueue
implements SyncQueue,
QueueAbortCallback,
QueueErrorCallback,
QueueDiscardCallback,
QueueCoalescedCallback,
QueueSkipCallback,
QueueAcquireCallback,
QueueCompletedCallback {
    private static final Logger log = LogManager.getLogger((String)TapeSyncQueue.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final Set<SyncQueue.Listener> listeners = new HashSet<SyncQueue.Listener>();
    private final MetadataService<?> metadata;
    private final SyncQueue proxy;
    private final int numWorkers = this.preferences.getInteger("fs.sync.queue.pool.size");
    private final AlertCallback alert = new NotificationServiceAlertCallback();
    private final Host bookmark;
    private final LocalCache<?> cache;
    private final FileHistory history;
    private ThreadPool bufferReaderPool;
    private SerializableOperationQueue bufferQueue;
    private final List<SerializableOperationQueue> workerQueues = new ArrayList<SerializableOperationQueue>();
    private final ReloadService reload;
    private final Local directory;
    private ExecutorService executor;
    private SyncQueue.Status status = SyncQueue.Status.none;
    private final Set<Path> queueing = new CopyOnWriteArraySet<Path>();
    private final AtomicLong pending = new AtomicLong();
    private final QueueNotifier notifier = new LockingQueueNotifier(new QueueAbortCallback(){

        public boolean isStopped() {
            if (TapeSyncQueue.this.isStopped()) {
                return true;
            }
            return TapeSyncQueue.this.pending.get() == 0L;
        }
    });
    private final Lock sync = new ReentrantLock();

    public TapeSyncQueue(Controller controller, SessionPool fs, LocalCache<?> cache, QueueLock<?> lock, MetadataService<?> metadata, FileHistory history, ReloadService reload) {
        this(controller, fs, cache, metadata, history, reload, (SyncQueue)new BlockingSyncQueue(controller, fs, cache, lock, metadata, history, reload));
    }

    public TapeSyncQueue(Controller controller, SessionPool fs, LocalCache<?> cache, MetadataService<?> metadata, FileHistory history, ReloadService reload, SyncQueue proxy) {
        this(controller, fs, cache, metadata, history, reload, proxy, SyncQueue.directory((Host)fs.getHost()));
    }

    public TapeSyncQueue(Controller controller, SessionPool fs, LocalCache<?> cache, MetadataService<?> metadata, FileHistory history, ReloadService reload, SyncQueue proxy, Local directory) {
        this.reload = reload;
        this.directory = directory;
        this.bookmark = fs.getHost();
        this.metadata = metadata;
        this.cache = cache;
        this.history = history;
        this.proxy = proxy;
    }

    public boolean isStopped() {
        switch (this.status) {
            case none: 
            case pausing: 
            case paused: 
            case stopped: {
                return true;
            }
        }
        return false;
    }

    public void operationResumed(SerializableOperation operation) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Resume operation %s", operation));
        }
        for (SyncQueue.Listener listener : this.listeners) {
            listener.fileStatusChanged(Collections.singleton(operation.getRemote()), operation.getOperation(), new FileStatusService.Status(FileStatusService.SyncState.inprogress));
        }
    }

    public void operationAcquired(SerializableOperation operation) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Acquired operation %s", operation));
        }
        this.pending.incrementAndGet();
        this.metadata.delete(operation.getLocal(), MetadataStorage.Key.error);
        if (null != operation.getLocalArg()) {
            this.metadata.delete(operation.getLocalArg(), MetadataStorage.Key.error);
        }
        for (SyncQueue.Listener listener : this.listeners) {
            listener.fileStatusChanged(Collections.singleton(operation.getRemote()), operation.getOperation(), new FileStatusService.Status(FileStatusService.SyncState.inprogress));
        }
    }

    public void operationDiscarded(SerializableOperation ... operations) {
        for (SerializableOperation operation : operations) {
            if (!log.isInfoEnabled()) continue;
            log.info(String.format("Discard operation %s", operation));
        }
        if (Arrays.asList(operations).isEmpty()) {
            return;
        }
        Operation operation = Arrays.asList(operations).iterator().next().getOperation();
        HashSet<Path> files = new HashSet<Path>();
        for (SerializableOperation op : operations) {
            switch (op.getOperation()) {
                case rename: {
                    files.add(op.getArg());
                }
            }
            files.add(op.getRemote());
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Send file status change notification for %d files", files.size()));
        }
        block9: for (SyncQueue.Listener listener : this.listeners) {
            switch (operation) {
                case purge: {
                    listener.fileStatusChanged(files, operation, new FileStatusService.Status(FileStatusService.SyncState.remote));
                    continue block9;
                }
                case rename: 
                case list: 
                case delete: {
                    listener.fileStatusChanged(files, operation, new FileStatusService.Status(FileStatusService.SyncState.unknown));
                    continue block9;
                }
            }
            listener.fileStatusChanged(files, operation, new FileStatusService.Status(FileStatusService.SyncState.synced));
        }
    }

    public void operationFailed(SerializableOperation operation, BackgroundException failure) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Failed operation %s", operation));
        }
        switch (new SyncQueuePauseDiagnostics().determine(failure)) {
            case cancel: {
                log.warn(String.format("Pause sync queue after failure %s", new Object[]{failure}));
                this.pause(SyncQueue.Status.stopped, failure);
                for (SyncQueue.Listener listener : this.listeners) {
                    listener.fileStatusChanged(Collections.singleton(operation.getRemote()), operation.getOperation(), new FileStatusService.Status(FileStatusService.SyncState.unknown));
                }
                break;
            }
        }
        block3 : switch (new DefaultFailureDiagnostics().determine(failure)) {
            case network: 
            case quota: 
            case application: 
            case login: {
                HashSet<Path> files = new HashSet<Path>();
                switch (operation.getOperation()) {
                    case rename: {
                        files.add(operation.getArg());
                    }
                }
                files.add(operation.getRemote());
                if (operation.getLocal() == null) break;
                if (operation.getLocal().exists()) {
                    switch (operation.getOperation()) {
                        case rename: 
                        case delete: {
                            if (FileStatusService.SyncState.unknown == new DeleteInProgressStatusService(this.cache, this.metadata).getStatus(operation.getLocal()).getState()) {
                                for (SyncQueue.Listener listener : this.listeners) {
                                    listener.fileStatusChanged(Collections.singleton(operation.getRemote()), operation.getOperation(), new FileStatusService.Status(FileStatusService.SyncState.unknown));
                                }
                                break block3;
                            }
                        }
                        default: {
                            if (this.preferences.getBoolean("fs.sync.notification.error")) {
                                this.alert.alert(this.bookmark, failure, new StringBuilder());
                            }
                            this.history.add(new FileHistory.Item(operation.getRemote(), this.cache.toMount(operation.getRemote()), FileHistory.Item.Origin.local, operation.getOperation(), Long.valueOf(System.currentTimeMillis()), operation.getApplication(), failure));
                            NSDictionary nSDictionary = new DefaultExceptionSerializer().serialize(operation, failure);
                            this.metadata.write(operation.getLocal(), MetadataStorage.Key.error, nSDictionary);
                            for (SyncQueue.Listener listener : this.listeners) {
                                listener.fileStatusChanged(files, operation.getOperation(), new FileStatusService.Status(FileStatusService.SyncState.error, new SerializableOperationException(operation, failure)));
                            }
                            break block3;
                        }
                    }
                }
                this.metadata.delete(operation.getLocal(), MetadataStorage.Key.error);
                if (null != operation.getLocalArg()) {
                    this.metadata.delete(operation.getLocalArg(), MetadataStorage.Key.error);
                }
                for (SyncQueue.Listener listener : this.listeners) {
                    listener.fileStatusChanged(files, operation.getOperation(), new FileStatusService.Status(FileStatusService.SyncState.unknown));
                }
                break;
            }
        }
    }

    public void operationCoalesced(SerializableOperation operation) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Coalesced operation %s", operation));
        }
        this.operationAcquired(operation);
        this.pending.decrementAndGet();
        this.notifier.awake();
    }

    public void operationSkipped(SerializableOperation operation) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Skipped operation %s", operation));
        }
        for (SyncQueue.Listener listener : this.listeners) {
            listener.fileStatusChanged(Collections.singleton(operation.getRemote()), operation.getOperation(), new FileStatusService.Status(FileStatusService.SyncState.unknown));
        }
    }

    public void operationCompleted(SerializableOperation operation) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Completed operation %s", operation));
        }
        this.pending.decrementAndGet();
        this.notifier.awake();
    }

    public TapeSyncQueue open() throws BackgroundException {
        switch (this.status) {
            case none: {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Open queue in %s", this.directory));
                }
                try {
                    new DefaultLocalDirectoryFeature().mkdir(this.directory);
                    this.bufferQueue = new SerializableOperationQueue(LocalFactory.get((Local)this.directory, (String)"buffer.tape"), new TapeBinaryPropertyListConverter((CacheEncryptor)this.cache), (QueueAbortCallback)this);
                    this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("tape"));
                    for (int i = 0; i < this.numWorkers; ++i) {
                        Local file = LocalFactory.get((Local)this.directory, (String)String.format("sync-%d.tape", i));
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Create worker thread for tape %s", file));
                        }
                        SerializableOperationQueue workerQueue = new SerializableOperationQueue(file, new TapeBinaryPropertyListConverter((CacheEncryptor)this.cache), (QueueAbortCallback)this);
                        this.workerQueues.add(workerQueue);
                    }
                    if (this.preferences.getBoolean("fs.sync.queue.paused")) {
                        this.status = SyncQueue.Status.paused;
                        break;
                    }
                    this.status = SyncQueue.Status.stopped;
                    this.resume().get();
                    break;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new BackgroundException((Throwable)e);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Boolean> pause(final SyncQueue.Status cause, final BackgroundException failure) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Await lock %s to pause queue", this.sync));
        }
        this.sync.lock();
        try {
            switch (this.status) {
                case idle: {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Stop queue %s after failure %s", new Object[]{this, failure}));
                    }
                    this.status = SyncQueue.Status.pausing;
                    this.proxy.pause(cause, failure);
                    for (SyncQueue.Listener listener : this.listeners) {
                        listener.queueStatusChanged(this.status, failure);
                    }
                    Future<Boolean> future = this.executor.submit(new Callable<Boolean>(){

                        @Override
                        public Boolean call() {
                            TapeSyncQueue.this.bufferQueue.notifier().awake();
                            if (log.isDebugEnabled()) {
                                log.debug("Shutdown buffer readers gracefully");
                            }
                            TapeSyncQueue.this.bufferReaderPool.shutdown(true);
                            TapeSyncQueue.this.status = cause;
                            for (SyncQueue.Listener listener : TapeSyncQueue.this.listeners) {
                                listener.queueStatusChanged(TapeSyncQueue.this.status, failure);
                            }
                            return true;
                        }
                    });
                    return future;
                }
            }
            Future future = ConcurrentUtils.constantFuture((Object)false);
            return future;
        }
        finally {
            this.sync.unlock();
        }
    }

    public Future<Boolean> resume() {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Await lock %s to resume queue", this.sync));
        }
        this.sync.lock();
        try {
            switch (this.status) {
                case paused: 
                case stopped: {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Resume queue %s", this));
                    }
                    this.status = SyncQueue.Status.idle;
                    this.proxy.resume();
                    Future<Boolean> future = this.executor.submit(new Callable<Boolean>(){

                        @Override
                        public Boolean call() {
                            TapeSyncQueue.this.bufferReaderPool = ThreadPoolFactory.get((String)TapeSyncQueue.this.bufferQueue.name(), (int)TapeSyncQueue.this.numWorkers, (ThreadPool.Priority)ThreadPool.Priority.valueOf((String)TapeSyncQueue.this.preferences.getProperty("fs.sync.queue.thread.priority")), new LinkedBlockingQueue(), (Thread.UncaughtExceptionHandler)new LoggingUncaughtExceptionHandler());
                            for (SerializableOperationQueue workerQueue : TapeSyncQueue.this.workerQueues) {
                                TapeSyncQueue.this.bufferReaderPool.execute((Callable)new TapeSyncQueueBufferReader(TapeSyncQueue.this.bookmark, TapeSyncQueue.this.proxy, TapeSyncQueue.this.metadata, new TapeSyncQueueReferenceUpdater(TapeSyncQueue.this.cache, TapeSyncQueue.this.bufferQueue, workerQueue), new TapeSyncQueueAttributesUpdater(TapeSyncQueue.this.cache, TapeSyncQueue.this.metadata), TapeSyncQueue.this.bufferQueue, workerQueue, TapeSyncQueue.this, TapeSyncQueue.this, TapeSyncQueue.this, TapeSyncQueue.this, TapeSyncQueue.this, TapeSyncQueue.this, TapeSyncQueue.this));
                            }
                            SyncQueue.Status progress = TapeSyncQueue.this.getStatus();
                            for (SyncQueue.Listener listener : TapeSyncQueue.this.listeners) {
                                listener.queueStatusChanged(progress);
                            }
                            return true;
                        }
                    });
                    return future;
                }
            }
            Future future = ConcurrentUtils.constantFuture((Object)false);
            return future;
        }
        finally {
            this.sync.unlock();
        }
    }

    public int size() {
        int size = 0;
        for (ConcurrentObjectQueue concurrentObjectQueue : this.queues()) {
            size += concurrentObjectQueue.size();
        }
        return size;
    }

    public SyncQueue.Stats stats() {
        SyncQueue.Stats stats = new SyncQueue.Stats(0, 0L);
        for (ConcurrentObjectQueue concurrentObjectQueue : this.queues()) {
            for (SerializableOperation operation : concurrentObjectQueue.asList().stream().filter(new StatisticsOperationFilterPredicate().negate()).distinct().collect(Collectors.toList())) {
                ++stats.files;
                stats.bytes += this.cache.toCleartextSize(operation.getLength());
            }
        }
        return stats;
    }

    public SyncQueue withListener(SyncQueue.Listener listener) {
        this.listeners.add(listener);
        this.proxy.withListener(listener);
        return this;
    }

    public void purge(Local local, Path target) {
        this.submit(new SerializableOperation(Operation.purge, local, target));
    }

    public void read(Local target, Path source) {
        this.submit(new SerializableOperation(Operation.read, target, source).withLength(source.attributes().getSize()));
    }

    public void read(List<TransferItem> items, QueueDiscardCallback listener, QueueErrorCallback error) {
        for (TransferItem item : items) {
            this.read(item.local, item.remote);
        }
    }

    public void write(Local local, Path target, Application application) {
        this.metadata.write(local, MetadataStorage.Key.write, new NSDictionary());
        this.submit(new SerializableOperation(Operation.write, local, target).withLength(local.attributes().getSize()).withApplication(application));
    }

    public void write(List<TransferItem> items, QueueCoalescedCallback coalesce, QueueDiscardCallback listener, QueueErrorCallback error, Application application) throws BackgroundException {
        throw new UnsupportedException();
    }

    public void rename(Local lsource, Local ltarget, Path source, Path target) {
        this.submit(new SerializableOperation(Operation.rename, lsource, ltarget, source, target));
    }

    public void delete(Local local, Path target) {
        this.submit(new SerializableOperation(Operation.delete, local, target));
    }

    public void delete(List<TransferItem> items, QueueDiscardCallback listener) throws BackgroundException {
        throw new UnsupportedException();
    }

    public void mkdir(Local local, Path directory) {
        this.submit(new SerializableOperation(Operation.mkdir, local, directory));
    }

    public void timestamp(Local local, Path target, Long timestamp) {
        PathAttributes attr = new PathAttributes();
        attr.setModificationDate(timestamp.longValue());
        this.submit(new SerializableOperation(Operation.timestamp, local, target, attr));
    }

    public void chmod(Local local, Path target, Permission permission) {
        PathAttributes attr = new PathAttributes();
        attr.setPermission(permission);
        this.submit(new SerializableOperation(Operation.chmod, local, target, attr));
    }

    public void symlink(Local lsource, Local ltarget, Path source, Path target) {
        this.submit(new SerializableOperation(Operation.symlink, lsource, ltarget, source, target));
    }

    public void lock(Local local, Path target) {
        this.submit(new SerializableOperation(Operation.lock, local, target));
    }

    public void unlock(Local local, Path target, String lockId) {
        this.submit(new SerializableOperation(Operation.unlock, local, target, new PathAttributes().withLockId(lockId)));
    }

    public List<SerializableOperation> find(int n) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ConcurrentObjectQueue concurrentObjectQueue : this.queues()) {
            try {
                list.addAll(0, concurrentObjectQueue.peek(n));
            }
            catch (IOException e) {
                log.error(String.format("Error %s getting %s as list", e, concurrentObjectQueue));
            }
        }
        list.removeIf(new StatisticsOperationFilterPredicate());
        return list.stream().distinct().collect(Collectors.toList());
    }

    public boolean contains(Path file) {
        List<SerializableOperationQueue> queues = this.queues();
        for (SerializableOperationQueue queue : queues) {
            if (!queue.contains(file)) continue;
            return true;
        }
        return false;
    }

    public Set<SerializableOperation> get(Local local) {
        List<SerializableOperationQueue> queues = this.queues();
        for (SerializableOperationQueue queue : queues) {
            Set<SerializableOperation> operations = queue.get(local);
            if (operations.isEmpty()) continue;
            return operations;
        }
        return Collections.emptySet();
    }

    private List<SerializableOperationQueue> queues() {
        ArrayList<SerializableOperationQueue> queues = new ArrayList<SerializableOperationQueue>();
        if (null != this.bufferQueue) {
            queues.addAll(Collections.singletonList(this.bufferQueue));
        }
        queues.addAll(this.workerQueues);
        return queues;
    }

    public SyncQueue.Status getStatus() {
        switch (this.status) {
            case idle: {
                if (this.size() > 0) {
                    return SyncQueue.Status.busy;
                }
                if (this.queueing.size() <= 0) break;
                return SyncQueue.Status.busy;
            }
        }
        return this.status;
    }

    public SyncQueue.Status getStatus(Path file) {
        switch (this.status) {
            case paused: 
            case stopped: 
            case idle: {
                if (this.contains(file)) {
                    return SyncQueue.Status.busy;
                }
                if (!this.queueing.contains(file)) break;
                return SyncQueue.Status.busy;
            }
        }
        return this.status;
    }

    public boolean submit(SerializableOperation operation) {
        switch (this.status) {
            case none: {
                log.warn(String.format("Cannot submit operation %s to closed queue", operation));
                return false;
            }
        }
        try {
            if (log.isInfoEnabled()) {
                log.info(String.format("Submit operation %s to buffering queue", operation));
            }
            this.bufferQueue.add(operation);
            return true;
        }
        catch (IOException e) {
            log.error(String.format("Failure %s submitting operation %s to buffering queue", e, operation));
            return false;
        }
    }

    public void beginQueueing(Path remote, Local file) {
        this.queueing.add(remote);
        for (SyncQueue.Listener listener : this.listeners) {
            listener.fileStatusChanged(Collections.singleton(remote), Operation.list, new FileStatusService.Status(FileStatusService.SyncState.inprogress));
        }
    }

    public void endQueueing(Path remote, Local file) {
        this.queueing.remove(remote);
        for (SyncQueue.Listener listener : this.listeners) {
            listener.fileStatusChanged(Collections.singleton(remote), Operation.list, new FileStatusService.Status(FileStatusService.SyncState.unknown));
        }
    }

    public void flush() throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Flush queue %s", this));
        }
        try {
            List<SerializableOperationQueue> queues = this.queues();
            for (final ConcurrentObjectQueue concurrentObjectQueue : queues) {
                do {
                    switch (this.status) {
                        case idle: {
                            if (log.isTraceEnabled()) {
                                log.trace(String.format("Polling queue %s", concurrentObjectQueue));
                            }
                            concurrentObjectQueue.poll(new LockingQueueNotifier(new QueueAbortCallback(){

                                public boolean isStopped() {
                                    return concurrentObjectQueue.isEmpty();
                                }
                            }));
                            break;
                        }
                        default: {
                            log.warn(String.format("Skip flushing queue %s in status %s", concurrentObjectQueue, this.status));
                            return;
                        }
                    }
                } while (!concurrentObjectQueue.isEmpty());
                if (log.isInfoEnabled()) {
                    log.info(String.format("Flushed queue %s", concurrentObjectQueue));
                }
                log.warn(String.format("Await operation counter (%d) to reach zero", this.pending.get()));
                this.notifier.await();
                log.info("All operations completed after flush");
            }
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public void close() throws BackgroundException {
        switch (this.status) {
            case none: {
                return;
            }
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Shutdown queue %s", this));
        }
        try {
            this.pause(SyncQueue.Status.stopped).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BackgroundException((Throwable)e);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Closing buffer queue gracefully");
            }
            this.bufferQueue.close();
            if (log.isDebugEnabled()) {
                log.debug("Clear worker queues");
            }
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        finally {
            this.status = SyncQueue.Status.none;
        }
        Iterator<SerializableOperationQueue> iter = this.workerQueues.iterator();
        while (iter.hasNext()) {
            ConcurrentObjectQueue workerQueue = iter.next();
            try {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Close sync queue %s", workerQueue));
                }
                workerQueue.close();
            }
            catch (IOException e) {
                log.error(String.format("Failure %s closing worker queue", e));
                throw new DefaultIOExceptionMappingService().map(e);
            }
            iter.remove();
        }
        this.executor.shutdown();
        this.listeners.clear();
        this.workerQueues.clear();
        this.queueing.clear();
        this.proxy.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TapeSyncQueue{");
        sb.append("proxy=").append(this.proxy);
        sb.append(", bookmark=").append(this.bookmark);
        sb.append(", directory=").append(this.directory);
        sb.append(", status=").append(this.status);
        sb.append('}');
        return sb.toString();
    }

    private static final class StatisticsOperationFilterPredicate
    implements Predicate<SerializableOperation> {
        private StatisticsOperationFilterPredicate() {
        }

        @Override
        public boolean test(SerializableOperation operation) {
            return !EnumSet.of(Operation.read, Operation.write, Operation.rename, Operation.delete, Operation.mkdir).contains(operation.getOperation());
        }
    }
}

