/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue.tape;

import ch.iterate.mountainduck.sync.cache.CacheEncryptor;
import ch.iterate.mountainduck.sync.metadata.DefaultOperationSerializer;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.squareup.tape2.ObjectQueue;
import java.io.IOException;
import java.io.OutputStream;

public class TapeBinaryPropertyListConverter
implements ObjectQueue.Converter<SerializableOperation> {
    private final CacheEncryptor cache;

    public TapeBinaryPropertyListConverter(CacheEncryptor cache) {
        this.cache = cache;
    }

    public SerializableOperation from(byte[] bytes) throws IOException {
        try {
            NSDictionary dict = (NSDictionary)BinaryPropertyListParser.parse((byte[])bytes);
            return new DefaultOperationSerializer().deserialize(dict);
        }
        catch (PropertyListFormatException | IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public void toStream(SerializableOperation operation, OutputStream bytes) throws IOException {
        NSDictionary dict = new DefaultOperationSerializer().serialize(operation);
        BinaryPropertyListWriter.write((OutputStream)bytes, (NSObject)dict);
    }
}

