/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue.tape;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.BackgroundException;
import ch.iterate.mountainduck.sync.queue.LockingQueueNotifier;
import ch.iterate.mountainduck.sync.queue.QueueAbortCallback;
import com.squareup.tape2.ObjectQueue;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConcurrentObjectQueue<Type> {
    private static final Logger log = LogManager.getLogger((String)ConcurrentObjectQueue.class.getName());
    private final String name;
    protected final ObjectQueue<Type> proxy;
    protected final ObjectQueue<Type> memory;
    protected final Lock lock;
    private final LockingQueueNotifier notifier;

    /*
     * Exception decompiling
     */
    public ConcurrentObjectQueue(Local file, ObjectQueue.Converter<Type> serializer, QueueAbortCallback shutdown) throws BackgroundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public LockingQueueNotifier notifier() {
        return this.notifier;
    }

    public void add(Type operation) throws IOException {
        this.lock.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Add %s to %s", operation, this.proxy));
            }
            this.proxy.add(operation);
            this.memory.add(operation);
            this.notifier.awake();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Type poll() throws IOException {
        return this.poll(this.notifier);
    }

    public Type poll(LockingQueueNotifier notifier) throws IOException {
        Type operation = this.peek();
        if (null == operation) {
            if (!notifier.await()) {
                return null;
            }
            return this.poll(notifier);
        }
        return operation;
    }

    public Type peek() throws IOException {
        this.lock.lock();
        try {
            if (log.isTraceEnabled()) {
                log.trace(String.format("Peek head from %s", this.proxy));
            }
            Object object = this.memory.peek();
            return (Type)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<Type> peek(int max) throws IOException {
        this.lock.lock();
        try {
            if (log.isTraceEnabled()) {
                log.trace(String.format("Peek head from %s", this.proxy));
            }
            List list = this.memory.peek(max);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove() throws IOException {
        this.lock.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Remove head from %s", this.proxy));
            }
            this.proxy.remove();
            this.memory.remove();
            this.notifier.awake();
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<Type> asList() {
        this.lock.lock();
        try {
            List list = this.memory.asList();
            return list;
        }
        catch (IOException e) {
            log.warn("Unexpected I/O polling in memory queue");
            List list = Collections.emptyList();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() throws IOException {
        this.lock.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Close %s", this.proxy));
            }
            this.proxy.close();
            this.memory.close();
            this.notifier.awake();
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.memory.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Clear queue %s", this.proxy));
            }
            this.memory.clear();
            this.proxy.clear();
        }
        catch (IOException e) {
            log.error(String.format("Error %s clearing %s", e, this.proxy));
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = 0 == this.memory.size();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConcurrentObjectQueue{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

