/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.queue;

import ch.iterate.mountainduck.sync.queue.QueueAbortCallback;
import ch.iterate.mountainduck.sync.queue.QueueNotifier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LockingQueueNotifier
implements QueueNotifier {
    private static final Logger log = LogManager.getLogger((String)LockingQueueNotifier.class.getName());
    private final QueueAbortCallback stopped;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition lockCondition = this.lock.newCondition();

    public LockingQueueNotifier(QueueAbortCallback stopped) {
        this.stopped = stopped;
    }

    @Override
    public boolean await() {
        if (this.stopped.isStopped()) {
            log.warn("Skip waiting for new entry in queue");
            return false;
        }
        this.lock.lock();
        try {
            do {
                if (log.isTraceEnabled()) {
                    log.trace("Waiting for new entry in queue");
                }
                if (!this.lockCondition.await(1L, TimeUnit.SECONDS)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Proceed");
                }
                boolean bl = true;
                return bl;
            } while (!this.stopped.isStopped());
            if (log.isDebugEnabled()) {
                log.debug("Abort");
            }
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            log.error("Interrupted wait");
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void awake() {
        this.lock.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug("Signal all locks");
            }
            this.lockCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

