/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.history;

import ch.cyberduck.core.SerializerFactory;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.serializer.LocalDictionary;
import ch.cyberduck.core.serializer.PathDictionary;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.metadata.DefaultExceptionSerializer;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.squareup.tape2.ObjectQueue;
import java.io.IOException;
import java.io.OutputStream;

final class TapeFileHistoryItemConverter
implements ObjectQueue.Converter<FileHistory.Item> {
    TapeFileHistoryItemConverter() {
    }

    public FileHistory.Item from(byte[] bytes) throws IOException {
        try {
            NSDictionary dict = (NSDictionary)BinaryPropertyListParser.parse((byte[])bytes);
            FileHistory.Item item = new FileHistory.Item(new PathDictionary().deserialize((Object)dict.objectForKey("Remote")), new LocalDictionary().deserialize((Object)dict.objectForKey("Local")), FileHistory.Item.Origin.valueOf((String)dict.objectForKey("Origin").toString()), Operation.valueOf((String)dict.objectForKey("Operation").toString()), Long.valueOf(Long.parseLong(dict.objectForKey("Timestamp").toString())));
            if (dict.containsKey("Failure")) {
                item.failure = new DefaultExceptionSerializer().deserialize((NSDictionary)dict.objectForKey("Failure"));
            }
            if (dict.containsKey("Application")) {
                item.application = new Application(dict.objectForKey("Application").toString());
            }
            return item;
        }
        catch (PropertyListFormatException | IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public void toStream(FileHistory.Item o, OutputStream bytes) throws IOException {
        NSDictionary dict = new NSDictionary();
        dict.put("Local", (NSObject)o.local.serialize(SerializerFactory.get()));
        dict.put("Remote", (NSObject)o.remote.serialize(SerializerFactory.get()));
        dict.put("Origin", (Object)o.origin.name());
        dict.put("Operation", (Object)o.operation.name());
        dict.put("Timestamp", (Object)String.valueOf(o.timestamp));
        if (o.application != null) {
            dict.put("Application", (Object)o.application.getIdentifier());
        }
        if (o.failure != null) {
            dict.put("Failure", (NSObject)new DefaultExceptionSerializer().serialize(new SerializableOperation(o.operation, o.local, o.remote), o.failure));
        }
        BinaryPropertyListWriter.write((OutputStream)bytes, (NSObject)dict);
    }
}

