/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.history;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.local.DefaultLocalDirectoryFeature;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.FilesystemFilenameBlacklist;
import ch.iterate.mountainduck.fs.FilesystemFilenameBlacklistChain;
import ch.iterate.mountainduck.sync.history.FileHistory;
import ch.iterate.mountainduck.sync.history.TapeFileHistoryItemConverter;
import ch.iterate.mountainduck.sync.queue.QueueAbortCallback;
import ch.iterate.mountainduck.sync.queue.tape.ConcurrentObjectQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TapeFileHistory
implements FileHistory,
QueueAbortCallback {
    private static final Logger log = LogManager.getLogger((String)TapeFileHistory.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final FilesystemFilenameBlacklist ignored = new FilesystemFilenameBlacklistChain(new FilesystemFilenameBlacklist[]{FilesystemFilenameBlacklist.temporary, FilesystemFilenameBlacklist.lockowner});
    private final Local directory;
    private final Lock lock = new ReentrantLock(true);
    private ConcurrentObjectQueue<FileHistory.Item> queue;

    public TapeFileHistory(Local directory) {
        this.directory = directory;
    }

    public void open() throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Open history in %s", this.directory));
        }
        new DefaultLocalDirectoryFeature().mkdir(this.directory);
        this.queue = new ConcurrentObjectQueue<FileHistory.Item>(LocalFactory.get((Local)this.directory, (String)"history.tape"), new TapeFileHistoryItemConverter(), this);
    }

    public void close() throws BackgroundException {
        this.lock.lock();
        try {
            if (null == this.queue) {
                return;
            }
            this.queue.close();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void add(FileHistory.Item item) {
        this.lock.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Add item %s", item));
            }
            this.queue.add(item);
            while (this.queue.size() > this.preferences.getInteger("fs.sync.history.peek.size")) {
                this.queue.remove();
            }
        }
        catch (IOException e) {
            log.error(String.format("Error %s adding %s to file history queue %s", e, item, this.queue));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileHistory.Item> find(int n) {
        this.lock.lock();
        try {
            if (null == this.queue) {
                List<FileHistory.Item> list = Collections.emptyList();
                return list;
            }
            ArrayList<FileHistory.Item> list = new ArrayList<FileHistory.Item>(this.queue.asList());
            List<FileHistory.Item> peek = list.subList(Integer.max(0, list.size() - n), list.size());
            Collections.reverse(peek);
            peek.removeIf(item -> this.ignored.contains(item.remote));
            List<FileHistory.Item> list2 = peek.stream().distinct().collect(Collectors.toList());
            return list2;
        }
        catch (IllegalStateException e) {
            List<FileHistory.Item> list = Collections.emptyList();
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void trim(int size) {
        this.lock.lock();
        try {
            if (null == this.queue) {
                return;
            }
            while (this.queue.size() > size) {
                this.queue.remove();
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException e) {
            log.error(String.format("Error %s trimming %s", e, this.queue));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            if (null == this.queue) {
                return;
            }
            this.queue.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static void main(String[] args) throws Exception {
        TapeFileHistory history = new TapeFileHistory(LocalFactory.get((String)args[0]));
        history.open();
        for (FileHistory.Item item : history.queue.asList()) {
            System.out.println(item.toString());
        }
        history.close();
    }

    public boolean isStopped() {
        return false;
    }
}

