/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.elections;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.config.IntConfigParam;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.QuorumPolicy;
import com.sleepycat.je.rep.elections.Acceptor;
import com.sleepycat.je.rep.elections.ElectionsConfig;
import com.sleepycat.je.rep.elections.Learner;
import com.sleepycat.je.rep.elections.MasterValue;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.elections.RankingProposer;
import com.sleepycat.je.rep.elections.TimebasedProposalGenerator;
import com.sleepycat.je.rep.elections.Utils;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.ElectionQuorum;
import com.sleepycat.je.rep.impl.node.FeederManager;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.net.DataChannelFactory;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StoppableThread;
import com.sleepycat.je.utilint.StoppableThreadFactory;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Elections {
    private RepGroupImpl repGroup;
    private final NameIdPair nameIdPair;
    private final RepNode repNode;
    private final ElectionsConfig config;
    private final RepImpl envImpl;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private Proposer proposer;
    private Acceptor acceptor;
    private Learner learner;
    private final ExecutorService pool;
    private final Acceptor.SuggestionGenerator suggestionGenerator;
    private final Learner.Listener listener;
    private final Protocol protocol;
    private volatile ElectionThread electionThread = null;
    private ElectionListener electionListener = null;
    private final RebroadcastTask rebroadcastTask;
    private int nElections = 0;
    private final Logger logger;
    private final Formatter formatter;

    public Elections(ElectionsConfig config, Learner.Listener listener, Acceptor.SuggestionGenerator suggestionGenerator) {
        this.envImpl = config.getRepImpl();
        this.repNode = config.getRepNode();
        this.config = config;
        this.nameIdPair = config.getNameIdPair();
        if (this.repNode != null && this.repNode.getRepImpl() != null) {
            this.logger = LoggerUtils.getLogger(this.getClass());
            DbConfigManager configManager = this.envImpl.getConfigManager();
            int rebroadcastPeriod = configManager.getDuration(RepParams.ELECTIONS_REBROADCAST_PERIOD);
            this.rebroadcastTask = new RebroadcastTask(rebroadcastPeriod);
        } else {
            this.logger = LoggerUtils.getLoggerFormatterNeeded(this.getClass());
            this.rebroadcastTask = null;
        }
        DataChannelFactory channelFactory = config.getServiceDispatcher().getChannelFactory();
        this.formatter = new ReplicationFormatter(this.nameIdPair);
        this.protocol = new Protocol(TimebasedProposalGenerator.getParser(), MasterValue.getParser(), config.getGroupName(), this.nameIdPair, config.getRepImpl(), channelFactory);
        this.suggestionGenerator = suggestionGenerator;
        this.listener = listener;
        this.pool = Executors.newCachedThreadPool(new StoppableThreadFactory("JE Elections Factory " + this.nameIdPair, this.logger));
    }

    public ExecutorService getThreadPool() {
        return this.pool;
    }

    public ServiceDispatcher getServiceDispatcher() {
        return this.config.getServiceDispatcher();
    }

    public ElectionQuorum getElectionQuorum() {
        return this.repNode.getElectionQuorum();
    }

    public RepNode getRepNode() {
        return this.repNode;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public RepImpl getRepImpl() {
        return this.config.getRepImpl();
    }

    public void startLearner() {
        this.learner = new Learner(this.config.getRepImpl(), this.protocol, this.config.getServiceDispatcher());
        this.learner.start();
        this.learner.addListener(this.listener);
        this.electionListener = new ElectionListener();
        this.learner.addListener(this.electionListener);
        if (this.rebroadcastTask != null) {
            this.repNode.getTimer().schedule((TimerTask)this.rebroadcastTask, this.rebroadcastTask.getPeriod(), (long)this.rebroadcastTask.getPeriod());
        }
    }

    public void participate() {
        this.proposer = new RankingProposer(this, this.nameIdPair);
        this.startAcceptor();
    }

    public void startAcceptor() {
        this.acceptor = new Acceptor(this.protocol, this.config, this.suggestionGenerator);
        this.acceptor.start();
    }

    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    public Set<InetSocketAddress> getAcceptorSockets() {
        if (this.repGroup == null) {
            throw EnvironmentFailureException.unexpectedState("No rep group was configured");
        }
        return this.repGroup.getAllAcceptorSockets();
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Learner getLearner() {
        return this.learner;
    }

    public int getElectionCount() {
        return this.nElections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initiateElection(RepGroupImpl newGroup, QuorumPolicy quorumPolicy, int maxRetries) throws InterruptedException {
        Object exception;
        this.updateRepGroup(newGroup);
        long startTime = System.currentTimeMillis();
        ++this.nElections;
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Election initiated; election #" + this.nElections);
        if (this.electionThread != null) {
            int waitMs = this.protocol.getReadTimeout() * 4;
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Election in progress. Waiting ... for " + waitMs + "ms");
            this.electionThread.join(waitMs);
            if (this.electionThread.isAlive()) {
                LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Election did not finish as expected. resorting to shutdown");
                LoggerUtils.fullThreadDump(this.logger, this.envImpl, Level.INFO);
                this.electionThread.shutdown();
            }
            if ((exception = this.electionThread.getSavedShutdownException()) != null) {
                throw new EnvironmentFailureException((EnvironmentImpl)this.envImpl, EnvironmentFailureReason.UNEXPECTED_EXCEPTION, (Throwable)exception);
            }
        }
        CountDownLatch countDownLatch = null;
        exception = this.electionListener;
        synchronized (exception) {
            countDownLatch = this.electionListener.setLatch();
        }
        RetryPredicate retryPredicate = new RetryPredicate(this.repNode, maxRetries, countDownLatch);
        this.electionThread = new ElectionThread(quorumPolicy, retryPredicate, this.envImpl, this.envImpl == null ? null : this.envImpl.getName());
        this.electionThread.start();
        try {
            countDownLatch.await();
            if (retryPredicate.pendingRetries <= 0) {
                LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Retry count exhausted: " + retryPredicate.maxRetries);
            }
        }
        catch (InterruptedException e) {
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "Election initiation interrupted");
            this.shutdown();
            throw e;
        }
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Election finished. Elapsed time: " + (System.currentTimeMillis() - startTime) + "ms");
    }

    public synchronized void initiateElection(RepGroupImpl newGroup, QuorumPolicy quorumPolicy) throws InterruptedException {
        this.initiateElection(newGroup, quorumPolicy, Integer.MAX_VALUE);
    }

    public void updateRepGroup(RepGroupImpl newRepGroup) {
        this.repGroup = newRepGroup;
        this.protocol.updateNodeIds(newRepGroup.getAllElectionMemberIds());
    }

    public void updateRepGroupOnly(RepGroupImpl newRepGroup) {
        this.repGroup = newRepGroup;
    }

    public synchronized boolean electionInProgress() {
        return this.electionThread != null && this.electionThread.isAlive();
    }

    public synchronized StatGroup getStats() {
        if (this.electionInProgress()) {
            throw EnvironmentFailureException.unexpectedState("Election in progress");
        }
        return this.electionThread.getStats();
    }

    public synchronized void waitForElection() throws InterruptedException {
        assert (this.electionThread != null);
        this.electionThread.join();
    }

    public void shutdownAcceptorsLearners(Set<InetSocketAddress> acceptorSockets, Set<InetSocketAddress> learnerSockets) throws InterruptedException {
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Elections being shutdown");
        Utils.FutureTrackingCompService<TextProtocol.MessageExchange> compService = Utils.broadcastMessage(acceptorSockets, "Acceptor", new Protocol.Shutdown(this.protocol), this.pool);
        Utils.checkFutures(compService, 60L, TimeUnit.SECONDS, this.logger, this.envImpl, this.formatter);
        compService = Utils.broadcastMessage(learnerSockets, "Learner", new Protocol.Shutdown(this.protocol), this.pool);
        Utils.checkFutures(compService, 60L, TimeUnit.SECONDS, this.logger, this.envImpl, this.formatter);
        if (this.learner != null) {
            this.learner.join();
        }
        if (this.acceptor != null) {
            this.acceptor.join();
        }
    }

    public void shutdown() throws InterruptedException {
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Elections shutdown initiated");
        if (this.acceptor != null) {
            this.acceptor.shutdown();
        }
        if (this.learner != null) {
            this.learner.shutdown();
        }
        if (this.electionThread != null) {
            this.electionThread.shutdown();
        }
        if (this.proposer != null) {
            this.proposer.shutdown();
        }
        if (this.rebroadcastTask != null) {
            this.rebroadcastTask.cancel();
        }
        this.pool.shutdown();
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Elections shutdown completed");
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    public void asyncInformMonitors(Proposer.Proposal proposal, Protocol.Value value) {
        Set<InetSocketAddress> monitorSockets = this.repGroup.getAllMonitorSockets();
        if (monitorSockets.size() == 0) {
            return;
        }
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, String.format("Propagating election results to %d monitors\n", monitorSockets.size()));
        this.pool.execute(new InformLearners(monitorSockets, new Proposer.WinningProposal(proposal, value, null)));
    }

    static /* synthetic */ Proposer access$500(Elections x0) {
        return x0.proposer;
    }

    private class RebroadcastTask
    extends TimerTask {
        private final ReentrantLock lock = new ReentrantLock();
        private int acquireFailCount = 0;
        private final int periodMs;

        public RebroadcastTask(int periodMs) {
            this.periodMs = periodMs;
        }

        public int getPeriod() {
            return this.periodMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (!this.lock.tryLock()) {
                    if (++this.acquireFailCount % 100 == 0) {
                        LoggerUtils.logMsg(Elections.this.logger, Elections.this.envImpl, Elections.this.formatter, Level.WARNING, "Failed to acquire lock after " + this.acquireFailCount + " retries");
                    }
                    return;
                }
                this.acquireFailCount = 0;
                if (!Elections.this.repNode.getMasterStatus().isGroupMaster()) {
                    return;
                }
                FeederManager feederManager = Elections.this.repNode.feederManager();
                Set<String> active = feederManager.activeReplicas();
                active.add(Elections.this.repNode.getNodeName());
                final HashSet<InetSocketAddress> learners = new HashSet<InetSocketAddress>();
                for (RepNodeImpl rn : Elections.this.repGroup.getAllLearnerMembers()) {
                    if (active.contains(rn.getName())) continue;
                    learners.add(rn.getSocketAddress());
                }
                if (learners.size() == 0) {
                    return;
                }
                LoggerUtils.logMsg(Elections.this.logger, Elections.this.envImpl, Elections.this.formatter, Level.FINE, "informing learners:" + Arrays.toString(learners.toArray()) + " active: " + Arrays.toString(active.toArray()));
                Elections.this.pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        Elections.this.learner.reinformLearners(learners, Elections.this.pool);
                    }
                });
            }
            catch (Exception e) {
                LoggerUtils.logMsg(Elections.this.logger, Elections.this.envImpl, Elections.this.formatter, Level.SEVERE, "Unexpected exception:" + e.getMessage());
            }
            finally {
                if (this.lock.isHeldByCurrentThread()) {
                    this.lock.unlock();
                }
            }
        }
    }

    private class InformLearners
    implements Runnable {
        final Set<InetSocketAddress> learners;
        final Proposer.WinningProposal winningProposal;

        InformLearners(Set<InetSocketAddress> learners, Proposer.WinningProposal winningProposal) {
            this.learners = learners;
            this.winningProposal = winningProposal;
        }

        @Override
        public void run() {
            Learner.informLearners(this.learners, this.winningProposal, Elections.this.protocol, Elections.this.pool, Elections.this.logger, Elections.this.config.getRepImpl(), null);
        }
    }

    private class ElectionThread
    extends StoppableThread {
        private final QuorumPolicy quorumPolicy;
        Proposer.WinningProposal winningProposal;
        Proposer.MaxRetriesException maxRetriesException;
        private final RetryPredicate retryPredicate;

        private ElectionThread(QuorumPolicy quorumPolicy, RetryPredicate retryPredicate, EnvironmentImpl envImpl, String envName) {
            super(envImpl, "ElectionThread_" + envName);
            this.quorumPolicy = quorumPolicy;
            this.retryPredicate = retryPredicate;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void shutdown() {
            if (this.shutdownDone()) {
                return;
            }
            this.shutdownThread(Elections.this.logger);
        }

        @Override
        protected int initiateSoftShutdown() {
            CountDownLatch electionLatch = Elections.this.electionListener.getElectionLatch();
            if (electionLatch != null) {
                electionLatch.countDown();
            }
            return Elections.this.protocol.getReadTimeout();
        }

        StatGroup getStats() {
            return this.winningProposal != null ? this.winningProposal.proposerStats : this.maxRetriesException.proposerStats;
        }

        @Override
        protected Logger getLogger() {
            return Elections.this.logger;
        }
    }

    static class RetryPredicate
    implements Proposer.RetryPredicate {
        private final RepNode repNode;
        private final int maxRetries;
        private int pendingRetries;
        private final CountDownLatch electionLatch;
        private final int primaryRetries;
        private static final int BACKOFF_SLEEP_MIN = 1;
        private static final int BACKOFF_SLEEP_MAX = 32;
        private int backoffSleepInterval = 1;

        RetryPredicate(RepNode repNode, int maxRetries, CountDownLatch electionLatch) {
            this.repNode = repNode;
            this.maxRetries = maxRetries;
            this.pendingRetries = maxRetries;
            this.electionLatch = electionLatch;
            RepImpl repImpl = repNode.getRepImpl();
            IntConfigParam retriesParam = RepParams.ELECTIONS_PRIMARY_RETRIES;
            this.primaryRetries = repImpl != null ? repImpl.getConfigManager().getInt(retriesParam) : Integer.parseInt(retriesParam.getDefault());
        }

        private int backoffWaitTime() {
            this.backoffSleepInterval = Math.min(32, this.backoffSleepInterval * 2);
            return this.backoffSleepInterval * 1000;
        }

        @Override
        public boolean retry() throws InterruptedException {
            if (this.maxRetries - this.pendingRetries >= this.primaryRetries && this.repNode != null && this.repNode.getArbiter().activateArbitration()) {
                this.pendingRetries = this.maxRetries;
                return true;
            }
            if (this.pendingRetries-- <= 0) {
                this.electionLatch.countDown();
                return false;
            }
            this.electionLatch.await(this.backoffWaitTime(), TimeUnit.MILLISECONDS);
            return this.electionLatch.getCount() != 0L;
        }

        @Override
        public int retries() {
            return this.maxRetries - this.pendingRetries;
        }
    }

    static class ElectionListener
    implements Learner.Listener {
        private CountDownLatch electionLatch = null;

        ElectionListener() {
        }

        public synchronized CountDownLatch setLatch() {
            this.electionLatch = new CountDownLatch(1);
            return this.electionLatch;
        }

        public CountDownLatch getElectionLatch() {
            return this.electionLatch;
        }

        @Override
        public synchronized void notify(Proposer.Proposal proposal, Protocol.Value value) {
            if (this.electionLatch != null) {
                this.electionLatch.countDown();
            }
        }
    }
}

