/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.urlhandler;

import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSBundle;
import ch.cyberduck.binding.foundation.NSEnumerator;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.library.Native;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinder;
import ch.cyberduck.core.local.ApplicationFinderFactory;
import ch.cyberduck.core.urlhandler.AbstractSchemeHandler;
import ch.cyberduck.core.urlhandler.LaunchServicesLibrary;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.ObjCObject;
import org.rococoa.ObjCObjectByReference;
import org.rococoa.Rococoa;

public final class LaunchServicesSchemeHandler
extends AbstractSchemeHandler {
    private static final Logger log = LogManager.getLogger(LaunchServicesSchemeHandler.class);
    private final ApplicationFinder applicationFinder;

    public LaunchServicesSchemeHandler() {
        this(ApplicationFinderFactory.get());
    }

    public LaunchServicesSchemeHandler(ApplicationFinder applicationFinder) {
        this.applicationFinder = applicationFinder;
    }

    public void setDefaultHandler(Application application, List<String> schemes) {
        for (String scheme : schemes) {
            if (0 == LaunchServicesLibrary.library.LSSetDefaultHandlerForURLScheme(scheme, application.getIdentifier())) continue;
            log.error(String.format("Failure setting default handler for scheme %s", scheme));
        }
    }

    public Application getDefaultHandler(String scheme) {
        ObjCObjectByReference error = new ObjCObjectByReference();
        NSURL url = LaunchServicesLibrary.library.LSCopyDefaultApplicationURLForURL(NSURL.URLWithString((String)String.format("%s:/", scheme)), -1, error);
        if (url != null) {
            NSBundle bundle = NSBundle.bundleWithPath((String)url.path());
            if (null == bundle) {
                log.warn(String.format("Failure loading bundle for path %s", url.path()));
                return Application.notfound;
            }
            Application application = this.applicationFinder.getDescription(bundle.bundleIdentifier());
            if (this.applicationFinder.isInstalled(application)) {
                return application;
            }
        }
        return Application.notfound;
    }

    public List<Application> getAllHandlers(String scheme) {
        NSObject next;
        ArrayList<Application> handlers = new ArrayList<Application>();
        NSArray applications = LaunchServicesLibrary.library.LSCopyApplicationURLsForURL(NSURL.URLWithString((String)String.format("%s:/", scheme)), -1);
        NSEnumerator ordered = applications.objectEnumerator();
        while ((next = ordered.nextObject()) != null) {
            NSURL url = (NSURL)Rococoa.cast((ObjCObject)next, NSURL.class);
            NSBundle bundle = NSBundle.bundleWithPath((String)url.path());
            if (null == bundle) {
                log.warn(String.format("Failure loading bundle for path %s", url.path()));
                continue;
            }
            Application application = this.applicationFinder.getDescription(bundle.bundleIdentifier());
            if (!this.applicationFinder.isInstalled(application)) continue;
            handlers.add(application);
        }
        return handlers;
    }

    static {
        Native.load((String)"core");
    }
}

