/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer.impl.jna;

import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSMutableArray;
import ch.cyberduck.binding.foundation.NSMutableDictionary;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.serializer.Serializer;
import java.util.Collection;
import java.util.Map;

public class PlistSerializer
implements Serializer<NSDictionary> {
    final NSMutableDictionary dict;

    public PlistSerializer() {
        this(NSMutableDictionary.dictionary());
    }

    public PlistSerializer(NSMutableDictionary dict) {
        this.dict = dict;
    }

    public void setStringForKey(String value, String key) {
        this.dict.setObjectForKey(value, key);
    }

    public void setObjectForKey(Serializable value, String key) {
        this.dict.setObjectForKey((NSObject)value.serialize((Serializer)new PlistSerializer()), key);
    }

    public <O extends Serializable> void setListForKey(Collection<O> value, String key) {
        NSMutableArray list = NSMutableArray.array();
        for (Serializable serializable : value) {
            list.addObject((NSObject)serializable.serialize((Serializer)new PlistSerializer()));
        }
        this.dict.setObjectForKey((NSObject)list, key);
    }

    public void setStringListForKey(Collection<String> value, String key) {
        NSMutableArray list = NSMutableArray.array();
        for (String serializable : value) {
            list.addObject(serializable);
        }
        this.dict.setObjectForKey((NSObject)list, key);
    }

    public void setMapForKey(Map<String, String> value, String key) {
        NSMutableDictionary dict = NSMutableDictionary.dictionary();
        for (Map.Entry<String, String> entry : value.entrySet()) {
            dict.setObjectForKey(entry.getValue(), entry.getKey());
        }
        dict.setObjectForKey((NSObject)dict, key);
    }

    public NSDictionary getSerialized() {
        return this.dict;
    }
}

