/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer.impl.jna;

import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.serializer.Reader;

public abstract class PlistReader<S extends Serializable>
implements Reader<S> {
    public S read(Local file) throws AccessDeniedException {
        if (!file.exists()) {
            throw new LocalAccessDeniedException(file.getAbsolute());
        }
        if (!file.isFile()) {
            throw new LocalAccessDeniedException(file.getAbsolute());
        }
        NSDictionary dict = NSDictionary.dictionaryWithContentsOfFile((String)file.getAbsolute());
        if (null == dict) {
            throw new AccessDeniedException(String.format("Failure parsing file %s", file.getName()));
        }
        return this.deserialize(dict);
    }

    public abstract S deserialize(NSDictionary var1);
}

