/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.proxy;

import ch.cyberduck.core.library.Native;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.AbstractProxyFinder;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxyFinder;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SystemConfigurationProxy
extends AbstractProxyFinder
implements ProxyFinder {
    private static final Logger log = LogManager.getLogger(SystemConfigurationProxy.class);
    private final Preferences preferences = PreferencesFactory.get();

    public Proxy find(String target) {
        String route = this.findNative(target);
        if (null == route) {
            if (log.isInfoEnabled()) {
                log.info(String.format("No proxy configuration found for target %s", target));
            }
            return Proxy.DIRECT;
        }
        try {
            URI proxy = new URI(route);
            try {
                return new Proxy(Proxy.Type.valueOf((String)StringUtils.upperCase((String)proxy.getScheme())), proxy.getHost(), proxy.getPort());
            }
            catch (IllegalArgumentException e) {
                log.warn(String.format("Unsupported scheme for proxy %s", proxy));
            }
        }
        catch (URISyntaxException e) {
            log.warn(String.format("Invalid proxy configuration %s", route));
        }
        return Proxy.DIRECT;
    }

    public native String findNative(String var1);

    static {
        Native.load((String)"core");
    }
}

