/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.preferences;

import ch.cyberduck.binding.foundation.NSBundle;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.local.FinderLocal;
import ch.cyberduck.core.preferences.ApplicationResourcesFinder;
import ch.cyberduck.core.preferences.TemporarySupportDirectoryFinder;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BundleApplicationResourcesFinder
implements ApplicationResourcesFinder {
    private static final Logger log = LogManager.getLogger(BundleApplicationResourcesFinder.class);
    private NSBundle cached;

    public Local find() {
        NSBundle b = this.bundle();
        if (null == b) {
            log.warn("No main bundle found");
            return new TemporarySupportDirectoryFinder().find();
        }
        FinderLocal folder = new FinderLocal(b.resourcePath());
        if (log.isDebugEnabled()) {
            log.debug(String.format("Use folder %s for application resources directory", new Object[]{folder}));
        }
        return folder;
    }

    public NSBundle bundle() {
        NSBundle main;
        if (this.cached != null) {
            return this.cached;
        }
        if (log.isInfoEnabled()) {
            log.info("Loading application bundle resources");
        }
        if (null == (main = NSBundle.mainBundle())) {
            this.cached = null;
        } else {
            FinderLocal executable = new FinderLocal(main.executablePath());
            this.cached = this.bundle(main, executable);
        }
        return this.cached;
    }

    protected NSBundle bundle(NSBundle main, Local executable) {
        NSBundle b;
        if (!executable.isSymbolicLink()) {
            return main;
        }
        while (executable.isSymbolicLink()) {
            try {
                executable = executable.getSymlinkTarget();
            }
            catch (NotfoundException e) {
                return main;
            }
        }
        Local folder = executable.getParent();
        do {
            if (null == (b = NSBundle.bundleWithPath((String)folder.getAbsolute()))) {
                log.error(String.format("Loading bundle %s failed", folder));
                break;
            }
            if (StringUtils.equals((CharSequence)String.valueOf('/'), (CharSequence)b.bundlePath())) break;
            folder = folder.getParent();
        } while (b.executablePath() == null);
        return b;
    }
}

