/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.preferences;

import ch.cyberduck.binding.foundation.FoundationKitFunctions;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.local.FinderLocal;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.cocoa.foundation.NSUInteger;

public class ApplicationSupportDirectoryFinder
implements SupportDirectoryFinder {
    private static final Logger log = LogManager.getLogger(ApplicationSupportDirectoryFinder.class);
    private final Preferences preferences = PreferencesFactory.get();

    public Local find() {
        NSArray directories = FoundationKitFunctions.library.NSSearchPathForDirectoriesInDomains(14, 1, true);
        String application = this.preferences.getProperty("application.name");
        if (directories.count().intValue() == 0) {
            log.error("Failed searching for application support directory");
            return new FinderLocal("~/Library/Application Support", application);
        }
        String directory = directories.objectAtIndex(new NSUInteger(0L)).toString();
        if (log.isInfoEnabled()) {
            log.info(String.format("Found application support directory in %s", directory));
        }
        FinderLocal folder = new FinderLocal(directory, application);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Use folder %s for application support directory", new Object[]{folder}));
        }
        return folder;
    }
}

