/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.logging;

import ch.cyberduck.core.library.Native;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;

public class UnifiedSystemLogAppender
extends AbstractAppender {
    public static final int OS_LOG_TYPE_DEFAULT = 0;
    public static final int OS_LOG_TYPE_INFO = 1;
    public static final int OS_LOG_TYPE_DEBUG = 2;
    public static final int OS_LOG_TYPE_ERROR = 16;
    public static final int OS_LOG_TYPE_FAULT = 17;

    public UnifiedSystemLogAppender() {
        super(UnifiedSystemLogAppender.class.getName(), null, null, true, Property.EMPTY_ARRAY);
    }

    public void append(LogEvent event) {
        Throwable thrown;
        if (null == event.getMessage()) {
            return;
        }
        String logger = String.format("%s %s", event.getThreadName(), event.getLoggerName());
        Level level = event.getLevel();
        if (Level.FATAL.equals((Object)level) || Level.ERROR.equals((Object)level)) {
            this.log(16, logger, event.getMessage().toString());
        } else if (Level.TRACE.equals((Object)level)) {
            this.log(2, logger, event.getMessage().toString());
        } else if (Level.DEBUG.equals((Object)level) || Level.INFO.equals((Object)level)) {
            this.log(1, logger, event.getMessage().toString());
        } else {
            this.log(0, logger, event.getMessage().toString());
        }
        if (this.ignoreExceptions() && (thrown = event.getThrown()) != null) {
            String[] trace;
            for (String t : trace = ExceptionUtils.getStackFrames((Throwable)thrown)) {
                this.log(0, logger, t);
            }
        }
    }

    public native void log(int var1, String var2, String var3);

    static {
        Native.load((String)"core");
    }
}

