/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.logging;

import ch.cyberduck.binding.foundation.FoundationKitFunctions;
import com.sun.jna.Native;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.util.Strings;
import org.rococoa.internal.RococoaTypeMapper;

public class SystemLogAppender
extends AbstractAppender {
    private static final FoundationKitFunctions library = (FoundationKitFunctions)Native.load((String)"Foundation", FoundationKitFunctions.class, Collections.singletonMap("type-mapper", new RococoaTypeMapper()));

    public SystemLogAppender(Layout layout) {
        super(SystemLogAppender.class.getName(), null, layout, true, Property.EMPTY_ARRAY);
    }

    public void append(LogEvent event) {
        Throwable thrown;
        if (null == event.getMessage()) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(new String(this.getLayout().toByteArray(event), StandardCharsets.UTF_8));
        if (this.ignoreExceptions() && (thrown = event.getThrown()) != null) {
            String[] trace;
            buffer.append(Strings.LINE_SEPARATOR);
            for (String t : trace = ExceptionUtils.getStackFrames((Throwable)thrown)) {
                buffer.append(t).append(Strings.LINE_SEPARATOR);
            }
        }
        library.NSLog("%@", new String[]{buffer.toString()});
    }
}

