/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.binding.application.NSWorkspace;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.local.features.Trash;
import ch.cyberduck.core.unicode.NFDNormalizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkspaceTrashFeature
implements Trash {
    private static final Logger log = LogManager.getLogger(WorkspaceTrashFeature.class);
    private final NSWorkspace workspace = NSWorkspace.sharedWorkspace();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trash(Local file) throws LocalAccessDeniedException {
        Class<NSWorkspace> clazz = NSWorkspace.class;
        synchronized (NSWorkspace.class) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Move %s to Trash", file));
            }
            if (!this.workspace.performFileOperation("recycle", new NFDNormalizer().normalize((CharSequence)file.getParent().getAbsolute()).toString(), "", NSArray.arrayWithObject((String)new NFDNormalizer().normalize((CharSequence)file.getName()).toString()))) {
                throw new LocalAccessDeniedException(String.format("Failed to move %s to Trash", file.getName()));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

