/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.binding.foundation.NSFileManager;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.local.features.Symlink;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.ObjCObjectByReference;
import org.rococoa.cocoa.foundation.NSError;

public class WorkspaceSymlinkFeature
implements Symlink {
    private static final Logger log = LogManager.getLogger(WorkspaceSymlinkFeature.class);

    public void symlink(Local file, String target) throws AccessDeniedException {
        ObjCObjectByReference error = new ObjCObjectByReference();
        boolean success = NSFileManager.defaultManager().createSymbolicLinkAtPath_withDestinationPath_error(file.getAbsolute(), target, error);
        if (!success) {
            NSError f = (NSError)error.getValueAs(NSError.class);
            if (null == f) {
                throw new LocalAccessDeniedException(String.format("%s %s", LocaleFactory.localizedString((String)"Cannot create file", (String)"Error"), file.getAbsolute()));
            }
            throw new LocalAccessDeniedException(String.format("%s", f.localizedDescription()));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Created symbolic link %s with target %s", file, target));
        }
    }
}

