/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.binding.application.NSWorkspace;
import ch.cyberduck.binding.foundation.NSDistributedNotificationCenter;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationLauncher;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class WorkspaceApplicationLauncher
implements ApplicationLauncher {
    private static final Logger log = LogManager.getLogger(WorkspaceApplicationLauncher.class);
    private final NSWorkspace workspace = NSWorkspace.sharedWorkspace();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(Local file) {
        Class<NSWorkspace> clazz = NSWorkspace.class;
        synchronized (NSWorkspace.class) {
            if (!this.workspace.openFile(file.getAbsolute())) {
                log.warn(String.format("Error opening file %s", file));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(Local file, Application application) {
        Class<NSWorkspace> clazz = NSWorkspace.class;
        synchronized (NSWorkspace.class) {
            String path = this.workspace.absolutePathForAppBundleWithIdentifier(application.getIdentifier());
            if (StringUtils.isNotBlank((CharSequence)path) && this.workspace.openFile(file.getAbsolute(), path)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            log.warn(String.format("Error opening file %s with application %s", file, application));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(Application application, String args) {
        Class<NSWorkspace> clazz = NSWorkspace.class;
        synchronized (NSWorkspace.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.workspace.launchApplication(application.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bounce(Local file) {
        Class<NSWorkspace> clazz = NSWorkspace.class;
        synchronized (NSWorkspace.class) {
            NSDistributedNotificationCenter.defaultCenter().postNotification(NSNotification.notificationWithName((String)"com.apple.DownloadFileFinished", (String)file.getAbsolute()));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

