/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.binding.foundation.NSFileManager;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.library.Native;
import ch.cyberduck.core.local.FilesystemBookmarkResolver;
import ch.cyberduck.core.local.FilesystemBookmarkResolverFactory;
import ch.cyberduck.core.local.FinderLocalAttributes;
import ch.cyberduck.core.local.TildeExpander;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.output.ProxyOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.Foundation;

public class FinderLocal
extends Local {
    private static final Logger log = LogManager.getLogger(FinderLocal.class);
    private final FilesystemBookmarkResolver<NSURL> resolver;

    public FinderLocal(Local parent, String name) {
        this(parent, name, FilesystemBookmarkResolverFactory.get());
    }

    public FinderLocal(Local parent, String name, FilesystemBookmarkResolver<NSURL> resolver) {
        super(parent, name);
        this.resolver = resolver;
    }

    public FinderLocal(String parent, String name) {
        this(parent, name, FilesystemBookmarkResolverFactory.get());
    }

    public FinderLocal(String parent, String name, FilesystemBookmarkResolver<NSURL> resolver) {
        super(parent, name);
        this.resolver = resolver;
    }

    public FinderLocal(String path) {
        this(FinderLocal.resolveAlias(new TildeExpander().expand(path)), FilesystemBookmarkResolverFactory.get());
    }

    public FinderLocal(String name, FilesystemBookmarkResolver<NSURL> resolver) {
        super(name);
        this.resolver = resolver;
    }

    public <T> T serialize(Serializer<T> dict) {
        dict.setStringForKey(this.getAbbreviatedPath(), "Path");
        dict.setStringForKey(this.getBookmark(), "Bookmark");
        return (T)dict.getSerialized();
    }

    public String getDisplayName() {
        return NSFileManager.defaultManager().displayNameAtPath(this.getName());
    }

    public String getAbbreviatedPath() {
        return new TildeExpander().abbreviate(this.getAbsolute());
    }

    public Local getVolume() {
        Local parent = this.getParent();
        while (!parent.isRoot()) {
            Local directory = parent.getParent();
            if (null == directory) {
                return super.getVolume();
            }
            if ("/Volumes".equals(directory.getAbsolute())) {
                return parent;
            }
            parent = parent.getParent();
        }
        return super.getVolume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(LinkOption ... options) {
        NSURL resolved = null;
        try {
            resolved = this.lock(false);
            if (null == resolved) {
                boolean bl = super.exists(options);
                return bl;
            }
            boolean bl = Files.exists(Paths.get(resolved.path(), new String[0]), new LinkOption[0]);
            return bl;
        }
        catch (AccessDeniedException e) {
            boolean bl = super.exists(options);
            return bl;
        }
        finally {
            this.release(resolved);
        }
    }

    public String getBookmark() {
        String path = this.getAbbreviatedPath();
        String bookmark = PreferencesFactory.get().getProperty(String.format("local.bookmark.%s", path));
        if (StringUtils.isBlank((CharSequence)bookmark)) {
            try {
                bookmark = this.resolver.create((Local)this);
            }
            catch (AccessDeniedException e) {
                log.warn(String.format("Failure resolving bookmark for %s. %s", new Object[]{this, e}));
            }
        }
        return bookmark;
    }

    public void setBookmark(String data) {
        String path = this.getAbbreviatedPath();
        PreferencesFactory.get().setProperty(String.format("local.bookmark.%s", path), data);
    }

    public AttributedList<Local> list(Filter<String> filter) throws AccessDeniedException {
        try {
            NSURL resolved = this.lock(true);
            if (null == resolved) {
                return super.list(filter);
            }
            AttributedList list = super.list(resolved.path(), filter);
            this.release(resolved);
            return list;
        }
        catch (LocalAccessDeniedException e) {
            log.warn(String.format("Failure obtaining lock for %s. %s", new Object[]{this, e}));
            return super.list(filter);
        }
    }

    public OutputStream getOutputStream(boolean append) throws AccessDeniedException {
        NSURL resolved;
        try {
            resolved = this.lock(this.exists());
            if (null == resolved) {
                return super.getOutputStream(append);
            }
        }
        catch (LocalAccessDeniedException e) {
            log.warn(String.format("Failure obtaining lock for %s. %s", new Object[]{this, e}));
            return super.getOutputStream(append);
        }
        return new LockReleaseProxyOutputStream(super.getOutputStream(resolved.path(), append), resolved, append);
    }

    public NSURL lock(boolean interactive) throws AccessDeniedException {
        NSURL resolved = (NSURL)this.resolver.resolve((Local)this, interactive);
        if (null == resolved) {
            return null;
        }
        if (resolved.respondsToSelector(Foundation.selector((String)"startAccessingSecurityScopedResource")) && !resolved.startAccessingSecurityScopedResource()) {
            throw new LocalAccessDeniedException(String.format("Failure accessing security scoped resource for %s", new Object[]{this}));
        }
        return resolved;
    }

    public void release(Object lock) {
        if (null == lock) {
            return;
        }
        NSURL resolved = (NSURL)lock;
        if (resolved.respondsToSelector(Foundation.selector((String)"stopAccessingSecurityScopedResource"))) {
            resolved.stopAccessingSecurityScopedResource();
        }
    }

    public InputStream getInputStream() throws AccessDeniedException {
        NSURL resolved;
        try {
            resolved = this.lock(false);
            if (null == resolved) {
                return super.getInputStream();
            }
        }
        catch (LocalAccessDeniedException e) {
            log.warn(String.format("Failure obtaining lock for %s. %s", new Object[]{this, e}));
            return super.getInputStream();
        }
        return new LockReleaseProxyInputStream(super.getInputStream(resolved.path()), resolved);
    }

    private static String resolveAlias(String absolute) {
        if (PreferencesFactory.get().getBoolean("local.alias.resolve")) {
            return FinderLocal.resolveAliasNative(absolute);
        }
        return absolute;
    }

    private static native String resolveAliasNative(String var0);

    public FinderLocalAttributes attributes() {
        return new FinderLocalAttributes(this);
    }

    static {
        Native.load((String)"core");
    }

    private final class LockReleaseProxyOutputStream
    extends ProxyOutputStream {
        private final NSURL resolved;

        public LockReleaseProxyOutputStream(OutputStream proxy, NSURL resolved, boolean append) {
            super(proxy);
            this.resolved = resolved;
        }

        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                FinderLocal.this.release(this.resolved);
            }
        }
    }

    private final class LockReleaseProxyInputStream
    extends ProxyInputStream {
        private final NSURL resolved;

        public LockReleaseProxyInputStream(InputStream proxy, NSURL resolved) {
            super(proxy);
            this.resolved = resolved;
        }

        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                FinderLocal.this.release(this.resolved);
            }
        }
    }
}

