/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.binding.foundation.NSFileManager;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.local.features.Trash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rococoa.ObjCObjectByReference;
import org.rococoa.cocoa.foundation.NSError;

public class FileManagerTrashFeature
implements Trash {
    private static final Logger log = LogManager.getLogger(FileManagerTrashFeature.class);

    public void trash(Local file) throws LocalAccessDeniedException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Move %s to Trash", file));
        }
        ObjCObjectByReference error = new ObjCObjectByReference();
        if (!NSFileManager.defaultManager().trashItemAtURL_resultingItemURL_error(NSURL.fileURLWithPath((String)file.getAbsolute()), null, error)) {
            NSError f = (NSError)error.getValueAs(NSError.class);
            if (null == f) {
                throw new LocalAccessDeniedException(file.getAbsolute());
            }
            throw new LocalAccessDeniedException(String.format("%s", f.localizedDescription()));
        }
    }
}

