/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.impl.jna.PlistDeserializer;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CloudMounterBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static final Logger log = LogManager.getLogger(CloudMounterBookmarkCollection.class);

    public String getName() {
        return "CloudMounter";
    }

    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.cloudmounter.location"));
    }

    protected void parse(ProtocolFactory protocols, Local file) throws AccessDeniedException {
        NSDictionary serialized = NSDictionary.dictionaryWithContentsOfFile((String)file.getAbsolute());
        if (null == serialized) {
            throw new LocalAccessDeniedException(String.format("Invalid bookmark file %s", file));
        }
        List array = new PlistDeserializer(serialized).listForKey("CustomPluginSettings");
        if (null == array) {
            log.warn("Missing key CustomPluginSettings");
            return;
        }
        for (NSDictionary dict : array) {
            PlistDeserializer options;
            String hostname;
            Protocol protocol;
            PlistDeserializer bookmark = new PlistDeserializer(dict);
            String identifier = bookmark.stringForKey("MountFSClassName");
            if (StringUtils.isBlank((CharSequence)identifier)) {
                log.warn("Missing key MountFSClassName");
                continue;
            }
            switch (identifier) {
                case "FtpConnection": {
                    protocol = protocols.forType(Protocol.Type.ftp);
                    break;
                }
                case "WebDAVConnection": {
                    protocol = protocols.forType(Protocol.Type.dav);
                    break;
                }
                case "OpenStackConnection": {
                    protocol = protocols.forType(Protocol.Type.swift);
                    break;
                }
                case "BBConnection": {
                    protocol = protocols.forType(Protocol.Type.b2);
                    break;
                }
                case "S3Connection": {
                    protocol = protocols.forType(Protocol.Type.s3);
                    break;
                }
                case "DropboxConnection": {
                    protocol = protocols.forType(Protocol.Type.dropbox);
                    break;
                }
                case "GDriveConnection": {
                    protocol = protocols.forType(Protocol.Type.googledrive);
                    break;
                }
                default: {
                    protocol = null;
                }
            }
            if (null == protocol) {
                log.warn(String.format("Unable to determine protocol for %s", identifier));
                continue;
            }
            NSDictionary details = bookmark.objectForKey("MountFSOptions");
            if (null == details || StringUtils.isBlank((CharSequence)(hostname = (options = new PlistDeserializer(details)).stringForKey("host")))) continue;
            Host host = new Host(protocol, hostname, new Credentials(options.stringForKey("login")));
            host.setNickname(bookmark.stringForKey("MountFSLabel"));
            host.setDefaultPath(options.stringForKey("remotePath"));
            this.add(host);
        }
    }

    public String getBundleIdentifier() {
        return "com.eltima.cloudmounter";
    }
}

