/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.i18n;

import ch.cyberduck.core.i18n.BundleLocale;
import ch.cyberduck.core.i18n.RegexLocale;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.List;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BundleRegexLocale
extends BundleLocale {
    private static final Logger log = LogManager.getLogger((String)BundleRegexLocale.class.getName());
    private final RegexLocale fallback = new RegexLocale();

    public BundleRegexLocale() {
        List languages = PreferencesFactory.get().getList("AppleLanguages");
        if (!languages.isEmpty()) {
            try {
                this.fallback.setDefault(LocaleUtils.toLocale((String)StringUtils.replace((String)((String)languages.iterator().next()), (String)"-", (String)"_")).getLanguage());
            }
            catch (IllegalArgumentException e) {
                log.warn(String.format("Failure to parse default language set. %s", e.getMessage()));
            }
        }
    }

    @Override
    public void setDefault(String language) {
        this.fallback.setDefault(language);
        super.setDefault(language);
    }

    @Override
    public String localize(String key, String table) {
        String localized = super.localize(key, table);
        if (StringUtils.equals((CharSequence)localized, (CharSequence)key)) {
            return this.fallback.localize(key, table);
        }
        return localized;
    }
}

