/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.editor;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.editor.Editor;
import ch.cyberduck.core.editor.EditorFactory;
import ch.cyberduck.core.editor.FSEventWatchEditor;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinder;
import ch.cyberduck.core.local.ApplicationFinderFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FSEventWatchEditorFactory
extends EditorFactory {
    private final Set<Application> editors = new HashSet<Application>();
    private final ApplicationFinder finder = ApplicationFinderFactory.get();

    public FSEventWatchEditorFactory() {
        this.add(new Application("com.apple.TextEdit", "TextEdit"));
        this.add(new Application("com.apple.dt.Xcode", "Xcode"));
        this.add(new Application("de.codingmonkeys.SubEthaEdit", "SubEthaEdit"));
        this.add(new Application("de.codingmonkeys.SubEthaEdit.MacFULL", "SubEthaEdit"));
        this.add(new Application("com.barebones.bbedit", "BBEdit"));
        this.add(new Application("com.barebones.textwrangler", "TextWrangler"));
        this.add(new Application("com.macromates.TextMate", "TextMate"));
        this.add(new Application("com.macromates.TextMate.preview", "TextMate 2"));
        this.add(new Application("com.sublimetext.2", "Sublime Text 2"));
        this.add(new Application("com.sublimetext.3", "Sublime Text 3"));
        this.add(new Application("com.sublimetext.4", "Sublime Text 4"));
        this.add(new Application("com.github.atom", "Atom"));
        this.add(new Application("com.coteditor.CotEditor", "CotEditor"));
        this.add(new Application("com.microsoft.VSCode", "Visual Studio Code"));
        this.add(new Application("com.panic.Nova", "nova"));
        this.add(new Application("io.brackets.appshell", "Brackets"));
    }

    private void add(Application application) {
        if (this.finder.isInstalled(application)) {
            this.editors.add(application);
        }
    }

    public List<Application> getConfigured() {
        return new ArrayList<Application>(this.editors);
    }

    public Editor create(Host host, Path file, ProgressListener listener) {
        return new FSEventWatchEditor(host, file, listener);
    }
}

